/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The union type representing the allowed types of operands for a boolean condition.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RuleBooleanToEvaluate implements SdkPojo, Serializable,
        ToCopyableBuilder<RuleBooleanToEvaluate.Builder, RuleBooleanToEvaluate> {
    private static final SdkField<String> ATTRIBUTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Attribute").getter(getter(RuleBooleanToEvaluate::attributeAsString)).setter(setter(Builder::attribute))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Attribute").build()).build();

    private static final SdkField<Analysis> ANALYSIS_FIELD = SdkField.<Analysis> builder(MarshallingType.SDK_POJO)
            .memberName("Analysis").getter(getter(RuleBooleanToEvaluate::analysis)).setter(setter(Builder::analysis))
            .constructor(Analysis::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Analysis").build()).build();

    private static final SdkField<RuleIsInAddressList> IS_IN_ADDRESS_LIST_FIELD = SdkField
            .<RuleIsInAddressList> builder(MarshallingType.SDK_POJO).memberName("IsInAddressList")
            .getter(getter(RuleBooleanToEvaluate::isInAddressList)).setter(setter(Builder::isInAddressList))
            .constructor(RuleIsInAddressList::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsInAddressList").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTE_FIELD,
            ANALYSIS_FIELD, IS_IN_ADDRESS_LIST_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String attribute;

    private final Analysis analysis;

    private final RuleIsInAddressList isInAddressList;

    private final Type type;

    private RuleBooleanToEvaluate(BuilderImpl builder) {
        this.attribute = builder.attribute;
        this.analysis = builder.analysis;
        this.isInAddressList = builder.isInAddressList;
        this.type = builder.type;
    }

    /**
     * <p>
     * The boolean type representing the allowed attribute types for an email.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleBooleanEmailAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The boolean type representing the allowed attribute types for an email.
     * @see RuleBooleanEmailAttribute
     */
    public final RuleBooleanEmailAttribute attribute() {
        return RuleBooleanEmailAttribute.fromValue(attribute);
    }

    /**
     * <p>
     * The boolean type representing the allowed attribute types for an email.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #attribute} will
     * return {@link RuleBooleanEmailAttribute#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #attributeAsString}.
     * </p>
     * 
     * @return The boolean type representing the allowed attribute types for an email.
     * @see RuleBooleanEmailAttribute
     */
    public final String attributeAsString() {
        return attribute;
    }

    /**
     * <p>
     * The Add On ARN and its returned value to evaluate in a boolean condition expression.
     * </p>
     * 
     * @return The Add On ARN and its returned value to evaluate in a boolean condition expression.
     */
    public final Analysis analysis() {
        return analysis;
    }

    /**
     * <p>
     * The structure representing the address lists and address list attribute that will be used in evaluation of
     * boolean expression.
     * </p>
     * 
     * @return The structure representing the address lists and address list attribute that will be used in evaluation
     *         of boolean expression.
     */
    public final RuleIsInAddressList isInAddressList() {
        return isInAddressList;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(attributeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(analysis());
        hashCode = 31 * hashCode + Objects.hashCode(isInAddressList());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RuleBooleanToEvaluate)) {
            return false;
        }
        RuleBooleanToEvaluate other = (RuleBooleanToEvaluate) obj;
        return Objects.equals(attributeAsString(), other.attributeAsString()) && Objects.equals(analysis(), other.analysis())
                && Objects.equals(isInAddressList(), other.isInAddressList());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RuleBooleanToEvaluate").add("Attribute", attributeAsString()).add("Analysis", analysis())
                .add("IsInAddressList", isInAddressList()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Attribute":
            return Optional.ofNullable(clazz.cast(attributeAsString()));
        case "Analysis":
            return Optional.ofNullable(clazz.cast(analysis()));
        case "IsInAddressList":
            return Optional.ofNullable(clazz.cast(isInAddressList()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #attributeAsString()} initialized to the given value.
     *
     * <p>
     * The boolean type representing the allowed attribute types for an email.
     * </p>
     * 
     * @param attribute
     *        The boolean type representing the allowed attribute types for an email.
     * @see RuleBooleanEmailAttribute
     */
    public static RuleBooleanToEvaluate fromAttribute(String attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Create an instance of this class with {@link #attributeAsString()} initialized to the given value.
     *
     * <p>
     * The boolean type representing the allowed attribute types for an email.
     * </p>
     * 
     * @param attribute
     *        The boolean type representing the allowed attribute types for an email.
     * @see RuleBooleanEmailAttribute
     */
    public static RuleBooleanToEvaluate fromAttribute(RuleBooleanEmailAttribute attribute) {
        return builder().attribute(attribute).build();
    }

    /**
     * Create an instance of this class with {@link #analysis()} initialized to the given value.
     *
     * <p>
     * The Add On ARN and its returned value to evaluate in a boolean condition expression.
     * </p>
     * 
     * @param analysis
     *        The Add On ARN and its returned value to evaluate in a boolean condition expression.
     */
    public static RuleBooleanToEvaluate fromAnalysis(Analysis analysis) {
        return builder().analysis(analysis).build();
    }

    /**
     * Create an instance of this class with {@link #analysis()} initialized to the given value.
     *
     * <p>
     * The Add On ARN and its returned value to evaluate in a boolean condition expression.
     * </p>
     * 
     * @param analysis
     *        The Add On ARN and its returned value to evaluate in a boolean condition expression.
     */
    public static RuleBooleanToEvaluate fromAnalysis(Consumer<Analysis.Builder> analysis) {
        Analysis.Builder builder = Analysis.builder();
        analysis.accept(builder);
        return fromAnalysis(builder.build());
    }

    /**
     * Create an instance of this class with {@link #isInAddressList()} initialized to the given value.
     *
     * <p>
     * The structure representing the address lists and address list attribute that will be used in evaluation of
     * boolean expression.
     * </p>
     * 
     * @param isInAddressList
     *        The structure representing the address lists and address list attribute that will be used in evaluation of
     *        boolean expression.
     */
    public static RuleBooleanToEvaluate fromIsInAddressList(RuleIsInAddressList isInAddressList) {
        return builder().isInAddressList(isInAddressList).build();
    }

    /**
     * Create an instance of this class with {@link #isInAddressList()} initialized to the given value.
     *
     * <p>
     * The structure representing the address lists and address list attribute that will be used in evaluation of
     * boolean expression.
     * </p>
     * 
     * @param isInAddressList
     *        The structure representing the address lists and address list attribute that will be used in evaluation of
     *        boolean expression.
     */
    public static RuleBooleanToEvaluate fromIsInAddressList(Consumer<RuleIsInAddressList.Builder> isInAddressList) {
        RuleIsInAddressList.Builder builder = RuleIsInAddressList.builder();
        isInAddressList.accept(builder);
        return fromIsInAddressList(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Attribute", ATTRIBUTE_FIELD);
        map.put("Analysis", ANALYSIS_FIELD);
        map.put("IsInAddressList", IS_IN_ADDRESS_LIST_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RuleBooleanToEvaluate, T> g) {
        return obj -> g.apply((RuleBooleanToEvaluate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RuleBooleanToEvaluate> {
        /**
         * <p>
         * The boolean type representing the allowed attribute types for an email.
         * </p>
         * 
         * @param attribute
         *        The boolean type representing the allowed attribute types for an email.
         * @see RuleBooleanEmailAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleBooleanEmailAttribute
         */
        Builder attribute(String attribute);

        /**
         * <p>
         * The boolean type representing the allowed attribute types for an email.
         * </p>
         * 
         * @param attribute
         *        The boolean type representing the allowed attribute types for an email.
         * @see RuleBooleanEmailAttribute
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RuleBooleanEmailAttribute
         */
        Builder attribute(RuleBooleanEmailAttribute attribute);

        /**
         * <p>
         * The Add On ARN and its returned value to evaluate in a boolean condition expression.
         * </p>
         * 
         * @param analysis
         *        The Add On ARN and its returned value to evaluate in a boolean condition expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder analysis(Analysis analysis);

        /**
         * <p>
         * The Add On ARN and its returned value to evaluate in a boolean condition expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link Analysis.Builder} avoiding the need to
         * create one manually via {@link Analysis#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Analysis.Builder#build()} is called immediately and its result is
         * passed to {@link #analysis(Analysis)}.
         * 
         * @param analysis
         *        a consumer that will call methods on {@link Analysis.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #analysis(Analysis)
         */
        default Builder analysis(Consumer<Analysis.Builder> analysis) {
            return analysis(Analysis.builder().applyMutation(analysis).build());
        }

        /**
         * <p>
         * The structure representing the address lists and address list attribute that will be used in evaluation of
         * boolean expression.
         * </p>
         * 
         * @param isInAddressList
         *        The structure representing the address lists and address list attribute that will be used in
         *        evaluation of boolean expression.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isInAddressList(RuleIsInAddressList isInAddressList);

        /**
         * <p>
         * The structure representing the address lists and address list attribute that will be used in evaluation of
         * boolean expression.
         * </p>
         * This is a convenience method that creates an instance of the {@link RuleIsInAddressList.Builder} avoiding the
         * need to create one manually via {@link RuleIsInAddressList#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RuleIsInAddressList.Builder#build()} is called immediately and
         * its result is passed to {@link #isInAddressList(RuleIsInAddressList)}.
         * 
         * @param isInAddressList
         *        a consumer that will call methods on {@link RuleIsInAddressList.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #isInAddressList(RuleIsInAddressList)
         */
        default Builder isInAddressList(Consumer<RuleIsInAddressList.Builder> isInAddressList) {
            return isInAddressList(RuleIsInAddressList.builder().applyMutation(isInAddressList).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String attribute;

        private Analysis analysis;

        private RuleIsInAddressList isInAddressList;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(RuleBooleanToEvaluate model) {
            attribute(model.attribute);
            analysis(model.analysis);
            isInAddressList(model.isInAddressList);
        }

        public final String getAttribute() {
            return attribute;
        }

        public final void setAttribute(String attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
        }

        @Override
        public final Builder attribute(String attribute) {
            Object oldValue = this.attribute;
            this.attribute = attribute;
            handleUnionValueChange(Type.ATTRIBUTE, oldValue, this.attribute);
            return this;
        }

        @Override
        public final Builder attribute(RuleBooleanEmailAttribute attribute) {
            this.attribute(attribute == null ? null : attribute.toString());
            return this;
        }

        public final Analysis.Builder getAnalysis() {
            return analysis != null ? analysis.toBuilder() : null;
        }

        public final void setAnalysis(Analysis.BuilderImpl analysis) {
            Object oldValue = this.analysis;
            this.analysis = analysis != null ? analysis.build() : null;
            handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
        }

        @Override
        public final Builder analysis(Analysis analysis) {
            Object oldValue = this.analysis;
            this.analysis = analysis;
            handleUnionValueChange(Type.ANALYSIS, oldValue, this.analysis);
            return this;
        }

        public final RuleIsInAddressList.Builder getIsInAddressList() {
            return isInAddressList != null ? isInAddressList.toBuilder() : null;
        }

        public final void setIsInAddressList(RuleIsInAddressList.BuilderImpl isInAddressList) {
            Object oldValue = this.isInAddressList;
            this.isInAddressList = isInAddressList != null ? isInAddressList.build() : null;
            handleUnionValueChange(Type.IS_IN_ADDRESS_LIST, oldValue, this.isInAddressList);
        }

        @Override
        public final Builder isInAddressList(RuleIsInAddressList isInAddressList) {
            Object oldValue = this.isInAddressList;
            this.isInAddressList = isInAddressList;
            handleUnionValueChange(Type.IS_IN_ADDRESS_LIST, oldValue, this.isInAddressList);
            return this;
        }

        @Override
        public RuleBooleanToEvaluate build() {
            return new RuleBooleanToEvaluate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see RuleBooleanToEvaluate#type()
     */
    public enum Type {
        ATTRIBUTE,

        ANALYSIS,

        IS_IN_ADDRESS_LIST,

        UNKNOWN_TO_SDK_VERSION
    }
}
