/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.mailmanager.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The request to update properties of an existing email archive.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateArchiveRequest extends MailManagerRequest implements
        ToCopyableBuilder<UpdateArchiveRequest.Builder, UpdateArchiveRequest> {
    private static final SdkField<String> ARCHIVE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveId").getter(getter(UpdateArchiveRequest::archiveId)).setter(setter(Builder::archiveId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveId").build()).build();

    private static final SdkField<String> ARCHIVE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ArchiveName").getter(getter(UpdateArchiveRequest::archiveName)).setter(setter(Builder::archiveName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ArchiveName").build()).build();

    private static final SdkField<ArchiveRetention> RETENTION_FIELD = SdkField
            .<ArchiveRetention> builder(MarshallingType.SDK_POJO).memberName("Retention")
            .getter(getter(UpdateArchiveRequest::retention)).setter(setter(Builder::retention))
            .constructor(ArchiveRetention::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Retention").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARCHIVE_ID_FIELD,
            ARCHIVE_NAME_FIELD, RETENTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String archiveId;

    private final String archiveName;

    private final ArchiveRetention retention;

    private UpdateArchiveRequest(BuilderImpl builder) {
        super(builder);
        this.archiveId = builder.archiveId;
        this.archiveName = builder.archiveName;
        this.retention = builder.retention;
    }

    /**
     * <p>
     * The identifier of the archive to update.
     * </p>
     * 
     * @return The identifier of the archive to update.
     */
    public final String archiveId() {
        return archiveId;
    }

    /**
     * <p>
     * A new, unique name for the archive.
     * </p>
     * 
     * @return A new, unique name for the archive.
     */
    public final String archiveName() {
        return archiveName;
    }

    /**
     * <p>
     * A new retention period for emails in the archive.
     * </p>
     * 
     * @return A new retention period for emails in the archive.
     */
    public final ArchiveRetention retention() {
        return retention;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(archiveId());
        hashCode = 31 * hashCode + Objects.hashCode(archiveName());
        hashCode = 31 * hashCode + Objects.hashCode(retention());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateArchiveRequest)) {
            return false;
        }
        UpdateArchiveRequest other = (UpdateArchiveRequest) obj;
        return Objects.equals(archiveId(), other.archiveId()) && Objects.equals(archiveName(), other.archiveName())
                && Objects.equals(retention(), other.retention());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateArchiveRequest").add("ArchiveId", archiveId()).add("ArchiveName", archiveName())
                .add("Retention", retention()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ArchiveId":
            return Optional.ofNullable(clazz.cast(archiveId()));
        case "ArchiveName":
            return Optional.ofNullable(clazz.cast(archiveName()));
        case "Retention":
            return Optional.ofNullable(clazz.cast(retention()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ArchiveId", ARCHIVE_ID_FIELD);
        map.put("ArchiveName", ARCHIVE_NAME_FIELD);
        map.put("Retention", RETENTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateArchiveRequest, T> g) {
        return obj -> g.apply((UpdateArchiveRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends MailManagerRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateArchiveRequest> {
        /**
         * <p>
         * The identifier of the archive to update.
         * </p>
         * 
         * @param archiveId
         *        The identifier of the archive to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveId(String archiveId);

        /**
         * <p>
         * A new, unique name for the archive.
         * </p>
         * 
         * @param archiveName
         *        A new, unique name for the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder archiveName(String archiveName);

        /**
         * <p>
         * A new retention period for emails in the archive.
         * </p>
         * 
         * @param retention
         *        A new retention period for emails in the archive.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder retention(ArchiveRetention retention);

        /**
         * <p>
         * A new retention period for emails in the archive.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArchiveRetention.Builder} avoiding the
         * need to create one manually via {@link ArchiveRetention#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArchiveRetention.Builder#build()} is called immediately and its
         * result is passed to {@link #retention(ArchiveRetention)}.
         * 
         * @param retention
         *        a consumer that will call methods on {@link ArchiveRetention.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #retention(ArchiveRetention)
         */
        default Builder retention(Consumer<ArchiveRetention.Builder> retention) {
            return retention(ArchiveRetention.builder().applyMutation(retention).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends MailManagerRequest.BuilderImpl implements Builder {
        private String archiveId;

        private String archiveName;

        private ArchiveRetention retention;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateArchiveRequest model) {
            super(model);
            archiveId(model.archiveId);
            archiveName(model.archiveName);
            retention(model.retention);
        }

        public final String getArchiveId() {
            return archiveId;
        }

        public final void setArchiveId(String archiveId) {
            this.archiveId = archiveId;
        }

        @Override
        public final Builder archiveId(String archiveId) {
            this.archiveId = archiveId;
            return this;
        }

        public final String getArchiveName() {
            return archiveName;
        }

        public final void setArchiveName(String archiveName) {
            this.archiveName = archiveName;
        }

        @Override
        public final Builder archiveName(String archiveName) {
            this.archiveName = archiveName;
            return this;
        }

        public final ArchiveRetention.Builder getRetention() {
            return retention != null ? retention.toBuilder() : null;
        }

        public final void setRetention(ArchiveRetention.BuilderImpl retention) {
            this.retention = retention != null ? retention.build() : null;
        }

        @Override
        public final Builder retention(ArchiveRetention retention) {
            this.retention = retention;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateArchiveRequest build() {
            return new UpdateArchiveRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
