/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListProposalsResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<ListProposalsResponse.Builder, ListProposalsResponse> {
    private static final SdkField<List<ProposalSummary>> PROPOSALS_FIELD = SdkField
            .<List<ProposalSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListProposalsResponse::proposals))
            .setter(setter(Builder::proposals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Proposals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ProposalSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(ProposalSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListProposalsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSALS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ProposalSummary> proposals;

    private final String nextToken;

    private ListProposalsResponse(BuilderImpl builder) {
        super(builder);
        this.proposals = builder.proposals;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * The summary of each proposal made on the network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The summary of each proposal made on the network.
     */
    public List<ProposalSummary> proposals() {
        return proposals;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(proposals());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListProposalsResponse)) {
            return false;
        }
        ListProposalsResponse other = (ListProposalsResponse) obj;
        return Objects.equals(proposals(), other.proposals()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListProposalsResponse").add("Proposals", proposals()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Proposals":
            return Optional.ofNullable(clazz.cast(proposals()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListProposalsResponse, T> g) {
        return obj -> g.apply((ListProposalsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListProposalsResponse> {
        /**
         * <p>
         * The summary of each proposal made on the network.
         * </p>
         * 
         * @param proposals
         *        The summary of each proposal made on the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposals(Collection<ProposalSummary> proposals);

        /**
         * <p>
         * The summary of each proposal made on the network.
         * </p>
         * 
         * @param proposals
         *        The summary of each proposal made on the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposals(ProposalSummary... proposals);

        /**
         * <p>
         * The summary of each proposal made on the network.
         * </p>
         * This is a convenience that creates an instance of the {@link List<ProposalSummary>.Builder} avoiding the need
         * to create one manually via {@link List<ProposalSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ProposalSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #proposals(List<ProposalSummary>)}.
         * 
         * @param proposals
         *        a consumer that will call methods on {@link List<ProposalSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #proposals(List<ProposalSummary>)
         */
        Builder proposals(Consumer<ProposalSummary.Builder>... proposals);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private List<ProposalSummary> proposals = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListProposalsResponse model) {
            super(model);
            proposals(model.proposals);
            nextToken(model.nextToken);
        }

        public final Collection<ProposalSummary.Builder> getProposals() {
            return proposals != null ? proposals.stream().map(ProposalSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder proposals(Collection<ProposalSummary> proposals) {
            this.proposals = ProposalSummaryListCopier.copy(proposals);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposals(ProposalSummary... proposals) {
            proposals(Arrays.asList(proposals));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder proposals(Consumer<ProposalSummary.Builder>... proposals) {
            proposals(Stream.of(proposals).map(c -> ProposalSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setProposals(Collection<ProposalSummary.BuilderImpl> proposals) {
            this.proposals = ProposalSummaryListCopier.copyFromBuilder(proposals);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListProposalsResponse build() {
            return new ListProposalsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
