/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.Edition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFabricConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFabricConfiguration> {
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(NetworkFabricConfiguration.getter(NetworkFabricConfiguration::editionAsString)).setter(NetworkFabricConfiguration.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String edition;

    private NetworkFabricConfiguration(BuilderImpl builder) {
        this.edition = builder.edition;
    }

    public Edition edition() {
        return Edition.fromValue(this.edition);
    }

    public String editionAsString() {
        return this.edition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFabricConfiguration)) {
            return false;
        }
        NetworkFabricConfiguration other = (NetworkFabricConfiguration)obj;
        return Objects.equals(this.editionAsString(), other.editionAsString());
    }

    public String toString() {
        return ToString.builder((String)"NetworkFabricConfiguration").add("Edition", (Object)this.editionAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFabricConfiguration, T> g) {
        return obj -> g.apply((NetworkFabricConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String edition;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFabricConfiguration model) {
            this.edition(model.edition);
        }

        public final String getEditionAsString() {
            return this.edition;
        }

        @Override
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        public NetworkFabricConfiguration build() {
            return new NetworkFabricConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFabricConfiguration> {
        public Builder edition(String var1);

        public Builder edition(Edition var1);
    }
}

