/*
 * Copyright 2015-2020 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network that uses Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeFabricAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeFabricAttributes.Builder, NodeFabricAttributes> {
    private static final SdkField<String> PEER_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NodeFabricAttributes::peerEndpoint)).setter(setter(Builder::peerEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerEndpoint").build()).build();

    private static final SdkField<String> PEER_EVENT_ENDPOINT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(NodeFabricAttributes::peerEventEndpoint)).setter(setter(Builder::peerEventEndpoint))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PeerEventEndpoint").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PEER_ENDPOINT_FIELD,
            PEER_EVENT_ENDPOINT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String peerEndpoint;

    private final String peerEventEndpoint;

    private NodeFabricAttributes(BuilderImpl builder) {
        this.peerEndpoint = builder.peerEndpoint;
        this.peerEventEndpoint = builder.peerEventEndpoint;
    }

    /**
     * <p>
     * The endpoint that identifies the peer node for all services except peer channel-based event services.
     * </p>
     * 
     * @return The endpoint that identifies the peer node for all services except peer channel-based event services.
     */
    public String peerEndpoint() {
        return peerEndpoint;
    }

    /**
     * <p>
     * The endpoint that identifies the peer node for peer channel-based event services.
     * </p>
     * 
     * @return The endpoint that identifies the peer node for peer channel-based event services.
     */
    public String peerEventEndpoint() {
        return peerEventEndpoint;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(peerEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(peerEventEndpoint());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeFabricAttributes)) {
            return false;
        }
        NodeFabricAttributes other = (NodeFabricAttributes) obj;
        return Objects.equals(peerEndpoint(), other.peerEndpoint())
                && Objects.equals(peerEventEndpoint(), other.peerEventEndpoint());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("NodeFabricAttributes").add("PeerEndpoint", peerEndpoint())
                .add("PeerEventEndpoint", peerEventEndpoint()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PeerEndpoint":
            return Optional.ofNullable(clazz.cast(peerEndpoint()));
        case "PeerEventEndpoint":
            return Optional.ofNullable(clazz.cast(peerEventEndpoint()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeFabricAttributes, T> g) {
        return obj -> g.apply((NodeFabricAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeFabricAttributes> {
        /**
         * <p>
         * The endpoint that identifies the peer node for all services except peer channel-based event services.
         * </p>
         * 
         * @param peerEndpoint
         *        The endpoint that identifies the peer node for all services except peer channel-based event services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerEndpoint(String peerEndpoint);

        /**
         * <p>
         * The endpoint that identifies the peer node for peer channel-based event services.
         * </p>
         * 
         * @param peerEventEndpoint
         *        The endpoint that identifies the peer node for peer channel-based event services.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder peerEventEndpoint(String peerEventEndpoint);
    }

    static final class BuilderImpl implements Builder {
        private String peerEndpoint;

        private String peerEventEndpoint;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeFabricAttributes model) {
            peerEndpoint(model.peerEndpoint);
            peerEventEndpoint(model.peerEventEndpoint);
        }

        public final String getPeerEndpoint() {
            return peerEndpoint;
        }

        @Override
        public final Builder peerEndpoint(String peerEndpoint) {
            this.peerEndpoint = peerEndpoint;
            return this;
        }

        public final void setPeerEndpoint(String peerEndpoint) {
            this.peerEndpoint = peerEndpoint;
        }

        public final String getPeerEventEndpoint() {
            return peerEventEndpoint;
        }

        @Override
        public final Builder peerEventEndpoint(String peerEventEndpoint) {
            this.peerEventEndpoint = peerEventEndpoint;
            return this;
        }

        public final void setPeerEventEndpoint(String peerEventEndpoint) {
            this.peerEventEndpoint = peerEventEndpoint;
        }

        @Override
        public NodeFabricAttributes build() {
            return new NodeFabricAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
