/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A summary of configuration properties for a member.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberSummary implements SdkPojo, Serializable, ToCopyableBuilder<MemberSummary.Builder, MemberSummary> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Id")
            .getter(getter(MemberSummary::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MemberSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(MemberSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(MemberSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(MemberSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Boolean> IS_OWNED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("IsOwned").getter(getter(MemberSummary::isOwned)).setter(setter(Builder::isOwned))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IsOwned").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, STATUS_FIELD, CREATION_DATE_FIELD, IS_OWNED_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String name;

    private final String description;

    private final String status;

    private final Instant creationDate;

    private final Boolean isOwned;

    private MemberSummary(BuilderImpl builder) {
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.isOwned = builder.isOwned;
    }

    /**
     * <p>
     * The unique identifier of the member.
     * </p>
     * 
     * @return The unique identifier of the member.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The name of the member.
     * </p>
     * 
     * @return The name of the member.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * An optional description of the member.
     * </p>
     * 
     * @return An optional description of the member.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The status of the member.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The AWS account is in the process of creating a member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The member has been created and can participate in the network.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the
     * AWS account that owns the member deleted it, or the member is being deleted as the result of an
     * <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The member can no longer participate on the network and all associated resources are
     * deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of
     * an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the member.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The AWS account is in the process of creating a member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The member has been created and can participate in the network.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The member and all associated resources are in the process of being deleted.
     *         Either the AWS account that owns the member deleted it, or the member is being deleted as the result of
     *         an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The member can no longer participate on the network and all associated resources
     *         are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as
     *         the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     *         </p>
     *         </li>
     * @see MemberStatus
     */
    public MemberStatus status() {
        return MemberStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the member.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>CREATING</code> - The AWS account is in the process of creating a member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>AVAILABLE</code> - The member has been created and can participate in the network.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either the
     * AWS account that owns the member deleted it, or the member is being deleted as the result of an
     * <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>DELETED</code> - The member can no longer participate on the network and all associated resources are
     * deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result of
     * an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link MemberStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the member.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>CREATING</code> - The AWS account is in the process of creating a member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>AVAILABLE</code> - The member has been created and can participate in the network.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETING</code> - The member and all associated resources are in the process of being deleted.
     *         Either the AWS account that owns the member deleted it, or the member is being deleted as the result of
     *         an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>DELETED</code> - The member can no longer participate on the network and all associated resources
     *         are deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as
     *         the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
     *         </p>
     *         </li>
     * @see MemberStatus
     */
    public String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the member was created.
     * </p>
     * 
     * @return The date and time that the member was created.
     */
    public Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * An indicator of whether the member is owned by your AWS account or a different AWS account.
     * </p>
     * 
     * @return An indicator of whether the member is owned by your AWS account or a different AWS account.
     */
    public Boolean isOwned() {
        return isOwned;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(isOwned());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberSummary)) {
            return false;
        }
        MemberSummary other = (MemberSummary) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate()) && Objects.equals(isOwned(), other.isOwned());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("MemberSummary").add("Id", id()).add("Name", name()).add("Description", description())
                .add("Status", statusAsString()).add("CreationDate", creationDate()).add("IsOwned", isOwned()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "IsOwned":
            return Optional.ofNullable(clazz.cast(isOwned()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberSummary, T> g) {
        return obj -> g.apply((MemberSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberSummary> {
        /**
         * <p>
         * The unique identifier of the member.
         * </p>
         * 
         * @param id
         *        The unique identifier of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The name of the member.
         * </p>
         * 
         * @param name
         *        The name of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description of the member.
         * </p>
         * 
         * @param description
         *        An optional description of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The status of the member.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The AWS account is in the process of creating a member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The member has been created and can participate in the network.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either
         * the AWS account that owns the member deleted it, or the member is being deleted as the result of an
         * <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The member can no longer participate on the network and all associated resources are
         * deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result
         * of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the member.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The AWS account is in the process of creating a member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The member has been created and can participate in the network.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The member and all associated resources are in the process of being deleted.
         *        Either the AWS account that owns the member deleted it, or the member is being deleted as the result
         *        of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The member can no longer participate on the network and all associated
         *        resources are deleted. Either the AWS account that owns the member deleted it, or the member is being
         *        deleted as the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         *        </p>
         *        </li>
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the member.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>CREATING</code> - The AWS account is in the process of creating a member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>AVAILABLE</code> - The member has been created and can participate in the network.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETING</code> - The member and all associated resources are in the process of being deleted. Either
         * the AWS account that owns the member deleted it, or the member is being deleted as the result of an
         * <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>DELETED</code> - The member can no longer participate on the network and all associated resources are
         * deleted. Either the AWS account that owns the member deleted it, or the member is being deleted as the result
         * of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the member.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>CREATING</code> - The AWS account is in the process of creating a member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>AVAILABLE</code> - The member has been created and can participate in the network.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CREATE_FAILED</code> - The AWS account attempted to create a member and creation failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETING</code> - The member and all associated resources are in the process of being deleted.
         *        Either the AWS account that owns the member deleted it, or the member is being deleted as the result
         *        of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>DELETED</code> - The member can no longer participate on the network and all associated
         *        resources are deleted. Either the AWS account that owns the member deleted it, or the member is being
         *        deleted as the result of an <code>APPROVED</code> <code>PROPOSAL</code> to remove the member.
         *        </p>
         *        </li>
         * @see MemberStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MemberStatus
         */
        Builder status(MemberStatus status);

        /**
         * <p>
         * The date and time that the member was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time that the member was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * An indicator of whether the member is owned by your AWS account or a different AWS account.
         * </p>
         * 
         * @param isOwned
         *        An indicator of whether the member is owned by your AWS account or a different AWS account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder isOwned(Boolean isOwned);
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String name;

        private String description;

        private String status;

        private Instant creationDate;

        private Boolean isOwned;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberSummary model) {
            id(model.id);
            name(model.name);
            description(model.description);
            status(model.status);
            creationDate(model.creationDate);
            isOwned(model.isOwned);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Boolean getIsOwned() {
            return isOwned;
        }

        @Override
        public final Builder isOwned(Boolean isOwned) {
            this.isOwned = isOwned;
            return this;
        }

        public final void setIsOwned(Boolean isOwned) {
            this.isOwned = isOwned;
        }

        @Override
        public MemberSummary build() {
            return new MemberSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
