/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.Framework;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainRequest;
import software.amazon.awssdk.services.managedblockchain.model.MemberConfiguration;
import software.amazon.awssdk.services.managedblockchain.model.NetworkFrameworkConfiguration;
import software.amazon.awssdk.services.managedblockchain.model.VotingPolicy;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateNetworkRequest
extends ManagedBlockchainRequest
implements ToCopyableBuilder<Builder, CreateNetworkRequest> {
    private static final SdkField<String> CLIENT_REQUEST_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("ClientRequestToken").getter(CreateNetworkRequest.getter(CreateNetworkRequest::clientRequestToken)).setter(CreateNetworkRequest.setter(Builder::clientRequestToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ClientRequestToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Name").getter(CreateNetworkRequest.getter(CreateNetworkRequest::name)).setter(CreateNetworkRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(CreateNetworkRequest.getter(CreateNetworkRequest::description)).setter(CreateNetworkRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> FRAMEWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Framework").getter(CreateNetworkRequest.getter(CreateNetworkRequest::frameworkAsString)).setter(CreateNetworkRequest.setter(Builder::framework)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Framework").build()}).build();
    private static final SdkField<String> FRAMEWORK_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("FrameworkVersion").getter(CreateNetworkRequest.getter(CreateNetworkRequest::frameworkVersion)).setter(CreateNetworkRequest.setter(Builder::frameworkVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkVersion").build()}).build();
    private static final SdkField<NetworkFrameworkConfiguration> FRAMEWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("FrameworkConfiguration").getter(CreateNetworkRequest.getter(CreateNetworkRequest::frameworkConfiguration)).setter(CreateNetworkRequest.setter(Builder::frameworkConfiguration)).constructor(NetworkFrameworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkConfiguration").build()}).build();
    private static final SdkField<VotingPolicy> VOTING_POLICY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("VotingPolicy").getter(CreateNetworkRequest.getter(CreateNetworkRequest::votingPolicy)).setter(CreateNetworkRequest.setter(Builder::votingPolicy)).constructor(VotingPolicy::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VotingPolicy").build()}).build();
    private static final SdkField<MemberConfiguration> MEMBER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("MemberConfiguration").getter(CreateNetworkRequest.getter(CreateNetworkRequest::memberConfiguration)).setter(CreateNetworkRequest.setter(Builder::memberConfiguration)).constructor(MemberConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_REQUEST_TOKEN_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_FIELD, FRAMEWORK_VERSION_FIELD, FRAMEWORK_CONFIGURATION_FIELD, VOTING_POLICY_FIELD, MEMBER_CONFIGURATION_FIELD));
    private final String clientRequestToken;
    private final String name;
    private final String description;
    private final String framework;
    private final String frameworkVersion;
    private final NetworkFrameworkConfiguration frameworkConfiguration;
    private final VotingPolicy votingPolicy;
    private final MemberConfiguration memberConfiguration;

    private CreateNetworkRequest(BuilderImpl builder) {
        super(builder);
        this.clientRequestToken = builder.clientRequestToken;
        this.name = builder.name;
        this.description = builder.description;
        this.framework = builder.framework;
        this.frameworkVersion = builder.frameworkVersion;
        this.frameworkConfiguration = builder.frameworkConfiguration;
        this.votingPolicy = builder.votingPolicy;
        this.memberConfiguration = builder.memberConfiguration;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public Framework framework() {
        return Framework.fromValue(this.framework);
    }

    public String frameworkAsString() {
        return this.framework;
    }

    public String frameworkVersion() {
        return this.frameworkVersion;
    }

    public NetworkFrameworkConfiguration frameworkConfiguration() {
        return this.frameworkConfiguration;
    }

    public VotingPolicy votingPolicy() {
        return this.votingPolicy;
    }

    public MemberConfiguration memberConfiguration() {
        return this.memberConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.votingPolicy());
        hashCode = 31 * hashCode + Objects.hashCode(this.memberConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateNetworkRequest)) {
            return false;
        }
        CreateNetworkRequest other = (CreateNetworkRequest)((Object)obj);
        return Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.frameworkAsString(), other.frameworkAsString()) && Objects.equals(this.frameworkVersion(), other.frameworkVersion()) && Objects.equals(this.frameworkConfiguration(), other.frameworkConfiguration()) && Objects.equals(this.votingPolicy(), other.votingPolicy()) && Objects.equals(this.memberConfiguration(), other.memberConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"CreateNetworkRequest").add("ClientRequestToken", (Object)this.clientRequestToken()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("Framework", (Object)this.frameworkAsString()).add("FrameworkVersion", (Object)this.frameworkVersion()).add("FrameworkConfiguration", (Object)this.frameworkConfiguration()).add("VotingPolicy", (Object)this.votingPolicy()).add("MemberConfiguration", (Object)this.memberConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ClientRequestToken": {
                return Optional.ofNullable(clazz.cast(this.clientRequestToken()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Framework": {
                return Optional.ofNullable(clazz.cast(this.frameworkAsString()));
            }
            case "FrameworkVersion": {
                return Optional.ofNullable(clazz.cast(this.frameworkVersion()));
            }
            case "FrameworkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.frameworkConfiguration()));
            }
            case "VotingPolicy": {
                return Optional.ofNullable(clazz.cast(this.votingPolicy()));
            }
            case "MemberConfiguration": {
                return Optional.ofNullable(clazz.cast(this.memberConfiguration()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateNetworkRequest, T> g) {
        return obj -> g.apply((CreateNetworkRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainRequest.BuilderImpl
    implements Builder {
        private String clientRequestToken;
        private String name;
        private String description;
        private String framework;
        private String frameworkVersion;
        private NetworkFrameworkConfiguration frameworkConfiguration;
        private VotingPolicy votingPolicy;
        private MemberConfiguration memberConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateNetworkRequest model) {
            super(model);
            this.clientRequestToken(model.clientRequestToken);
            this.name(model.name);
            this.description(model.description);
            this.framework(model.framework);
            this.frameworkVersion(model.frameworkVersion);
            this.frameworkConfiguration(model.frameworkConfiguration);
            this.votingPolicy(model.votingPolicy);
            this.memberConfiguration(model.memberConfiguration);
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getFramework() {
            return this.framework;
        }

        @Override
        public final Builder framework(String framework) {
            this.framework = framework;
            return this;
        }

        @Override
        public final Builder framework(Framework framework) {
            this.framework(framework == null ? null : framework.toString());
            return this;
        }

        public final void setFramework(String framework) {
            this.framework = framework;
        }

        public final String getFrameworkVersion() {
            return this.frameworkVersion;
        }

        @Override
        public final Builder frameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
            return this;
        }

        public final void setFrameworkVersion(String frameworkVersion) {
            this.frameworkVersion = frameworkVersion;
        }

        public final NetworkFrameworkConfiguration.Builder getFrameworkConfiguration() {
            return this.frameworkConfiguration != null ? this.frameworkConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder frameworkConfiguration(NetworkFrameworkConfiguration frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration;
            return this;
        }

        public final void setFrameworkConfiguration(NetworkFrameworkConfiguration.BuilderImpl frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration != null ? frameworkConfiguration.build() : null;
        }

        public final VotingPolicy.Builder getVotingPolicy() {
            return this.votingPolicy != null ? this.votingPolicy.toBuilder() : null;
        }

        @Override
        public final Builder votingPolicy(VotingPolicy votingPolicy) {
            this.votingPolicy = votingPolicy;
            return this;
        }

        public final void setVotingPolicy(VotingPolicy.BuilderImpl votingPolicy) {
            this.votingPolicy = votingPolicy != null ? votingPolicy.build() : null;
        }

        public final MemberConfiguration.Builder getMemberConfiguration() {
            return this.memberConfiguration != null ? this.memberConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder memberConfiguration(MemberConfiguration memberConfiguration) {
            this.memberConfiguration = memberConfiguration;
            return this;
        }

        public final void setMemberConfiguration(MemberConfiguration.BuilderImpl memberConfiguration) {
            this.memberConfiguration = memberConfiguration != null ? memberConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateNetworkRequest build() {
            return new CreateNetworkRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends ManagedBlockchainRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateNetworkRequest> {
        public Builder clientRequestToken(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder framework(String var1);

        public Builder framework(Framework var1);

        public Builder frameworkVersion(String var1);

        public Builder frameworkConfiguration(NetworkFrameworkConfiguration var1);

        default public Builder frameworkConfiguration(Consumer<NetworkFrameworkConfiguration.Builder> frameworkConfiguration) {
            return this.frameworkConfiguration((NetworkFrameworkConfiguration)((NetworkFrameworkConfiguration.Builder)NetworkFrameworkConfiguration.builder().applyMutation(frameworkConfiguration)).build());
        }

        public Builder votingPolicy(VotingPolicy var1);

        default public Builder votingPolicy(Consumer<VotingPolicy.Builder> votingPolicy) {
            return this.votingPolicy((VotingPolicy)((VotingPolicy.Builder)VotingPolicy.builder().applyMutation(votingPolicy)).build());
        }

        public Builder memberConfiguration(MemberConfiguration var1);

        default public Builder memberConfiguration(Consumer<MemberConfiguration.Builder> memberConfiguration) {
            return this.memberConfiguration((MemberConfiguration)((MemberConfiguration.Builder)MemberConfiguration.builder().applyMutation(memberConfiguration)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

