/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes relevant to the network for the blockchain framework that the network uses.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkFrameworkAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkFrameworkAttributes.Builder, NetworkFrameworkAttributes> {
    private static final SdkField<NetworkFabricAttributes> FABRIC_FIELD = SdkField
            .<NetworkFabricAttributes> builder(MarshallingType.SDK_POJO).memberName("Fabric")
            .getter(getter(NetworkFrameworkAttributes::fabric)).setter(setter(Builder::fabric))
            .constructor(NetworkFabricAttributes::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Fabric").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FABRIC_FIELD));

    private static final long serialVersionUID = 1L;

    private final NetworkFabricAttributes fabric;

    private NetworkFrameworkAttributes(BuilderImpl builder) {
        this.fabric = builder.fabric;
    }

    /**
     * <p>
     * Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.
     * </p>
     * 
     * @return Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.
     */
    public final NetworkFabricAttributes fabric() {
        return fabric;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(fabric());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFrameworkAttributes)) {
            return false;
        }
        NetworkFrameworkAttributes other = (NetworkFrameworkAttributes) obj;
        return Objects.equals(fabric(), other.fabric());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkFrameworkAttributes").add("Fabric", fabric()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Fabric":
            return Optional.ofNullable(clazz.cast(fabric()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFrameworkAttributes, T> g) {
        return obj -> g.apply((NetworkFrameworkAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkFrameworkAttributes> {
        /**
         * <p>
         * Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.
         * </p>
         * 
         * @param fabric
         *        Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fabric(NetworkFabricAttributes fabric);

        /**
         * <p>
         * Attributes of Hyperledger Fabric for a Managed Blockchain network that uses Hyperledger Fabric.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkFabricAttributes.Builder} avoiding the
         * need to create one manually via {@link NetworkFabricAttributes#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkFabricAttributes.Builder#build()} is called immediately
         * and its result is passed to {@link #fabric(NetworkFabricAttributes)}.
         * 
         * @param fabric
         *        a consumer that will call methods on {@link NetworkFabricAttributes.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fabric(NetworkFabricAttributes)
         */
        default Builder fabric(Consumer<NetworkFabricAttributes.Builder> fabric) {
            return fabric(NetworkFabricAttributes.builder().applyMutation(fabric).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private NetworkFabricAttributes fabric;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFrameworkAttributes model) {
            fabric(model.fabric);
        }

        public final NetworkFabricAttributes.Builder getFabric() {
            return fabric != null ? fabric.toBuilder() : null;
        }

        @Override
        public final Builder fabric(NetworkFabricAttributes fabric) {
            this.fabric = fabric;
            return this;
        }

        public final void setFabric(NetworkFabricAttributes.BuilderImpl fabric) {
            this.fabric = fabric != null ? fabric.build() : null;
        }

        @Override
        public NetworkFrameworkAttributes build() {
            return new NetworkFrameworkAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
