/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Properties of a proposal.
 * </p>
 * <p>
 * Applies only to Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProposalSummary implements SdkPojo, Serializable, ToCopyableBuilder<ProposalSummary.Builder, ProposalSummary> {
    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProposalId").getter(getter(ProposalSummary::proposalId)).setter(setter(Builder::proposalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposalId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(ProposalSummary::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> PROPOSED_BY_MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProposedByMemberId").getter(getter(ProposalSummary::proposedByMemberId))
            .setter(setter(Builder::proposedByMemberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedByMemberId").build())
            .build();

    private static final SdkField<String> PROPOSED_BY_MEMBER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ProposedByMemberName").getter(getter(ProposalSummary::proposedByMemberName))
            .setter(setter(Builder::proposedByMemberName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ProposedByMemberName").build())
            .build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Status")
            .getter(getter(ProposalSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()).build();

    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreationDate")
            .getter(getter(ProposalSummary::creationDate))
            .setter(setter(Builder::creationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> EXPIRATION_DATE_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("ExpirationDate")
            .getter(getter(ProposalSummary::expirationDate))
            .setter(setter(Builder::expirationDate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ExpirationDate").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PROPOSAL_ID_FIELD,
            DESCRIPTION_FIELD, PROPOSED_BY_MEMBER_ID_FIELD, PROPOSED_BY_MEMBER_NAME_FIELD, STATUS_FIELD, CREATION_DATE_FIELD,
            EXPIRATION_DATE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String proposalId;

    private final String description;

    private final String proposedByMemberId;

    private final String proposedByMemberName;

    private final String status;

    private final Instant creationDate;

    private final Instant expirationDate;

    private ProposalSummary(BuilderImpl builder) {
        this.proposalId = builder.proposalId;
        this.description = builder.description;
        this.proposedByMemberId = builder.proposedByMemberId;
        this.proposedByMemberName = builder.proposedByMemberName;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
        this.expirationDate = builder.expirationDate;
    }

    /**
     * <p>
     * The unique identifier of the proposal.
     * </p>
     * 
     * @return The unique identifier of the proposal.
     */
    public final String proposalId() {
        return proposalId;
    }

    /**
     * <p>
     * The description of the proposal.
     * </p>
     * 
     * @return The description of the proposal.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The unique identifier of the member that created the proposal.
     * </p>
     * 
     * @return The unique identifier of the member that created the proposal.
     */
    public final String proposedByMemberId() {
        return proposedByMemberId;
    }

    /**
     * <p>
     * The name of the member that created the proposal.
     * </p>
     * 
     * @return The name of the member that created the proposal.
     */
    public final String proposedByMemberName() {
        return proposedByMemberName;
    }

    /**
     * <p>
     * The status of the proposal. Values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according
     * to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are
     * carried out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members
     * according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
     * <code>ProposalActions</code> are not carried out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before
     * the proposal expired. The specified <code>ProposalActions</code> are not carried out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was
     * approved could not be completed because of an error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProposalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the proposal. Values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members
     *         according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal
     *         actions are carried out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members
     *         according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
     *         <code>ProposalActions</code> are not carried out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal
     *         outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that
     *         was approved could not be completed because of an error.
     *         </p>
     *         </li>
     * @see ProposalStatus
     */
    public final ProposalStatus status() {
        return ProposalStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the proposal. Values are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members according
     * to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal actions are
     * carried out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members
     * according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
     * <code>ProposalActions</code> are not carried out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome before
     * the proposal expired. The specified <code>ProposalActions</code> are not carried out.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was
     * approved could not be completed because of an error.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ProposalStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the proposal. Values are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members
     *         according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal
     *         actions are carried out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members
     *         according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
     *         <code>ProposalActions</code> are not carried out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal
     *         outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that
     *         was approved could not be completed because of an error.
     *         </p>
     *         </li>
     * @see ProposalStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time that the proposal was created.
     * </p>
     * 
     * @return The date and time that the proposal was created.
     */
    public final Instant creationDate() {
        return creationDate;
    }

    /**
     * <p>
     * The date and time that the proposal expires. This is the <code>CreationDate</code> plus the
     * <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After this
     * date and time, if members have not cast enough votes to determine the outcome according to the voting policy, the
     * proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
     * </p>
     * 
     * @return The date and time that the proposal expires. This is the <code>CreationDate</code> plus the
     *         <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After
     *         this date and time, if members have not cast enough votes to determine the outcome according to the
     *         voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
     */
    public final Instant expirationDate() {
        return expirationDate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(proposedByMemberId());
        hashCode = 31 * hashCode + Objects.hashCode(proposedByMemberName());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(creationDate());
        hashCode = 31 * hashCode + Objects.hashCode(expirationDate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposalSummary)) {
            return false;
        }
        ProposalSummary other = (ProposalSummary) obj;
        return Objects.equals(proposalId(), other.proposalId()) && Objects.equals(description(), other.description())
                && Objects.equals(proposedByMemberId(), other.proposedByMemberId())
                && Objects.equals(proposedByMemberName(), other.proposedByMemberName())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(creationDate(), other.creationDate())
                && Objects.equals(expirationDate(), other.expirationDate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProposalSummary").add("ProposalId", proposalId()).add("Description", description())
                .add("ProposedByMemberId", proposedByMemberId()).add("ProposedByMemberName", proposedByMemberName())
                .add("Status", statusAsString()).add("CreationDate", creationDate()).add("ExpirationDate", expirationDate())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ProposalId":
            return Optional.ofNullable(clazz.cast(proposalId()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ProposedByMemberId":
            return Optional.ofNullable(clazz.cast(proposedByMemberId()));
        case "ProposedByMemberName":
            return Optional.ofNullable(clazz.cast(proposedByMemberName()));
        case "Status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "CreationDate":
            return Optional.ofNullable(clazz.cast(creationDate()));
        case "ExpirationDate":
            return Optional.ofNullable(clazz.cast(expirationDate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProposalSummary, T> g) {
        return obj -> g.apply((ProposalSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProposalSummary> {
        /**
         * <p>
         * The unique identifier of the proposal.
         * </p>
         * 
         * @param proposalId
         *        The unique identifier of the proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalId(String proposalId);

        /**
         * <p>
         * The description of the proposal.
         * </p>
         * 
         * @param description
         *        The description of the proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The unique identifier of the member that created the proposal.
         * </p>
         * 
         * @param proposedByMemberId
         *        The unique identifier of the member that created the proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposedByMemberId(String proposedByMemberId);

        /**
         * <p>
         * The name of the member that created the proposal.
         * </p>
         * 
         * @param proposedByMemberName
         *        The name of the member that created the proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposedByMemberName(String proposedByMemberName);

        /**
         * <p>
         * The status of the proposal. Values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members
         * according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal
         * actions are carried out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members
         * according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
         * <code>ProposalActions</code> are not carried out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome
         * before the proposal expired. The specified <code>ProposalActions</code> are not carried out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was
         * approved could not be completed because of an error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the proposal. Values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members
         *        according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
         *        proposal actions are carried out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among
         *        members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The
         *        specified <code>ProposalActions</code> are not carried out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal
         *        outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal
         *        that was approved could not be completed because of an error.
         *        </p>
         *        </li>
         * @see ProposalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProposalStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the proposal. Values are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members
         * according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified proposal
         * actions are carried out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among members
         * according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
         * <code>ProposalActions</code> are not carried out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal outcome
         * before the proposal expired. The specified <code>ProposalActions</code> are not carried out.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal that was
         * approved could not be completed because of an error.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of the proposal. Values are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>IN_PROGRESS</code> - The proposal is active and open for member voting.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>APPROVED</code> - The proposal was approved with sufficient <code>YES</code> votes among members
         *        according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The specified
         *        proposal actions are carried out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>REJECTED</code> - The proposal was rejected with insufficient <code>YES</code> votes among
         *        members according to the <code>VotingPolicy</code> specified for the <code>Network</code>. The
         *        specified <code>ProposalActions</code> are not carried out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>EXPIRED</code> - Members did not cast the number of votes required to determine the proposal
         *        outcome before the proposal expired. The specified <code>ProposalActions</code> are not carried out.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ACTION_FAILED</code> - One or more of the specified <code>ProposalActions</code> in a proposal
         *        that was approved could not be completed because of an error.
         *        </p>
         *        </li>
         * @see ProposalStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ProposalStatus
         */
        Builder status(ProposalStatus status);

        /**
         * <p>
         * The date and time that the proposal was created.
         * </p>
         * 
         * @param creationDate
         *        The date and time that the proposal was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder creationDate(Instant creationDate);

        /**
         * <p>
         * The date and time that the proposal expires. This is the <code>CreationDate</code> plus the
         * <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>. After
         * this date and time, if members have not cast enough votes to determine the outcome according to the voting
         * policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
         * </p>
         * 
         * @param expirationDate
         *        The date and time that the proposal expires. This is the <code>CreationDate</code> plus the
         *        <code>ProposalDurationInHours</code> that is specified in the <code>ProposalThresholdPolicy</code>.
         *        After this date and time, if members have not cast enough votes to determine the outcome according to
         *        the voting policy, the proposal is <code>EXPIRED</code> and <code>Actions</code> are not carried out.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder expirationDate(Instant expirationDate);
    }

    static final class BuilderImpl implements Builder {
        private String proposalId;

        private String description;

        private String proposedByMemberId;

        private String proposedByMemberName;

        private String status;

        private Instant creationDate;

        private Instant expirationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(ProposalSummary model) {
            proposalId(model.proposalId);
            description(model.description);
            proposedByMemberId(model.proposedByMemberId);
            proposedByMemberName(model.proposedByMemberName);
            status(model.status);
            creationDate(model.creationDate);
            expirationDate(model.expirationDate);
        }

        public final String getProposalId() {
            return proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getProposedByMemberId() {
            return proposedByMemberId;
        }

        @Override
        public final Builder proposedByMemberId(String proposedByMemberId) {
            this.proposedByMemberId = proposedByMemberId;
            return this;
        }

        public final void setProposedByMemberId(String proposedByMemberId) {
            this.proposedByMemberId = proposedByMemberId;
        }

        public final String getProposedByMemberName() {
            return proposedByMemberName;
        }

        @Override
        public final Builder proposedByMemberName(String proposedByMemberName) {
            this.proposedByMemberName = proposedByMemberName;
            return this;
        }

        public final void setProposedByMemberName(String proposedByMemberName) {
            this.proposedByMemberName = proposedByMemberName;
        }

        public final String getStatus() {
            return status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ProposalStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public final Instant getExpirationDate() {
            return expirationDate;
        }

        @Override
        public final Builder expirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
            return this;
        }

        public final void setExpirationDate(Instant expirationDate) {
            this.expirationDate = expirationDate;
        }

        @Override
        public ProposalSummary build() {
            return new ProposalSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
