/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum StateDBType {
    LEVEL_DB("LevelDB"),
    COUCH_DB("CouchDB"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private StateDBType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static StateDBType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(StateDBType.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<StateDBType> knownValues() {
        return Stream.of(StateDBType.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

