/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties of a node.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NodeConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<NodeConfiguration.Builder, NodeConfiguration> {
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(NodeConfiguration::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> AVAILABILITY_ZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AvailabilityZone").getter(getter(NodeConfiguration::availabilityZone))
            .setter(setter(Builder::availabilityZone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailabilityZone").build()).build();

    private static final SdkField<NodeLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField
            .<NodeLogPublishingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LogPublishingConfiguration")
            .getter(getter(NodeConfiguration::logPublishingConfiguration))
            .setter(setter(Builder::logPublishingConfiguration))
            .constructor(NodeLogPublishingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build())
            .build();

    private static final SdkField<String> STATE_DB_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StateDB").getter(getter(NodeConfiguration::stateDBAsString)).setter(setter(Builder::stateDB))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StateDB").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_TYPE_FIELD,
            AVAILABILITY_ZONE_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD, STATE_DB_FIELD));

    private static final long serialVersionUID = 1L;

    private final String instanceType;

    private final String availabilityZone;

    private final NodeLogPublishingConfiguration logPublishingConfiguration;

    private final String stateDB;

    private NodeConfiguration(BuilderImpl builder) {
        this.instanceType = builder.instanceType;
        this.availabilityZone = builder.availabilityZone;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
        this.stateDB = builder.stateDB;
    }

    /**
     * <p>
     * The Amazon Managed Blockchain instance type for the node.
     * </p>
     * 
     * @return The Amazon Managed Blockchain instance type for the node.
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The Availability Zone in which the node exists. Required for Ethereum nodes.
     * </p>
     * 
     * @return The Availability Zone in which the node exists. Required for Ethereum nodes.
     */
    public final String availabilityZone() {
        return availabilityZone;
    }

    /**
     * <p>
     * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on
     * Managed Blockchain.
     * </p>
     * 
     * @return Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network
     *         on Managed Blockchain.
     */
    public final NodeLogPublishingConfiguration logPublishingConfiguration() {
        return logPublishingConfiguration;
    }

    /**
     * <p>
     * The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an
     * Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is
     * <code>CouchDB</code>.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateDB} will
     * return {@link StateDBType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateDBAsString}.
     * </p>
     * 
     * @return The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When
     *         using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is
     *         <code>CouchDB</code>.</p>
     *         <p>
     *         Applies only to Hyperledger Fabric.
     * @see StateDBType
     */
    public final StateDBType stateDB() {
        return StateDBType.fromValue(stateDB);
    }

    /**
     * <p>
     * The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an
     * Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is
     * <code>CouchDB</code>.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stateDB} will
     * return {@link StateDBType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateDBAsString}.
     * </p>
     * 
     * @return The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When
     *         using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is
     *         <code>CouchDB</code>.</p>
     *         <p>
     *         Applies only to Hyperledger Fabric.
     * @see StateDBType
     */
    public final String stateDBAsString() {
        return stateDB;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(availabilityZone());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(stateDBAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NodeConfiguration)) {
            return false;
        }
        NodeConfiguration other = (NodeConfiguration) obj;
        return Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(availabilityZone(), other.availabilityZone())
                && Objects.equals(logPublishingConfiguration(), other.logPublishingConfiguration())
                && Objects.equals(stateDBAsString(), other.stateDBAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NodeConfiguration").add("InstanceType", instanceType())
                .add("AvailabilityZone", availabilityZone()).add("LogPublishingConfiguration", logPublishingConfiguration())
                .add("StateDB", stateDBAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "AvailabilityZone":
            return Optional.ofNullable(clazz.cast(availabilityZone()));
        case "LogPublishingConfiguration":
            return Optional.ofNullable(clazz.cast(logPublishingConfiguration()));
        case "StateDB":
            return Optional.ofNullable(clazz.cast(stateDBAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NodeConfiguration, T> g) {
        return obj -> g.apply((NodeConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NodeConfiguration> {
        /**
         * <p>
         * The Amazon Managed Blockchain instance type for the node.
         * </p>
         * 
         * @param instanceType
         *        The Amazon Managed Blockchain instance type for the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The Availability Zone in which the node exists. Required for Ethereum nodes.
         * </p>
         * 
         * @param availabilityZone
         *        The Availability Zone in which the node exists. Required for Ethereum nodes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availabilityZone(String availabilityZone);

        /**
         * <p>
         * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on
         * Managed Blockchain.
         * </p>
         * 
         * @param logPublishingConfiguration
         *        Configuration properties for logging events associated with a peer node on a Hyperledger Fabric
         *        network on Managed Blockchain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration);

        /**
         * <p>
         * Configuration properties for logging events associated with a peer node on a Hyperledger Fabric network on
         * Managed Blockchain.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeLogPublishingConfiguration.Builder} avoiding
         * the need to create one manually via {@link NodeLogPublishingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeLogPublishingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logPublishingConfiguration(NodeLogPublishingConfiguration)}.
         * 
         * @param logPublishingConfiguration
         *        a consumer that will call methods on {@link NodeLogPublishingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingConfiguration(NodeLogPublishingConfiguration)
         */
        default Builder logPublishingConfiguration(Consumer<NodeLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return logPublishingConfiguration(NodeLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)
                    .build());
        }

        /**
         * <p>
         * The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an
         * Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is
         * <code>CouchDB</code>.
         * </p>
         * <p>
         * Applies only to Hyperledger Fabric.
         * </p>
         * 
         * @param stateDB
         *        The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When
         *        using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default
         *        is <code>CouchDB</code>.</p>
         *        <p>
         *        Applies only to Hyperledger Fabric.
         * @see StateDBType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateDBType
         */
        Builder stateDB(String stateDB);

        /**
         * <p>
         * The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When using an
         * Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default is
         * <code>CouchDB</code>.
         * </p>
         * <p>
         * Applies only to Hyperledger Fabric.
         * </p>
         * 
         * @param stateDB
         *        The state database that the node uses. Values are <code>LevelDB</code> or <code>CouchDB</code>. When
         *        using an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or later, the default
         *        is <code>CouchDB</code>.</p>
         *        <p>
         *        Applies only to Hyperledger Fabric.
         * @see StateDBType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StateDBType
         */
        Builder stateDB(StateDBType stateDB);
    }

    static final class BuilderImpl implements Builder {
        private String instanceType;

        private String availabilityZone;

        private NodeLogPublishingConfiguration logPublishingConfiguration;

        private String stateDB;

        private BuilderImpl() {
        }

        private BuilderImpl(NodeConfiguration model) {
            instanceType(model.instanceType);
            availabilityZone(model.availabilityZone);
            logPublishingConfiguration(model.logPublishingConfiguration);
            stateDB(model.stateDB);
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getAvailabilityZone() {
            return availabilityZone;
        }

        @Override
        public final Builder availabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        public final void setAvailabilityZone(String availabilityZone) {
            this.availabilityZone = availabilityZone;
        }

        public final NodeLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return logPublishingConfiguration != null ? logPublishingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final void setLogPublishingConfiguration(NodeLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        public final String getStateDB() {
            return stateDB;
        }

        @Override
        public final Builder stateDB(String stateDB) {
            this.stateDB = stateDB;
            return this;
        }

        @Override
        public final Builder stateDB(StateDBType stateDB) {
            this.stateDB(stateDB == null ? null : stateDB.toString());
            return this;
        }

        public final void setStateDB(String stateDB) {
            this.stateDB = stateDB;
        }

        @Override
        public NodeConfiguration build() {
            return new NodeConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
