/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.Edition;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class NetworkFabricAttributes
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, NetworkFabricAttributes> {
    private static final SdkField<String> ORDERING_SERVICE_ENDPOINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OrderingServiceEndpoint").getter(NetworkFabricAttributes.getter(NetworkFabricAttributes::orderingServiceEndpoint)).setter(NetworkFabricAttributes.setter(Builder::orderingServiceEndpoint)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrderingServiceEndpoint").build()}).build();
    private static final SdkField<String> EDITION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Edition").getter(NetworkFabricAttributes.getter(NetworkFabricAttributes::editionAsString)).setter(NetworkFabricAttributes.setter(Builder::edition)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Edition").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORDERING_SERVICE_ENDPOINT_FIELD, EDITION_FIELD));
    private static final long serialVersionUID = 1L;
    private final String orderingServiceEndpoint;
    private final String edition;

    private NetworkFabricAttributes(BuilderImpl builder) {
        this.orderingServiceEndpoint = builder.orderingServiceEndpoint;
        this.edition = builder.edition;
    }

    public final String orderingServiceEndpoint() {
        return this.orderingServiceEndpoint;
    }

    public final Edition edition() {
        return Edition.fromValue(this.edition);
    }

    public final String editionAsString() {
        return this.edition;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.orderingServiceEndpoint());
        hashCode = 31 * hashCode + Objects.hashCode(this.editionAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkFabricAttributes)) {
            return false;
        }
        NetworkFabricAttributes other = (NetworkFabricAttributes)obj;
        return Objects.equals(this.orderingServiceEndpoint(), other.orderingServiceEndpoint()) && Objects.equals(this.editionAsString(), other.editionAsString());
    }

    public final String toString() {
        return ToString.builder((String)"NetworkFabricAttributes").add("OrderingServiceEndpoint", (Object)this.orderingServiceEndpoint()).add("Edition", (Object)this.editionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "OrderingServiceEndpoint": {
                return Optional.ofNullable(clazz.cast(this.orderingServiceEndpoint()));
            }
            case "Edition": {
                return Optional.ofNullable(clazz.cast(this.editionAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkFabricAttributes, T> g) {
        return obj -> g.apply((NetworkFabricAttributes)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String orderingServiceEndpoint;
        private String edition;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkFabricAttributes model) {
            this.orderingServiceEndpoint(model.orderingServiceEndpoint);
            this.edition(model.edition);
        }

        public final String getOrderingServiceEndpoint() {
            return this.orderingServiceEndpoint;
        }

        public final void setOrderingServiceEndpoint(String orderingServiceEndpoint) {
            this.orderingServiceEndpoint = orderingServiceEndpoint;
        }

        @Override
        @Transient
        public final Builder orderingServiceEndpoint(String orderingServiceEndpoint) {
            this.orderingServiceEndpoint = orderingServiceEndpoint;
            return this;
        }

        public final String getEdition() {
            return this.edition;
        }

        public final void setEdition(String edition) {
            this.edition = edition;
        }

        @Override
        @Transient
        public final Builder edition(String edition) {
            this.edition = edition;
            return this;
        }

        @Override
        @Transient
        public final Builder edition(Edition edition) {
            this.edition(edition == null ? null : edition.toString());
            return this;
        }

        public NetworkFabricAttributes build() {
            return new NetworkFabricAttributes(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, NetworkFabricAttributes> {
        public Builder orderingServiceEndpoint(String var1);

        public Builder edition(String var1);

        public Builder edition(Edition var1);
    }
}

