/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The actions to carry out if a proposal is <code>APPROVED</code>.
 * </p>
 * <p>
 * Applies only to Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ProposalActions implements SdkPojo, Serializable, ToCopyableBuilder<ProposalActions.Builder, ProposalActions> {
    private static final SdkField<List<InviteAction>> INVITATIONS_FIELD = SdkField
            .<List<InviteAction>> builder(MarshallingType.LIST)
            .memberName("Invitations")
            .getter(getter(ProposalActions::invitations))
            .setter(setter(Builder::invitations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Invitations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<InviteAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(InviteAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<RemoveAction>> REMOVALS_FIELD = SdkField
            .<List<RemoveAction>> builder(MarshallingType.LIST)
            .memberName("Removals")
            .getter(getter(ProposalActions::removals))
            .setter(setter(Builder::removals))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Removals").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<RemoveAction> builder(MarshallingType.SDK_POJO)
                                            .constructor(RemoveAction::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVITATIONS_FIELD,
            REMOVALS_FIELD));

    private static final long serialVersionUID = 1L;

    private final List<InviteAction> invitations;

    private final List<RemoveAction> removals;

    private ProposalActions(BuilderImpl builder) {
        this.invitations = builder.invitations;
        this.removals = builder.removals;
    }

    /**
     * For responses, this returns true if the service returned a value for the Invitations property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasInvitations() {
        return invitations != null && !(invitations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and join
     * the network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInvitations} method.
     * </p>
     * 
     * @return The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member
     *         and join the network.
     */
    public final List<InviteAction> invitations() {
        return invitations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Removals property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRemovals() {
        return removals != null && !(removals instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which deletes
     * the member and all associated member resources from the network.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRemovals} method.
     * </p>
     * 
     * @return The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which
     *         deletes the member and all associated member resources from the network.
     */
    public final List<RemoveAction> removals() {
        return removals;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInvitations() ? invitations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasRemovals() ? removals() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ProposalActions)) {
            return false;
        }
        ProposalActions other = (ProposalActions) obj;
        return hasInvitations() == other.hasInvitations() && Objects.equals(invitations(), other.invitations())
                && hasRemovals() == other.hasRemovals() && Objects.equals(removals(), other.removals());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ProposalActions").add("Invitations", hasInvitations() ? invitations() : null)
                .add("Removals", hasRemovals() ? removals() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Invitations":
            return Optional.ofNullable(clazz.cast(invitations()));
        case "Removals":
            return Optional.ofNullable(clazz.cast(removals()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ProposalActions, T> g) {
        return obj -> g.apply((ProposalActions) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ProposalActions> {
        /**
         * <p>
         * The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and
         * join the network.
         * </p>
         * 
         * @param invitations
         *        The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a
         *        member and join the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitations(Collection<InviteAction> invitations);

        /**
         * <p>
         * The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and
         * join the network.
         * </p>
         * 
         * @param invitations
         *        The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a
         *        member and join the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder invitations(InviteAction... invitations);

        /**
         * <p>
         * The actions to perform for an <code>APPROVED</code> proposal to invite an AWS account to create a member and
         * join the network.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<InviteAction>.Builder} avoiding the
         * need to create one manually via {@link List<InviteAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<InviteAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #invitations(List<InviteAction>)}.
         * 
         * @param invitations
         *        a consumer that will call methods on {@link List<InviteAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #invitations(List<InviteAction>)
         */
        Builder invitations(Consumer<InviteAction.Builder>... invitations);

        /**
         * <p>
         * The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which
         * deletes the member and all associated member resources from the network.
         * </p>
         * 
         * @param removals
         *        The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network,
         *        which deletes the member and all associated member resources from the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removals(Collection<RemoveAction> removals);

        /**
         * <p>
         * The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which
         * deletes the member and all associated member resources from the network.
         * </p>
         * 
         * @param removals
         *        The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network,
         *        which deletes the member and all associated member resources from the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder removals(RemoveAction... removals);

        /**
         * <p>
         * The actions to perform for an <code>APPROVED</code> proposal to remove a member from the network, which
         * deletes the member and all associated member resources from the network.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<RemoveAction>.Builder} avoiding the
         * need to create one manually via {@link List<RemoveAction>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<RemoveAction>.Builder#build()} is called immediately and its
         * result is passed to {@link #removals(List<RemoveAction>)}.
         * 
         * @param removals
         *        a consumer that will call methods on {@link List<RemoveAction>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #removals(List<RemoveAction>)
         */
        Builder removals(Consumer<RemoveAction.Builder>... removals);
    }

    static final class BuilderImpl implements Builder {
        private List<InviteAction> invitations = DefaultSdkAutoConstructList.getInstance();

        private List<RemoveAction> removals = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ProposalActions model) {
            invitations(model.invitations);
            removals(model.removals);
        }

        public final List<InviteAction.Builder> getInvitations() {
            List<InviteAction.Builder> result = InviteActionListCopier.copyToBuilder(this.invitations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvitations(Collection<InviteAction.BuilderImpl> invitations) {
            this.invitations = InviteActionListCopier.copyFromBuilder(invitations);
        }

        @Override
        @Transient
        public final Builder invitations(Collection<InviteAction> invitations) {
            this.invitations = InviteActionListCopier.copy(invitations);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder invitations(InviteAction... invitations) {
            invitations(Arrays.asList(invitations));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder invitations(Consumer<InviteAction.Builder>... invitations) {
            invitations(Stream.of(invitations).map(c -> InviteAction.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<RemoveAction.Builder> getRemovals() {
            List<RemoveAction.Builder> result = RemoveActionListCopier.copyToBuilder(this.removals);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRemovals(Collection<RemoveAction.BuilderImpl> removals) {
            this.removals = RemoveActionListCopier.copyFromBuilder(removals);
        }

        @Override
        @Transient
        public final Builder removals(Collection<RemoveAction> removals) {
            this.removals = RemoveActionListCopier.copy(removals);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removals(RemoveAction... removals) {
            removals(Arrays.asList(removals));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder removals(Consumer<RemoveAction.Builder>... removals) {
            removals(Stream.of(removals).map(c -> RemoveAction.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public ProposalActions build() {
            return new ProposalActions(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
