/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties of the member.
 * </p>
 * <p>
 * Applies only to Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberConfiguration.Builder, MemberConfiguration> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(MemberConfiguration::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(MemberConfiguration::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<MemberFrameworkConfiguration> FRAMEWORK_CONFIGURATION_FIELD = SdkField
            .<MemberFrameworkConfiguration> builder(MarshallingType.SDK_POJO).memberName("FrameworkConfiguration")
            .getter(getter(MemberConfiguration::frameworkConfiguration)).setter(setter(Builder::frameworkConfiguration))
            .constructor(MemberFrameworkConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkConfiguration").build())
            .build();

    private static final SdkField<MemberLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField
            .<MemberLogPublishingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LogPublishingConfiguration")
            .getter(getter(MemberConfiguration::logPublishingConfiguration))
            .setter(setter(Builder::logPublishingConfiguration))
            .constructor(MemberLogPublishingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("Tags")
            .getter(getter(MemberConfiguration::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<String> KMS_KEY_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("KmsKeyArn").getter(getter(MemberConfiguration::kmsKeyArn)).setter(setter(Builder::kmsKeyArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("KmsKeyArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD,
            FRAMEWORK_CONFIGURATION_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD, TAGS_FIELD, KMS_KEY_ARN_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String description;

    private final MemberFrameworkConfiguration frameworkConfiguration;

    private final MemberLogPublishingConfiguration logPublishingConfiguration;

    private final Map<String, String> tags;

    private final String kmsKeyArn;

    private MemberConfiguration(BuilderImpl builder) {
        this.name = builder.name;
        this.description = builder.description;
        this.frameworkConfiguration = builder.frameworkConfiguration;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
        this.tags = builder.tags;
        this.kmsKeyArn = builder.kmsKeyArn;
    }

    /**
     * <p>
     * The name of the member.
     * </p>
     * 
     * @return The name of the member.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * An optional description of the member.
     * </p>
     * 
     * @return An optional description of the member.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * Configuration properties of the blockchain framework relevant to the member.
     * </p>
     * 
     * @return Configuration properties of the blockchain framework relevant to the member.
     */
    public final MemberFrameworkConfiguration frameworkConfiguration() {
        return frameworkConfiguration;
    }

    /**
     * <p>
     * Configuration properties for logging events associated with a member of a Managed Blockchain network.
     * </p>
     * 
     * @return Configuration properties for logging events associated with a member of a Managed Blockchain network.
     */
    public final MemberLogPublishingConfiguration logPublishingConfiguration() {
        return logPublishingConfiguration;
    }

    /**
     * Returns true if the Tags property was specified by the sender (it may be empty), or false if the sender did not
     * specify the value (it will be empty). For responses returned by the SDK, the sender is the AWS service.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see <a
     * href
     * ="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">Tagging
     * Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
     * </p>
     * <p>
     * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an
     * overall maximum of 50 tags added to each resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * You can use {@link #hasTags()} to see if a value was sent in this field.
     * </p>
     * 
     * @return Tags assigned to the member. Tags consist of a key and optional value. For more information about tags,
     *         see <a href=
     *         "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
     *         >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
     *         <p>
     *         When specifying tags during creation, you can specify multiple key-value pairs in a single request, with
     *         an overall maximum of 50 tags added to each resource.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to use for
     * encryption at rest in the member. This parameter is inherited by any nodes that this member creates.
     * </p>
     * <p>
     * Use one of the following options to specify this parameter:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.
     * </p>
     * <p>
     * Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a
     * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and
     * asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
     * </p>
     * <p>
     * The following is an example of a KMS key ARN:
     * <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to use
     *         for encryption at rest in the member. This parameter is inherited by any nodes that this member
     *         creates.</p>
     *         <p>
     *         Use one of the following options to specify this parameter:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.
     *         </p>
     *         <p>
     *         Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a
     *         href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric
     *         and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
     *         </p>
     *         <p>
     *         The following is an example of a KMS key ARN:
     *         <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
     *         </p>
     *         </li>
     */
    public final String kmsKeyArn() {
        return kmsKeyArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(frameworkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(kmsKeyArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberConfiguration)) {
            return false;
        }
        MemberConfiguration other = (MemberConfiguration) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(description(), other.description())
                && Objects.equals(frameworkConfiguration(), other.frameworkConfiguration())
                && Objects.equals(logPublishingConfiguration(), other.logPublishingConfiguration())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(kmsKeyArn(), other.kmsKeyArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberConfiguration").add("Name", name()).add("Description", description())
                .add("FrameworkConfiguration", frameworkConfiguration())
                .add("LogPublishingConfiguration", logPublishingConfiguration()).add("Tags", hasTags() ? tags() : null)
                .add("KmsKeyArn", kmsKeyArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "FrameworkConfiguration":
            return Optional.ofNullable(clazz.cast(frameworkConfiguration()));
        case "LogPublishingConfiguration":
            return Optional.ofNullable(clazz.cast(logPublishingConfiguration()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "KmsKeyArn":
            return Optional.ofNullable(clazz.cast(kmsKeyArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberConfiguration, T> g) {
        return obj -> g.apply((MemberConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberConfiguration> {
        /**
         * <p>
         * The name of the member.
         * </p>
         * 
         * @param name
         *        The name of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An optional description of the member.
         * </p>
         * 
         * @param description
         *        An optional description of the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * Configuration properties of the blockchain framework relevant to the member.
         * </p>
         * 
         * @param frameworkConfiguration
         *        Configuration properties of the blockchain framework relevant to the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder frameworkConfiguration(MemberFrameworkConfiguration frameworkConfiguration);

        /**
         * <p>
         * Configuration properties of the blockchain framework relevant to the member.
         * </p>
         * This is a convenience that creates an instance of the {@link MemberFrameworkConfiguration.Builder} avoiding
         * the need to create one manually via {@link MemberFrameworkConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemberFrameworkConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #frameworkConfiguration(MemberFrameworkConfiguration)}.
         * 
         * @param frameworkConfiguration
         *        a consumer that will call methods on {@link MemberFrameworkConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #frameworkConfiguration(MemberFrameworkConfiguration)
         */
        default Builder frameworkConfiguration(Consumer<MemberFrameworkConfiguration.Builder> frameworkConfiguration) {
            return frameworkConfiguration(MemberFrameworkConfiguration.builder().applyMutation(frameworkConfiguration).build());
        }

        /**
         * <p>
         * Configuration properties for logging events associated with a member of a Managed Blockchain network.
         * </p>
         * 
         * @param logPublishingConfiguration
         *        Configuration properties for logging events associated with a member of a Managed Blockchain network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingConfiguration(MemberLogPublishingConfiguration logPublishingConfiguration);

        /**
         * <p>
         * Configuration properties for logging events associated with a member of a Managed Blockchain network.
         * </p>
         * This is a convenience that creates an instance of the {@link MemberLogPublishingConfiguration.Builder}
         * avoiding the need to create one manually via {@link MemberLogPublishingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link MemberLogPublishingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logPublishingConfiguration(MemberLogPublishingConfiguration)}
         * .
         * 
         * @param logPublishingConfiguration
         *        a consumer that will call methods on {@link MemberLogPublishingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingConfiguration(MemberLogPublishingConfiguration)
         */
        default Builder logPublishingConfiguration(Consumer<MemberLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return logPublishingConfiguration(MemberLogPublishingConfiguration.builder()
                    .applyMutation(logPublishingConfiguration).build());
        }

        /**
         * <p>
         * Tags assigned to the member. Tags consist of a key and optional value. For more information about tags, see
         * <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html">
         * Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.
         * </p>
         * <p>
         * When specifying tags during creation, you can specify multiple key-value pairs in a single request, with an
         * overall maximum of 50 tags added to each resource.
         * </p>
         * 
         * @param tags
         *        Tags assigned to the member. Tags consist of a key and optional value. For more information about
         *        tags, see <a href=
         *        "https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html"
         *        >Tagging Resources</a> in the <i>Amazon Managed Blockchain Hyperledger Fabric Developer Guide</i>.</p>
         *        <p>
         *        When specifying tags during creation, you can specify multiple key-value pairs in a single request,
         *        with an overall maximum of 50 tags added to each resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to use for
         * encryption at rest in the member. This parameter is inherited by any nodes that this member creates.
         * </p>
         * <p>
         * Use one of the following options to specify this parameter:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.
         * </p>
         * <p>
         * Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a
         * href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and
         * asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
         * </p>
         * <p>
         * The following is an example of a KMS key ARN:
         * <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param kmsKeyArn
         *        The Amazon Resource Name (ARN) of the customer managed key in AWS Key Management Service (AWS KMS) to
         *        use for encryption at rest in the member. This parameter is inherited by any nodes that this member
         *        creates.</p>
         *        <p>
         *        Use one of the following options to specify this parameter:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>Undefined or empty string</b> - The member uses an AWS owned KMS key for encryption by default.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>A valid symmetric customer managed KMS key</b> - The member uses the specified key for encryption.
         *        </p>
         *        <p>
         *        Amazon Managed Blockchain doesn't support asymmetric keys. For more information, see <a
         *        href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric
         *        and asymmetric keys</a> in the <i>AWS Key Management Service Developer Guide</i>.
         *        </p>
         *        <p>
         *        The following is an example of a KMS key ARN:
         *        <code>arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kmsKeyArn(String kmsKeyArn);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String description;

        private MemberFrameworkConfiguration frameworkConfiguration;

        private MemberLogPublishingConfiguration logPublishingConfiguration;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private String kmsKeyArn;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberConfiguration model) {
            name(model.name);
            description(model.description);
            frameworkConfiguration(model.frameworkConfiguration);
            logPublishingConfiguration(model.logPublishingConfiguration);
            tags(model.tags);
            kmsKeyArn(model.kmsKeyArn);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final MemberFrameworkConfiguration.Builder getFrameworkConfiguration() {
            return frameworkConfiguration != null ? frameworkConfiguration.toBuilder() : null;
        }

        public final void setFrameworkConfiguration(MemberFrameworkConfiguration.BuilderImpl frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration != null ? frameworkConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder frameworkConfiguration(MemberFrameworkConfiguration frameworkConfiguration) {
            this.frameworkConfiguration = frameworkConfiguration;
            return this;
        }

        public final MemberLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return logPublishingConfiguration != null ? logPublishingConfiguration.toBuilder() : null;
        }

        public final void setLogPublishingConfiguration(MemberLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        @Transient
        public final Builder logPublishingConfiguration(MemberLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = InputTagMapCopier.copy(tags);
            return this;
        }

        public final String getKmsKeyArn() {
            return kmsKeyArn;
        }

        public final void setKmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
        }

        @Override
        @Transient
        public final Builder kmsKeyArn(String kmsKeyArn) {
            this.kmsKeyArn = kmsKeyArn;
            return this;
        }

        @Override
        public MemberConfiguration build() {
            return new MemberConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
