/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An action to invite a specific AWS account to create a member and join the network. The <code>InviteAction</code> is
 * carried out when a <code>Proposal</code> is <code>APPROVED</code>.
 * </p>
 * <p>
 * Applies only to Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InviteAction implements SdkPojo, Serializable, ToCopyableBuilder<InviteAction.Builder, InviteAction> {
    private static final SdkField<String> PRINCIPAL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Principal").getter(getter(InviteAction::principal)).setter(setter(Builder::principal))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Principal").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PRINCIPAL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String principal;

    private InviteAction(BuilderImpl builder) {
        this.principal = builder.principal;
    }

    /**
     * <p>
     * The AWS account ID to invite.
     * </p>
     * 
     * @return The AWS account ID to invite.
     */
    public final String principal() {
        return principal;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(principal());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InviteAction)) {
            return false;
        }
        InviteAction other = (InviteAction) obj;
        return Objects.equals(principal(), other.principal());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InviteAction").add("Principal", principal()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Principal":
            return Optional.ofNullable(clazz.cast(principal()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InviteAction, T> g) {
        return obj -> g.apply((InviteAction) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, InviteAction> {
        /**
         * <p>
         * The AWS account ID to invite.
         * </p>
         * 
         * @param principal
         *        The AWS account ID to invite.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principal(String principal);
    }

    static final class BuilderImpl implements Builder {
        private String principal;

        private BuilderImpl() {
        }

        private BuilderImpl(InviteAction model) {
            principal(model.principal);
        }

        public final String getPrincipal() {
            return principal;
        }

        public final void setPrincipal(String principal) {
            this.principal = principal;
        }

        @Override
        public final Builder principal(String principal) {
            this.principal = principal;
            return this;
        }

        @Override
        public InviteAction build() {
            return new InviteAction(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
