/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Configuration properties for logging events associated with a member of a Managed Blockchain network using the
 * Hyperledger Fabric framework.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class MemberFabricLogPublishingConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<MemberFabricLogPublishingConfiguration.Builder, MemberFabricLogPublishingConfiguration> {
    private static final SdkField<LogConfigurations> CA_LOGS_FIELD = SdkField
            .<LogConfigurations> builder(MarshallingType.SDK_POJO).memberName("CaLogs")
            .getter(getter(MemberFabricLogPublishingConfiguration::caLogs)).setter(setter(Builder::caLogs))
            .constructor(LogConfigurations::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CaLogs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CA_LOGS_FIELD));

    private static final long serialVersionUID = 1L;

    private final LogConfigurations caLogs;

    private MemberFabricLogPublishingConfiguration(BuilderImpl builder) {
        this.caLogs = builder.caLogs;
    }

    /**
     * <p>
     * Configuration properties for logging events associated with a member's Certificate Authority (CA). CA logs help
     * you determine when a member in your account joins the network, or when new peers register with a member CA.
     * </p>
     * 
     * @return Configuration properties for logging events associated with a member's Certificate Authority (CA). CA
     *         logs help you determine when a member in your account joins the network, or when new peers register with
     *         a member CA.
     */
    public final LogConfigurations caLogs() {
        return caLogs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(caLogs());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemberFabricLogPublishingConfiguration)) {
            return false;
        }
        MemberFabricLogPublishingConfiguration other = (MemberFabricLogPublishingConfiguration) obj;
        return Objects.equals(caLogs(), other.caLogs());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("MemberFabricLogPublishingConfiguration").add("CaLogs", caLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "CaLogs":
            return Optional.ofNullable(clazz.cast(caLogs()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<MemberFabricLogPublishingConfiguration, T> g) {
        return obj -> g.apply((MemberFabricLogPublishingConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, MemberFabricLogPublishingConfiguration> {
        /**
         * <p>
         * Configuration properties for logging events associated with a member's Certificate Authority (CA). CA logs
         * help you determine when a member in your account joins the network, or when new peers register with a member
         * CA.
         * </p>
         * 
         * @param caLogs
         *        Configuration properties for logging events associated with a member's Certificate Authority (CA). CA
         *        logs help you determine when a member in your account joins the network, or when new peers register
         *        with a member CA.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder caLogs(LogConfigurations caLogs);

        /**
         * <p>
         * Configuration properties for logging events associated with a member's Certificate Authority (CA). CA logs
         * help you determine when a member in your account joins the network, or when new peers register with a member
         * CA.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfigurations.Builder} avoiding the
         * need to create one manually via {@link LogConfigurations#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogConfigurations.Builder#build()} is called immediately and its
         * result is passed to {@link #caLogs(LogConfigurations)}.
         * 
         * @param caLogs
         *        a consumer that will call methods on {@link LogConfigurations.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #caLogs(LogConfigurations)
         */
        default Builder caLogs(Consumer<LogConfigurations.Builder> caLogs) {
            return caLogs(LogConfigurations.builder().applyMutation(caLogs).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private LogConfigurations caLogs;

        private BuilderImpl() {
        }

        private BuilderImpl(MemberFabricLogPublishingConfiguration model) {
            caLogs(model.caLogs);
        }

        public final LogConfigurations.Builder getCaLogs() {
            return caLogs != null ? caLogs.toBuilder() : null;
        }

        public final void setCaLogs(LogConfigurations.BuilderImpl caLogs) {
            this.caLogs = caLogs != null ? caLogs.build() : null;
        }

        @Override
        public final Builder caLogs(LogConfigurations caLogs) {
            this.caLogs = caLogs;
            return this;
        }

        @Override
        public MemberFabricLogPublishingConfiguration build() {
            return new MemberFabricLogPublishingConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
