/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateNodeRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<UpdateNodeRequest.Builder, UpdateNodeRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NetworkId").getter(getter(UpdateNodeRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()).build();

    private static final SdkField<String> MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("MemberId").getter(getter(UpdateNodeRequest::memberId)).setter(setter(Builder::memberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MemberId").build()).build();

    private static final SdkField<String> NODE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("NodeId")
            .getter(getter(UpdateNodeRequest::nodeId)).setter(setter(Builder::nodeId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("nodeId").build()).build();

    private static final SdkField<NodeLogPublishingConfiguration> LOG_PUBLISHING_CONFIGURATION_FIELD = SdkField
            .<NodeLogPublishingConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("LogPublishingConfiguration")
            .getter(getter(UpdateNodeRequest::logPublishingConfiguration))
            .setter(setter(Builder::logPublishingConfiguration))
            .constructor(NodeLogPublishingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LogPublishingConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            MEMBER_ID_FIELD, NODE_ID_FIELD, LOG_PUBLISHING_CONFIGURATION_FIELD));

    private final String networkId;

    private final String memberId;

    private final String nodeId;

    private final NodeLogPublishingConfiguration logPublishingConfiguration;

    private UpdateNodeRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.memberId = builder.memberId;
        this.nodeId = builder.nodeId;
        this.logPublishingConfiguration = builder.logPublishingConfiguration;
    }

    /**
     * <p>
     * The unique identifier of the network that the node is on.
     * </p>
     * 
     * @return The unique identifier of the network that the node is on.
     */
    public final String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The unique identifier of the member that owns the node.
     * </p>
     * <p>
     * Applies only to Hyperledger Fabric.
     * </p>
     * 
     * @return The unique identifier of the member that owns the node.</p>
     *         <p>
     *         Applies only to Hyperledger Fabric.
     */
    public final String memberId() {
        return memberId;
    }

    /**
     * <p>
     * The unique identifier of the node.
     * </p>
     * 
     * @return The unique identifier of the node.
     */
    public final String nodeId() {
        return nodeId;
    }

    /**
     * <p>
     * Configuration properties for publishing to Amazon CloudWatch Logs.
     * </p>
     * 
     * @return Configuration properties for publishing to Amazon CloudWatch Logs.
     */
    public final NodeLogPublishingConfiguration logPublishingConfiguration() {
        return logPublishingConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(memberId());
        hashCode = 31 * hashCode + Objects.hashCode(nodeId());
        hashCode = 31 * hashCode + Objects.hashCode(logPublishingConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateNodeRequest)) {
            return false;
        }
        UpdateNodeRequest other = (UpdateNodeRequest) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(memberId(), other.memberId())
                && Objects.equals(nodeId(), other.nodeId())
                && Objects.equals(logPublishingConfiguration(), other.logPublishingConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateNodeRequest").add("NetworkId", networkId()).add("MemberId", memberId())
                .add("NodeId", nodeId()).add("LogPublishingConfiguration", logPublishingConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "MemberId":
            return Optional.ofNullable(clazz.cast(memberId()));
        case "NodeId":
            return Optional.ofNullable(clazz.cast(nodeId()));
        case "LogPublishingConfiguration":
            return Optional.ofNullable(clazz.cast(logPublishingConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateNodeRequest, T> g) {
        return obj -> g.apply((UpdateNodeRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateNodeRequest> {
        /**
         * <p>
         * The unique identifier of the network that the node is on.
         * </p>
         * 
         * @param networkId
         *        The unique identifier of the network that the node is on.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The unique identifier of the member that owns the node.
         * </p>
         * <p>
         * Applies only to Hyperledger Fabric.
         * </p>
         * 
         * @param memberId
         *        The unique identifier of the member that owns the node.</p>
         *        <p>
         *        Applies only to Hyperledger Fabric.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memberId(String memberId);

        /**
         * <p>
         * The unique identifier of the node.
         * </p>
         * 
         * @param nodeId
         *        The unique identifier of the node.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeId(String nodeId);

        /**
         * <p>
         * Configuration properties for publishing to Amazon CloudWatch Logs.
         * </p>
         * 
         * @param logPublishingConfiguration
         *        Configuration properties for publishing to Amazon CloudWatch Logs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration);

        /**
         * <p>
         * Configuration properties for publishing to Amazon CloudWatch Logs.
         * </p>
         * This is a convenience that creates an instance of the {@link NodeLogPublishingConfiguration.Builder} avoiding
         * the need to create one manually via {@link NodeLogPublishingConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NodeLogPublishingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #logPublishingConfiguration(NodeLogPublishingConfiguration)}.
         * 
         * @param logPublishingConfiguration
         *        a consumer that will call methods on {@link NodeLogPublishingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logPublishingConfiguration(NodeLogPublishingConfiguration)
         */
        default Builder logPublishingConfiguration(Consumer<NodeLogPublishingConfiguration.Builder> logPublishingConfiguration) {
            return logPublishingConfiguration(NodeLogPublishingConfiguration.builder().applyMutation(logPublishingConfiguration)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String networkId;

        private String memberId;

        private String nodeId;

        private NodeLogPublishingConfiguration logPublishingConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateNodeRequest model) {
            super(model);
            networkId(model.networkId);
            memberId(model.memberId);
            nodeId(model.nodeId);
            logPublishingConfiguration(model.logPublishingConfiguration);
        }

        public final String getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getMemberId() {
            return memberId;
        }

        @Override
        public final Builder memberId(String memberId) {
            this.memberId = memberId;
            return this;
        }

        public final void setMemberId(String memberId) {
            this.memberId = memberId;
        }

        public final String getNodeId() {
            return nodeId;
        }

        @Override
        public final Builder nodeId(String nodeId) {
            this.nodeId = nodeId;
            return this;
        }

        public final void setNodeId(String nodeId) {
            this.nodeId = nodeId;
        }

        public final NodeLogPublishingConfiguration.Builder getLogPublishingConfiguration() {
            return logPublishingConfiguration != null ? logPublishingConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder logPublishingConfiguration(NodeLogPublishingConfiguration logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration;
            return this;
        }

        public final void setLogPublishingConfiguration(NodeLogPublishingConfiguration.BuilderImpl logPublishingConfiguration) {
            this.logPublishingConfiguration = logPublishingConfiguration != null ? logPublishingConfiguration.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateNodeRequest build() {
            return new UpdateNodeRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
