/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain;

import java.net.URI;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.config.AwsClientOption;
import software.amazon.awssdk.core.client.config.ClientOption;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.endpoints.EndpointProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.managedblockchain.DefaultManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.DefaultManagedBlockchainBaseClientBuilder;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClient;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainAsyncClientBuilder;
import software.amazon.awssdk.services.managedblockchain.ManagedBlockchainServiceClientConfiguration;
import software.amazon.awssdk.services.managedblockchain.endpoints.ManagedBlockchainEndpointProvider;

@SdkInternalApi
final class DefaultManagedBlockchainAsyncClientBuilder
extends DefaultManagedBlockchainBaseClientBuilder<ManagedBlockchainAsyncClientBuilder, ManagedBlockchainAsyncClient>
implements ManagedBlockchainAsyncClientBuilder {
    DefaultManagedBlockchainAsyncClientBuilder() {
    }

    @Override
    public DefaultManagedBlockchainAsyncClientBuilder endpointProvider(ManagedBlockchainEndpointProvider endpointProvider) {
        this.clientConfiguration.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER, (Object)endpointProvider);
        return this;
    }

    protected final ManagedBlockchainAsyncClient buildClient() {
        SdkClientConfiguration clientConfiguration = super.asyncClientConfiguration();
        DefaultManagedBlockchainAsyncClientBuilder.validateClientOptions(clientConfiguration);
        ManagedBlockchainServiceClientConfiguration serviceClientConfiguration = this.initializeServiceClientConfig(clientConfiguration);
        DefaultManagedBlockchainAsyncClient client = new DefaultManagedBlockchainAsyncClient(serviceClientConfiguration, clientConfiguration);
        return client;
    }

    private ManagedBlockchainServiceClientConfiguration initializeServiceClientConfig(SdkClientConfiguration clientConfig) {
        URI endpointOverride = null;
        EndpointProvider endpointProvider = (EndpointProvider)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_PROVIDER);
        if (clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN) != null && Boolean.TRUE.equals(clientConfig.option((ClientOption)SdkClientOption.ENDPOINT_OVERRIDDEN))) {
            endpointOverride = (URI)clientConfig.option((ClientOption)SdkClientOption.ENDPOINT);
        }
        return ManagedBlockchainServiceClientConfiguration.builder().overrideConfiguration(this.overrideConfiguration()).region((Region)clientConfig.option((ClientOption)AwsClientOption.AWS_REGION)).endpointOverride(endpointOverride).endpointProvider(endpointProvider).build();
    }
}

