/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The voting rules for the network to decide if a proposal is accepted
 * </p>
 * <p>
 * Applies only to Hyperledger Fabric.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VotingPolicy implements SdkPojo, Serializable, ToCopyableBuilder<VotingPolicy.Builder, VotingPolicy> {
    private static final SdkField<ApprovalThresholdPolicy> APPROVAL_THRESHOLD_POLICY_FIELD = SdkField
            .<ApprovalThresholdPolicy> builder(MarshallingType.SDK_POJO).memberName("ApprovalThresholdPolicy")
            .getter(getter(VotingPolicy::approvalThresholdPolicy)).setter(setter(Builder::approvalThresholdPolicy))
            .constructor(ApprovalThresholdPolicy::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApprovalThresholdPolicy").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPROVAL_THRESHOLD_POLICY_FIELD));

    private static final long serialVersionUID = 1L;

    private final ApprovalThresholdPolicy approvalThresholdPolicy;

    private VotingPolicy(BuilderImpl builder) {
        this.approvalThresholdPolicy = builder.approvalThresholdPolicy;
    }

    /**
     * <p>
     * Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes
     * required for the proposal to be approved and the duration of the proposal. The policy applies to all proposals
     * and is specified when the network is created.
     * </p>
     * 
     * @return Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code>
     *         votes required for the proposal to be approved and the duration of the proposal. The policy applies to
     *         all proposals and is specified when the network is created.
     */
    public final ApprovalThresholdPolicy approvalThresholdPolicy() {
        return approvalThresholdPolicy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approvalThresholdPolicy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VotingPolicy)) {
            return false;
        }
        VotingPolicy other = (VotingPolicy) obj;
        return Objects.equals(approvalThresholdPolicy(), other.approvalThresholdPolicy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VotingPolicy").add("ApprovalThresholdPolicy", approvalThresholdPolicy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ApprovalThresholdPolicy":
            return Optional.ofNullable(clazz.cast(approvalThresholdPolicy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VotingPolicy, T> g) {
        return obj -> g.apply((VotingPolicy) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VotingPolicy> {
        /**
         * <p>
         * Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes
         * required for the proposal to be approved and the duration of the proposal. The policy applies to all
         * proposals and is specified when the network is created.
         * </p>
         * 
         * @param approvalThresholdPolicy
         *        Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code>
         *        votes required for the proposal to be approved and the duration of the proposal. The policy applies to
         *        all proposals and is specified when the network is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approvalThresholdPolicy(ApprovalThresholdPolicy approvalThresholdPolicy);

        /**
         * <p>
         * Defines the rules for the network for voting on proposals, such as the percentage of <code>YES</code> votes
         * required for the proposal to be approved and the duration of the proposal. The policy applies to all
         * proposals and is specified when the network is created.
         * </p>
         * This is a convenience method that creates an instance of the {@link ApprovalThresholdPolicy.Builder} avoiding
         * the need to create one manually via {@link ApprovalThresholdPolicy#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ApprovalThresholdPolicy.Builder#build()} is called immediately
         * and its result is passed to {@link #approvalThresholdPolicy(ApprovalThresholdPolicy)}.
         * 
         * @param approvalThresholdPolicy
         *        a consumer that will call methods on {@link ApprovalThresholdPolicy.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #approvalThresholdPolicy(ApprovalThresholdPolicy)
         */
        default Builder approvalThresholdPolicy(Consumer<ApprovalThresholdPolicy.Builder> approvalThresholdPolicy) {
            return approvalThresholdPolicy(ApprovalThresholdPolicy.builder().applyMutation(approvalThresholdPolicy).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private ApprovalThresholdPolicy approvalThresholdPolicy;

        private BuilderImpl() {
        }

        private BuilderImpl(VotingPolicy model) {
            approvalThresholdPolicy(model.approvalThresholdPolicy);
        }

        public final ApprovalThresholdPolicy.Builder getApprovalThresholdPolicy() {
            return approvalThresholdPolicy != null ? approvalThresholdPolicy.toBuilder() : null;
        }

        public final void setApprovalThresholdPolicy(ApprovalThresholdPolicy.BuilderImpl approvalThresholdPolicy) {
            this.approvalThresholdPolicy = approvalThresholdPolicy != null ? approvalThresholdPolicy.build() : null;
        }

        @Override
        public final Builder approvalThresholdPolicy(ApprovalThresholdPolicy approvalThresholdPolicy) {
            this.approvalThresholdPolicy = approvalThresholdPolicy;
            return this;
        }

        @Override
        public VotingPolicy build() {
            return new VotingPolicy(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
