/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Attributes of Ethereum for a network.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class NetworkEthereumAttributes implements SdkPojo, Serializable,
        ToCopyableBuilder<NetworkEthereumAttributes.Builder, NetworkEthereumAttributes> {
    private static final SdkField<String> CHAIN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ChainId").getter(getter(NetworkEthereumAttributes::chainId)).setter(setter(Builder::chainId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ChainId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CHAIN_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String chainId;

    private NetworkEthereumAttributes(BuilderImpl builder) {
        this.chainId = builder.chainId;
    }

    /**
     * <p>
     * The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:
     * </p>
     * <ul>
     * <li>
     * <p>
     * mainnet = <code>1</code>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         mainnet = <code>1</code>
     *         </p>
     *         </li>
     */
    public final String chainId() {
        return chainId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(chainId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NetworkEthereumAttributes)) {
            return false;
        }
        NetworkEthereumAttributes other = (NetworkEthereumAttributes) obj;
        return Objects.equals(chainId(), other.chainId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("NetworkEthereumAttributes").add("ChainId", chainId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ChainId":
            return Optional.ofNullable(clazz.cast(chainId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<NetworkEthereumAttributes, T> g) {
        return obj -> g.apply((NetworkEthereumAttributes) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, NetworkEthereumAttributes> {
        /**
         * <p>
         * The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:
         * </p>
         * <ul>
         * <li>
         * <p>
         * mainnet = <code>1</code>
         * </p>
         * </li>
         * </ul>
         * 
         * @param chainId
         *        The Ethereum <code>CHAIN_ID</code> associated with the Ethereum network. Chain IDs are as follows:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        mainnet = <code>1</code>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder chainId(String chainId);
    }

    static final class BuilderImpl implements Builder {
        private String chainId;

        private BuilderImpl() {
        }

        private BuilderImpl(NetworkEthereumAttributes model) {
            chainId(model.chainId);
        }

        public final String getChainId() {
            return chainId;
        }

        public final void setChainId(String chainId) {
            this.chainId = chainId;
        }

        @Override
        public final Builder chainId(String chainId) {
            this.chainId = chainId;
            return this;
        }

        @Override
        public NetworkEthereumAttributes build() {
            return new NetworkEthereumAttributes(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
