/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.AccessorNetworkType;
import software.amazon.awssdk.services.managedblockchain.model.ManagedBlockchainResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateAccessorResponse
extends ManagedBlockchainResponse
implements ToCopyableBuilder<Builder, CreateAccessorResponse> {
    private static final SdkField<String> ACCESSOR_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("AccessorId").getter(CreateAccessorResponse.getter(CreateAccessorResponse::accessorId)).setter(CreateAccessorResponse.setter(Builder::accessorId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessorId").build()}).build();
    private static final SdkField<String> BILLING_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("BillingToken").getter(CreateAccessorResponse.getter(CreateAccessorResponse::billingToken)).setter(CreateAccessorResponse.setter(Builder::billingToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("BillingToken").build()}).build();
    private static final SdkField<String> NETWORK_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkType").getter(CreateAccessorResponse.getter(CreateAccessorResponse::networkTypeAsString)).setter(CreateAccessorResponse.setter(Builder::networkType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCESSOR_ID_FIELD, BILLING_TOKEN_FIELD, NETWORK_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateAccessorResponse.memberNameToFieldInitializer();
    private final String accessorId;
    private final String billingToken;
    private final String networkType;

    private CreateAccessorResponse(BuilderImpl builder) {
        super(builder);
        this.accessorId = builder.accessorId;
        this.billingToken = builder.billingToken;
        this.networkType = builder.networkType;
    }

    public final String accessorId() {
        return this.accessorId;
    }

    public final String billingToken() {
        return this.billingToken;
    }

    public final AccessorNetworkType networkType() {
        return AccessorNetworkType.fromValue(this.networkType);
    }

    public final String networkTypeAsString() {
        return this.networkType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.accessorId());
        hashCode = 31 * hashCode + Objects.hashCode(this.billingToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAccessorResponse)) {
            return false;
        }
        CreateAccessorResponse other = (CreateAccessorResponse)((Object)obj);
        return Objects.equals(this.accessorId(), other.accessorId()) && Objects.equals(this.billingToken(), other.billingToken()) && Objects.equals(this.networkTypeAsString(), other.networkTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateAccessorResponse").add("AccessorId", (Object)this.accessorId()).add("BillingToken", (Object)this.billingToken()).add("NetworkType", (Object)this.networkTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "AccessorId": {
                return Optional.ofNullable(clazz.cast(this.accessorId()));
            }
            case "BillingToken": {
                return Optional.ofNullable(clazz.cast(this.billingToken()));
            }
            case "NetworkType": {
                return Optional.ofNullable(clazz.cast(this.networkTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("AccessorId", ACCESSOR_ID_FIELD);
        map.put("BillingToken", BILLING_TOKEN_FIELD);
        map.put("NetworkType", NETWORK_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAccessorResponse, T> g) {
        return obj -> g.apply((CreateAccessorResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainResponse.BuilderImpl
    implements Builder {
        private String accessorId;
        private String billingToken;
        private String networkType;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAccessorResponse model) {
            super(model);
            this.accessorId(model.accessorId);
            this.billingToken(model.billingToken);
            this.networkType(model.networkType);
        }

        public final String getAccessorId() {
            return this.accessorId;
        }

        public final void setAccessorId(String accessorId) {
            this.accessorId = accessorId;
        }

        @Override
        public final Builder accessorId(String accessorId) {
            this.accessorId = accessorId;
            return this;
        }

        public final String getBillingToken() {
            return this.billingToken;
        }

        public final void setBillingToken(String billingToken) {
            this.billingToken = billingToken;
        }

        @Override
        public final Builder billingToken(String billingToken) {
            this.billingToken = billingToken;
            return this;
        }

        public final String getNetworkType() {
            return this.networkType;
        }

        public final void setNetworkType(String networkType) {
            this.networkType = networkType;
        }

        @Override
        public final Builder networkType(String networkType) {
            this.networkType = networkType;
            return this;
        }

        @Override
        public final Builder networkType(AccessorNetworkType networkType) {
            this.networkType(networkType == null ? null : networkType.toString());
            return this;
        }

        @Override
        public CreateAccessorResponse build() {
            return new CreateAccessorResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ManagedBlockchainResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateAccessorResponse> {
        public Builder accessorId(String var1);

        public Builder billingToken(String var1);

        public Builder networkType(String var1);

        public Builder networkType(AccessorNetworkType var1);
    }
}

