/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListMembersResponse extends ManagedBlockchainResponse implements
        ToCopyableBuilder<ListMembersResponse.Builder, ListMembersResponse> {
    private static final SdkField<List<MemberSummary>> MEMBERS_FIELD = SdkField
            .<List<MemberSummary>> builder(MarshallingType.LIST)
            .getter(getter(ListMembersResponse::members))
            .setter(setter(Builder::members))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Members").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<MemberSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(MemberSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ListMembersResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MEMBERS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<MemberSummary> members;

    private final String nextToken;

    private ListMembersResponse(BuilderImpl builder) {
        super(builder);
        this.members = builder.members;
        this.nextToken = builder.nextToken;
    }

    /**
     * <p>
     * An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
     */
    public List<MemberSummary> members() {
        return members;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(members());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListMembersResponse)) {
            return false;
        }
        ListMembersResponse other = (ListMembersResponse) obj;
        return Objects.equals(members(), other.members()) && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ListMembersResponse").add("Members", members()).add("NextToken", nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Members":
            return Optional.ofNullable(clazz.cast(members()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListMembersResponse, T> g) {
        return obj -> g.apply((ListMembersResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListMembersResponse> {
        /**
         * <p>
         * An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
         * </p>
         * 
         * @param members
         *        An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(Collection<MemberSummary> members);

        /**
         * <p>
         * An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
         * </p>
         * 
         * @param members
         *        An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder members(MemberSummary... members);

        /**
         * <p>
         * An array of <code>MemberSummary</code> objects. Each object contains details about a network member.
         * </p>
         * This is a convenience that creates an instance of the {@link List<MemberSummary>.Builder} avoiding the need
         * to create one manually via {@link List<MemberSummary>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<MemberSummary>.Builder#build()} is called immediately and
         * its result is passed to {@link #members(List<MemberSummary>)}.
         * 
         * @param members
         *        a consumer that will call methods on {@link List<MemberSummary>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #members(List<MemberSummary>)
         */
        Builder members(Consumer<MemberSummary.Builder>... members);

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ManagedBlockchainResponse.BuilderImpl implements Builder {
        private List<MemberSummary> members = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListMembersResponse model) {
            super(model);
            members(model.members);
            nextToken(model.nextToken);
        }

        public final Collection<MemberSummary.Builder> getMembers() {
            return members != null ? members.stream().map(MemberSummary::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder members(Collection<MemberSummary> members) {
            this.members = MemberSummaryListCopier.copy(members);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(MemberSummary... members) {
            members(Arrays.asList(members));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder members(Consumer<MemberSummary.Builder>... members) {
            members(Stream.of(members).map(c -> MemberSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setMembers(Collection<MemberSummary.BuilderImpl> members) {
            this.members = MemberSummaryListCopier.copyFromBuilder(members);
        }

        public final String getNextToken() {
            return nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListMembersResponse build() {
            return new ListMembersResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
