/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchain.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoteOnProposalRequest extends ManagedBlockchainRequest implements
        ToCopyableBuilder<VoteOnProposalRequest.Builder, VoteOnProposalRequest> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoteOnProposalRequest::networkId)).setter(setter(Builder::networkId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("networkId").build()).build();

    private static final SdkField<String> PROPOSAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoteOnProposalRequest::proposalId)).setter(setter(Builder::proposalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("proposalId").build()).build();

    private static final SdkField<String> VOTER_MEMBER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoteOnProposalRequest::voterMemberId)).setter(setter(Builder::voterMemberId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VoterMemberId").build()).build();

    private static final SdkField<String> VOTE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(VoteOnProposalRequest::voteAsString)).setter(setter(Builder::vote))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Vote").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD,
            PROPOSAL_ID_FIELD, VOTER_MEMBER_ID_FIELD, VOTE_FIELD));

    private final String networkId;

    private final String proposalId;

    private final String voterMemberId;

    private final String vote;

    private VoteOnProposalRequest(BuilderImpl builder) {
        super(builder);
        this.networkId = builder.networkId;
        this.proposalId = builder.proposalId;
        this.voterMemberId = builder.voterMemberId;
        this.vote = builder.vote;
    }

    /**
     * <p>
     * The unique identifier of the network.
     * </p>
     * 
     * @return The unique identifier of the network.
     */
    public String networkId() {
        return networkId;
    }

    /**
     * <p>
     * The unique identifier of the proposal.
     * </p>
     * 
     * @return The unique identifier of the proposal.
     */
    public String proposalId() {
        return proposalId;
    }

    /**
     * <p>
     * The unique identifier of the member casting the vote.
     * </p>
     * 
     * @return The unique identifier of the member casting the vote.
     */
    public String voterMemberId() {
        return voterMemberId;
    }

    /**
     * <p>
     * The value of the vote.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vote} will return
     * {@link VoteValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voteAsString}.
     * </p>
     * 
     * @return The value of the vote.
     * @see VoteValue
     */
    public VoteValue vote() {
        return VoteValue.fromValue(vote);
    }

    /**
     * <p>
     * The value of the vote.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #vote} will return
     * {@link VoteValue#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #voteAsString}.
     * </p>
     * 
     * @return The value of the vote.
     * @see VoteValue
     */
    public String voteAsString() {
        return vote;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(networkId());
        hashCode = 31 * hashCode + Objects.hashCode(proposalId());
        hashCode = 31 * hashCode + Objects.hashCode(voterMemberId());
        hashCode = 31 * hashCode + Objects.hashCode(voteAsString());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoteOnProposalRequest)) {
            return false;
        }
        VoteOnProposalRequest other = (VoteOnProposalRequest) obj;
        return Objects.equals(networkId(), other.networkId()) && Objects.equals(proposalId(), other.proposalId())
                && Objects.equals(voterMemberId(), other.voterMemberId()) && Objects.equals(voteAsString(), other.voteAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("VoteOnProposalRequest").add("NetworkId", networkId()).add("ProposalId", proposalId())
                .add("VoterMemberId", voterMemberId()).add("Vote", voteAsString()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "NetworkId":
            return Optional.ofNullable(clazz.cast(networkId()));
        case "ProposalId":
            return Optional.ofNullable(clazz.cast(proposalId()));
        case "VoterMemberId":
            return Optional.ofNullable(clazz.cast(voterMemberId()));
        case "Vote":
            return Optional.ofNullable(clazz.cast(voteAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<VoteOnProposalRequest, T> g) {
        return obj -> g.apply((VoteOnProposalRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainRequest.Builder, SdkPojo, CopyableBuilder<Builder, VoteOnProposalRequest> {
        /**
         * <p>
         * The unique identifier of the network.
         * </p>
         * 
         * @param networkId
         *        The unique identifier of the network.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkId(String networkId);

        /**
         * <p>
         * The unique identifier of the proposal.
         * </p>
         * 
         * @param proposalId
         *        The unique identifier of the proposal.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder proposalId(String proposalId);

        /**
         * <p>
         * The unique identifier of the member casting the vote.
         * </p>
         * 
         * @param voterMemberId
         *        The unique identifier of the member casting the vote.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voterMemberId(String voterMemberId);

        /**
         * <p>
         * The value of the vote.
         * </p>
         * 
         * @param vote
         *        The value of the vote.
         * @see VoteValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoteValue
         */
        Builder vote(String vote);

        /**
         * <p>
         * The value of the vote.
         * </p>
         * 
         * @param vote
         *        The value of the vote.
         * @see VoteValue
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see VoteValue
         */
        Builder vote(VoteValue vote);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainRequest.BuilderImpl implements Builder {
        private String networkId;

        private String proposalId;

        private String voterMemberId;

        private String vote;

        private BuilderImpl() {
        }

        private BuilderImpl(VoteOnProposalRequest model) {
            super(model);
            networkId(model.networkId);
            proposalId(model.proposalId);
            voterMemberId(model.voterMemberId);
            vote(model.vote);
        }

        public final String getNetworkId() {
            return networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getProposalId() {
            return proposalId;
        }

        @Override
        public final Builder proposalId(String proposalId) {
            this.proposalId = proposalId;
            return this;
        }

        public final void setProposalId(String proposalId) {
            this.proposalId = proposalId;
        }

        public final String getVoterMemberId() {
            return voterMemberId;
        }

        @Override
        public final Builder voterMemberId(String voterMemberId) {
            this.voterMemberId = voterMemberId;
            return this;
        }

        public final void setVoterMemberId(String voterMemberId) {
            this.voterMemberId = voterMemberId;
        }

        public final String getVoteAsString() {
            return vote;
        }

        @Override
        public final Builder vote(String vote) {
            this.vote = vote;
            return this;
        }

        @Override
        public final Builder vote(VoteValue vote) {
            this.vote(vote == null ? null : vote.toString());
            return this;
        }

        public final void setVote(String vote) {
            this.vote = vote;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public VoteOnProposalRequest build() {
            return new VoteOnProposalRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
