/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchain.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchain.model.MemberFrameworkAttributes;
import software.amazon.awssdk.services.managedblockchain.model.MemberStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Member
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Member> {
    private static final SdkField<String> NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Member.getter(Member::networkId)).setter(Member.setter(Builder::networkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkId").build()}).build();
    private static final SdkField<String> ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Member.getter(Member::id)).setter(Member.setter(Builder::id)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()}).build();
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Member.getter(Member::name)).setter(Member.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Member.getter(Member::description)).setter(Member.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<MemberFrameworkAttributes> FRAMEWORK_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(Member.getter(Member::frameworkAttributes)).setter(Member.setter(Builder::frameworkAttributes)).constructor(MemberFrameworkAttributes::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FrameworkAttributes").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(Member.getter(Member::statusAsString)).setter(Member.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Status").build()}).build();
    private static final SdkField<Instant> CREATION_DATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).getter(Member.getter(Member::creationDate)).setter(Member.setter(Builder::creationDate)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreationDate").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_ID_FIELD, ID_FIELD, NAME_FIELD, DESCRIPTION_FIELD, FRAMEWORK_ATTRIBUTES_FIELD, STATUS_FIELD, CREATION_DATE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String networkId;
    private final String id;
    private final String name;
    private final String description;
    private final MemberFrameworkAttributes frameworkAttributes;
    private final String status;
    private final Instant creationDate;

    private Member(BuilderImpl builder) {
        this.networkId = builder.networkId;
        this.id = builder.id;
        this.name = builder.name;
        this.description = builder.description;
        this.frameworkAttributes = builder.frameworkAttributes;
        this.status = builder.status;
        this.creationDate = builder.creationDate;
    }

    public String networkId() {
        return this.networkId;
    }

    public String id() {
        return this.id;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public MemberFrameworkAttributes frameworkAttributes() {
        return this.frameworkAttributes;
    }

    public MemberStatus status() {
        return MemberStatus.fromValue(this.status);
    }

    public String statusAsString() {
        return this.status;
    }

    public Instant creationDate() {
        return this.creationDate;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.networkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.id());
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.frameworkAttributes());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.creationDate());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Member)) {
            return false;
        }
        Member other = (Member)obj;
        return Objects.equals(this.networkId(), other.networkId()) && Objects.equals(this.id(), other.id()) && Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.frameworkAttributes(), other.frameworkAttributes()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.creationDate(), other.creationDate());
    }

    public String toString() {
        return ToString.builder((String)"Member").add("NetworkId", (Object)this.networkId()).add("Id", (Object)this.id()).add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("FrameworkAttributes", (Object)this.frameworkAttributes()).add("Status", (Object)this.statusAsString()).add("CreationDate", (Object)this.creationDate()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "NetworkId": {
                return Optional.ofNullable(clazz.cast(this.networkId()));
            }
            case "Id": {
                return Optional.ofNullable(clazz.cast(this.id()));
            }
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "FrameworkAttributes": {
                return Optional.ofNullable(clazz.cast(this.frameworkAttributes()));
            }
            case "Status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "CreationDate": {
                return Optional.ofNullable(clazz.cast(this.creationDate()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Member, T> g) {
        return obj -> g.apply((Member)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String networkId;
        private String id;
        private String name;
        private String description;
        private MemberFrameworkAttributes frameworkAttributes;
        private String status;
        private Instant creationDate;

        private BuilderImpl() {
        }

        private BuilderImpl(Member model) {
            this.networkId(model.networkId);
            this.id(model.id);
            this.name(model.name);
            this.description(model.description);
            this.frameworkAttributes(model.frameworkAttributes);
            this.status(model.status);
            this.creationDate(model.creationDate);
        }

        public final String getNetworkId() {
            return this.networkId;
        }

        @Override
        public final Builder networkId(String networkId) {
            this.networkId = networkId;
            return this;
        }

        public final void setNetworkId(String networkId) {
            this.networkId = networkId;
        }

        public final String getId() {
            return this.id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final MemberFrameworkAttributes.Builder getFrameworkAttributes() {
            return this.frameworkAttributes != null ? this.frameworkAttributes.toBuilder() : null;
        }

        @Override
        public final Builder frameworkAttributes(MemberFrameworkAttributes frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes;
            return this;
        }

        public final void setFrameworkAttributes(MemberFrameworkAttributes.BuilderImpl frameworkAttributes) {
            this.frameworkAttributes = frameworkAttributes != null ? frameworkAttributes.build() : null;
        }

        public final String getStatusAsString() {
            return this.status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(MemberStatus status) {
            this.status(status.toString());
            return this;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        public final Instant getCreationDate() {
            return this.creationDate;
        }

        @Override
        public final Builder creationDate(Instant creationDate) {
            this.creationDate = creationDate;
            return this;
        }

        public final void setCreationDate(Instant creationDate) {
            this.creationDate = creationDate;
        }

        public Member build() {
            return new Member(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Member> {
        public Builder networkId(String var1);

        public Builder id(String var1);

        public Builder name(String var1);

        public Builder description(String var1);

        public Builder frameworkAttributes(MemberFrameworkAttributes var1);

        default public Builder frameworkAttributes(Consumer<MemberFrameworkAttributes.Builder> frameworkAttributes) {
            return this.frameworkAttributes((MemberFrameworkAttributes)((MemberFrameworkAttributes.Builder)MemberFrameworkAttributes.builder().applyMutation(frameworkAttributes)).build());
        }

        public Builder status(String var1);

        public Builder status(MemberStatus var1);

        public Builder creationDate(Instant var1);
    }
}

