/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery;

import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse;
import software.amazon.awssdk.services.managedblockchainquery.paginators.ListAssetContractsPublisher;
import software.amazon.awssdk.services.managedblockchainquery.paginators.ListTokenBalancesPublisher;
import software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionEventsPublisher;
import software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionsPublisher;

/**
 * Service client for accessing Amazon Managed Blockchain Query asynchronously. This can be created using the static
 * {@link #builder()} method.
 *
 * <p>
 * Amazon Managed Blockchain (AMB) Query provides you with convenient access to multi-blockchain network data, which
 * makes it easier for you to extract contextual data related to blockchain activity. You can use AMB Query to read data
 * from public blockchain networks, such as Bitcoin Mainnet and Ethereum Mainnet. You can also get information such as
 * the current and historical balances of addresses, or you can get a list of blockchain transactions for a given time
 * period. Additionally, you can get details of a given transaction, such as transaction events, which you can further
 * analyze or use in business logic for your applications.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface ManagedBlockchainQueryAsyncClient extends AwsClient {
    String SERVICE_NAME = "managedblockchain-query";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "managedblockchain-query";

    /**
     * <p>
     * Gets the token balance for a batch of tokens by using the <code>BatchGetTokenBalance</code> action for every
     * token in the request.
     * </p>
     * <note>
     * <p>
     * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     * </p>
     * </note>
     *
     * @param batchGetTokenBalanceRequest
     * @return A Java Future containing the result of the BatchGetTokenBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.BatchGetTokenBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/BatchGetTokenBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetTokenBalanceResponse> batchGetTokenBalance(
            BatchGetTokenBalanceRequest batchGetTokenBalanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the token balance for a batch of tokens by using the <code>BatchGetTokenBalance</code> action for every
     * token in the request.
     * </p>
     * <note>
     * <p>
     * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchGetTokenBalanceRequest.Builder} avoiding the
     * need to create one manually via {@link BatchGetTokenBalanceRequest#builder()}
     * </p>
     *
     * @param batchGetTokenBalanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.BatchGetTokenBalanceRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the BatchGetTokenBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.BatchGetTokenBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/BatchGetTokenBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<BatchGetTokenBalanceResponse> batchGetTokenBalance(
            Consumer<BatchGetTokenBalanceRequest.Builder> batchGetTokenBalanceRequest) {
        return batchGetTokenBalance(BatchGetTokenBalanceRequest.builder().applyMutation(batchGetTokenBalanceRequest).build());
    }

    /**
     * <p>
     * Gets the information about a specific contract deployed on the blockchain.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The Bitcoin blockchain networks do not support this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Metadata is currently only available for some <code>ERC-20</code> contracts. Metadata will be available for
     * additional contracts in the future.
     * </p>
     * </li>
     * </ul>
     * </note>
     *
     * @param getAssetContractRequest
     * @return A Java Future containing the result of the GetAssetContract operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.GetAssetContract
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetAssetContract"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetContractResponse> getAssetContract(GetAssetContractRequest getAssetContractRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the information about a specific contract deployed on the blockchain.
     * </p>
     * <note>
     * <ul>
     * <li>
     * <p>
     * The Bitcoin blockchain networks do not support this operation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Metadata is currently only available for some <code>ERC-20</code> contracts. Metadata will be available for
     * additional contracts in the future.
     * </p>
     * </li>
     * </ul>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetAssetContractRequest.Builder} avoiding the need
     * to create one manually via {@link GetAssetContractRequest#builder()}
     * </p>
     *
     * @param getAssetContractRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.GetAssetContractRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetAssetContract operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.GetAssetContract
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetAssetContract"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetAssetContractResponse> getAssetContract(
            Consumer<GetAssetContractRequest.Builder> getAssetContractRequest) {
        return getAssetContract(GetAssetContractRequest.builder().applyMutation(getAssetContractRequest).build());
    }

    /**
     * <p>
     * Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the
     * blockchain.
     * </p>
     * <note>
     * <p>
     * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     * </p>
     * </note>
     *
     * @param getTokenBalanceRequest
     * @return A Java Future containing the result of the GetTokenBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.GetTokenBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTokenBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTokenBalanceResponse> getTokenBalance(GetTokenBalanceRequest getTokenBalanceRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Gets the balance of a specific token, including native tokens, for a given address (wallet or contract) on the
     * blockchain.
     * </p>
     * <note>
     * <p>
     * Only the native tokens BTC,ETH, and the ERC-20, ERC-721, and ERC 1155 token standards are supported.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTokenBalanceRequest.Builder} avoiding the need
     * to create one manually via {@link GetTokenBalanceRequest#builder()}
     * </p>
     *
     * @param getTokenBalanceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.GetTokenBalanceRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTokenBalance operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.GetTokenBalance
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTokenBalance"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTokenBalanceResponse> getTokenBalance(
            Consumer<GetTokenBalanceRequest.Builder> getTokenBalanceRequest) {
        return getTokenBalance(GetTokenBalanceRequest.builder().applyMutation(getTokenBalanceRequest).build());
    }

    /**
     * <p>
     * Get the details of a transaction.
     * </p>
     *
     * @param getTransactionRequest
     * @return A Java Future containing the result of the GetTransaction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.GetTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransactionResponse> getTransaction(GetTransactionRequest getTransactionRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get the details of a transaction.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTransactionRequest.Builder} avoiding the need to
     * create one manually via {@link GetTransactionRequest#builder()}
     * </p>
     *
     * @param getTransactionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.GetTransactionRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the GetTransaction operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>ResourceNotFoundException The resource was not found.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.GetTransaction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/GetTransaction"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<GetTransactionResponse> getTransaction(Consumer<GetTransactionRequest.Builder> getTransactionRequest) {
        return getTransaction(GetTransactionRequest.builder().applyMutation(getTransactionRequest).build());
    }

    /**
     * <p>
     * Lists all the contracts for a given contract type deployed by an address (either a contract address or a wallet
     * address).
     * </p>
     * <p>
     * The Bitcoin blockchain networks do not support this operation.
     * </p>
     *
     * @param listAssetContractsRequest
     * @return A Java Future containing the result of the ListAssetContracts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListAssetContracts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListAssetContracts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetContractsResponse> listAssetContracts(ListAssetContractsRequest listAssetContractsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all the contracts for a given contract type deployed by an address (either a contract address or a wallet
     * address).
     * </p>
     * <p>
     * The Bitcoin blockchain networks do not support this operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetContractsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetContractsRequest#builder()}
     * </p>
     *
     * @param listAssetContractsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListAssetContracts operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListAssetContracts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListAssetContracts"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListAssetContractsResponse> listAssetContracts(
            Consumer<ListAssetContractsRequest.Builder> listAssetContractsRequest) {
        return listAssetContracts(ListAssetContractsRequest.builder().applyMutation(listAssetContractsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetContracts(software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListAssetContractsPublisher publisher = client.listAssetContractsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListAssetContractsPublisher publisher = client.listAssetContractsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetContracts(software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listAssetContractsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListAssetContracts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListAssetContracts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetContractsPublisher listAssetContractsPaginator(ListAssetContractsRequest listAssetContractsRequest) {
        return new ListAssetContractsPublisher(this, listAssetContractsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listAssetContracts(software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListAssetContractsPublisher publisher = client.listAssetContractsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListAssetContractsPublisher publisher = client.listAssetContractsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listAssetContracts(software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssetContractsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssetContractsRequest#builder()}
     * </p>
     *
     * @param listAssetContractsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListAssetContractsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListAssetContracts
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListAssetContracts"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssetContractsPublisher listAssetContractsPaginator(
            Consumer<ListAssetContractsRequest.Builder> listAssetContractsRequest) {
        return listAssetContractsPaginator(ListAssetContractsRequest.builder().applyMutation(listAssetContractsRequest).build());
    }

    /**
     * <p>
     * This action returns the following for a given blockchain network:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Lists all token balances owned by an address (either a contract address or a wallet address).
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists all token balances for all tokens created by a contract.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists all token balances for a given token.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You must always specify the network property of the <code>tokenFilter</code> when using this operation.
     * </p>
     * </note>
     *
     * @param listTokenBalancesRequest
     * @return A Java Future containing the result of the ListTokenBalances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTokenBalances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTokenBalances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTokenBalancesResponse> listTokenBalances(ListTokenBalancesRequest listTokenBalancesRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * This action returns the following for a given blockchain network:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Lists all token balances owned by an address (either a contract address or a wallet address).
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists all token balances for all tokens created by a contract.
     * </p>
     * </li>
     * <li>
     * <p>
     * Lists all token balances for a given token.
     * </p>
     * </li>
     * </ul>
     * <note>
     * <p>
     * You must always specify the network property of the <code>tokenFilter</code> when using this operation.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTokenBalancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTokenBalancesRequest#builder()}
     * </p>
     *
     * @param listTokenBalancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTokenBalances operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTokenBalances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTokenBalances"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTokenBalancesResponse> listTokenBalances(
            Consumer<ListTokenBalancesRequest.Builder> listTokenBalancesRequest) {
        return listTokenBalances(ListTokenBalancesRequest.builder().applyMutation(listTokenBalancesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTokenBalances(software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTokenBalancesPublisher publisher = client.listTokenBalancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTokenBalancesPublisher publisher = client.listTokenBalancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTokenBalances(software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTokenBalancesRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTokenBalances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTokenBalances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTokenBalancesPublisher listTokenBalancesPaginator(ListTokenBalancesRequest listTokenBalancesRequest) {
        return new ListTokenBalancesPublisher(this, listTokenBalancesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTokenBalances(software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTokenBalancesPublisher publisher = client.listTokenBalancesPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTokenBalancesPublisher publisher = client.listTokenBalancesPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTokenBalances(software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTokenBalancesRequest.Builder} avoiding the need
     * to create one manually via {@link ListTokenBalancesRequest#builder()}
     * </p>
     *
     * @param listTokenBalancesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTokenBalances
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTokenBalances"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTokenBalancesPublisher listTokenBalancesPaginator(
            Consumer<ListTokenBalancesRequest.Builder> listTokenBalancesRequest) {
        return listTokenBalancesPaginator(ListTokenBalancesRequest.builder().applyMutation(listTokenBalancesRequest).build());
    }

    /**
     * <p>
     * An array of <code>TransactionEvent</code> objects. Each object contains details about the transaction event.
     * </p>
     *
     * @param listTransactionEventsRequest
     * @return A Java Future containing the result of the ListTransactionEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTransactionEventsResponse> listTransactionEvents(
            ListTransactionEventsRequest listTransactionEventsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * An array of <code>TransactionEvent</code> objects. Each object contains details about the transaction event.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransactionEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTransactionEventsRequest#builder()}
     * </p>
     *
     * @param listTransactionEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest.Builder}
     *        to create a request.
     * @return A Java Future containing the result of the ListTransactionEvents operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTransactionEventsResponse> listTransactionEvents(
            Consumer<ListTransactionEventsRequest.Builder> listTransactionEventsRequest) {
        return listTransactionEvents(ListTransactionEventsRequest.builder().applyMutation(listTransactionEventsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransactionEvents(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionEventsPublisher publisher = client.listTransactionEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionEventsPublisher publisher = client.listTransactionEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransactionEvents(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTransactionEventsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionEventsPublisher listTransactionEventsPaginator(
            ListTransactionEventsRequest listTransactionEventsRequest) {
        return new ListTransactionEventsPublisher(this, listTransactionEventsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransactionEvents(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionEventsPublisher publisher = client.listTransactionEventsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionEventsPublisher publisher = client.listTransactionEventsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransactionEvents(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransactionEventsRequest.Builder} avoiding the
     * need to create one manually via {@link ListTransactionEventsRequest#builder()}
     * </p>
     *
     * @param listTransactionEventsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionEventsRequest.Builder}
     *        to create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactionEvents
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactionEvents"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionEventsPublisher listTransactionEventsPaginator(
            Consumer<ListTransactionEventsRequest.Builder> listTransactionEventsRequest) {
        return listTransactionEventsPaginator(ListTransactionEventsRequest.builder().applyMutation(listTransactionEventsRequest)
                .build());
    }

    /**
     * <p>
     * Lists all of the transactions on a given wallet address or to a specific contract.
     * </p>
     *
     * @param listTransactionsRequest
     * @return A Java Future containing the result of the ListTransactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTransactionsResponse> listTransactions(ListTransactionsRequest listTransactionsRequest) {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists all of the transactions on a given wallet address or to a specific contract.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransactionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransactionsRequest#builder()}
     * </p>
     *
     * @param listTransactionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest.Builder} to
     *        create a request.
     * @return A Java Future containing the result of the ListTransactions operation returned by the service.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default CompletableFuture<ListTransactionsResponse> listTransactions(
            Consumer<ListTransactionsRequest.Builder> listTransactionsRequest) {
        return listTransactions(ListTransactionsRequest.builder().applyMutation(listTransactionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransactions(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionsPublisher publisher = client.listTransactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionsPublisher publisher = client.listTransactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransactions(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTransactionsRequest
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionsPublisher listTransactionsPaginator(ListTransactionsRequest listTransactionsRequest) {
        return new ListTransactionsPublisher(this, listTransactionsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTransactions(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest)}
     * operation. The return type is a custom publisher that can be subscribed to request a stream of response pages.
     * SDK will internally handle making service calls for you.
     * </p>
     * <p>
     * When the operation is called, an instance of this class is returned. At this point, no service calls are made yet
     * and so there is no guarantee that the request is valid. If there are errors in your request, you will see the
     * failures only after you start streaming the data. The subscribe method should be called as a request to start
     * streaming data. For more info, see
     * {@link org.reactivestreams.Publisher#subscribe(org.reactivestreams.Subscriber)}. Each call to the subscribe
     * method will result in a new {@link org.reactivestreams.Subscription} i.e., a new contract to stream data from the
     * starting request.
     * </p>
     *
     * <p>
     * The following are few ways to use the response class:
     * </p>
     * 1) Using the subscribe helper method
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionsPublisher publisher = client.listTransactionsPaginator(request);
     * CompletableFuture<Void> future = publisher.subscribe(res -> { // Do something with the response });
     * future.get();
     * }
     * </pre>
     *
     * 2) Using a custom subscriber
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.managedblockchainquery.paginators.ListTransactionsPublisher publisher = client.listTransactionsPaginator(request);
     * publisher.subscribe(new Subscriber<software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse>() {
     * 
     * public void onSubscribe(org.reactivestreams.Subscriber subscription) { //... };
     * 
     * 
     * public void onNext(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse response) { //... };
     * });}
     * </pre>
     * 
     * As the response is a publisher, it can work well with third party reactive streams implementations like RxJava2.
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTransactions(software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTransactionsRequest.Builder} avoiding the need
     * to create one manually via {@link ListTransactionsRequest#builder()}
     * </p>
     *
     * @param listTransactionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest.Builder} to
     *        create a request.
     * @return A custom publisher that can be subscribed to request a stream of response pages.<br/>
     *         The CompletableFuture returned by this method can be completed exceptionally with the following
     *         exceptions.
     *         <ul>
     *         <li>ThrottlingException The request or operation couldn't be performed because a service is throttling
     *         requests. The most common source of throttling errors is when you create resources that exceed your
     *         service limit for this resource type. Request a limit increase or delete unused resources, if possible.</li>
     *         <li>ValidationException The resource passed is invalid.</li>
     *         <li>AccessDeniedException The Amazon Web Services account doesn’t have access to this resource.</li>
     *         <li>InternalServerException The request processing has failed because of an internal error in the
     *         service.</li>
     *         <li>ServiceQuotaExceededException The service quota has been exceeded for this resource.</li>
     *         <li>SdkException Base class for all exceptions that can be thrown by the SDK (both service and client).
     *         Can be used for catch all scenarios.</li>
     *         <li>SdkClientException If any client side error occurs such as an IO related failure, failure to get
     *         credentials, etc.</li>
     *         <li>ManagedBlockchainQueryException Base class for all service exceptions. Unknown exceptions will be
     *         thrown as an instance of this type.</li>
     *         </ul>
     * @sample ManagedBlockchainQueryAsyncClient.ListTransactions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/managedblockchain-query-2023-05-04/ListTransactions"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTransactionsPublisher listTransactionsPaginator(Consumer<ListTransactionsRequest.Builder> listTransactionsRequest) {
        return listTransactionsPaginator(ListTransactionsRequest.builder().applyMutation(listTransactionsRequest).build());
    }

    @Override
    default ManagedBlockchainQueryServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link ManagedBlockchainQueryAsyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static ManagedBlockchainQueryAsyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link ManagedBlockchainQueryAsyncClient}.
     */
    static ManagedBlockchainQueryAsyncClientBuilder builder() {
        return new DefaultManagedBlockchainQueryAsyncClientBuilder();
    }
}
