/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ConfirmationStatus;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TransactionOutputItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TransactionOutputItem> {
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionHash").getter(TransactionOutputItem.getter(TransactionOutputItem::transactionHash)).setter(TransactionOutputItem.setter(Builder::transactionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()}).build();
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(TransactionOutputItem.getter(TransactionOutputItem::networkAsString)).setter(TransactionOutputItem.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<Instant> TRANSACTION_TIMESTAMP_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("transactionTimestamp").getter(TransactionOutputItem.getter(TransactionOutputItem::transactionTimestamp)).setter(TransactionOutputItem.setter(Builder::transactionTimestamp)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionTimestamp").build()}).build();
    private static final SdkField<String> CONFIRMATION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("confirmationStatus").getter(TransactionOutputItem.getter(TransactionOutputItem::confirmationStatusAsString)).setter(TransactionOutputItem.setter(Builder::confirmationStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatus").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_HASH_FIELD, NETWORK_FIELD, TRANSACTION_TIMESTAMP_FIELD, CONFIRMATION_STATUS_FIELD));
    private static final long serialVersionUID = 1L;
    private final String transactionHash;
    private final String network;
    private final Instant transactionTimestamp;
    private final String confirmationStatus;

    private TransactionOutputItem(BuilderImpl builder) {
        this.transactionHash = builder.transactionHash;
        this.network = builder.network;
        this.transactionTimestamp = builder.transactionTimestamp;
        this.confirmationStatus = builder.confirmationStatus;
    }

    public final String transactionHash() {
        return this.transactionHash;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final Instant transactionTimestamp() {
        return this.transactionTimestamp;
    }

    public final ConfirmationStatus confirmationStatus() {
        return ConfirmationStatus.fromValue(this.confirmationStatus);
    }

    public final String confirmationStatusAsString() {
        return this.confirmationStatus;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionTimestamp());
        hashCode = 31 * hashCode + Objects.hashCode(this.confirmationStatusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionOutputItem)) {
            return false;
        }
        TransactionOutputItem other = (TransactionOutputItem)obj;
        return Objects.equals(this.transactionHash(), other.transactionHash()) && Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.transactionTimestamp(), other.transactionTimestamp()) && Objects.equals(this.confirmationStatusAsString(), other.confirmationStatusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"TransactionOutputItem").add("TransactionHash", (Object)this.transactionHash()).add("Network", (Object)this.networkAsString()).add("TransactionTimestamp", (Object)this.transactionTimestamp()).add("ConfirmationStatus", (Object)this.confirmationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transactionHash": {
                return Optional.ofNullable(clazz.cast(this.transactionHash()));
            }
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "transactionTimestamp": {
                return Optional.ofNullable(clazz.cast(this.transactionTimestamp()));
            }
            case "confirmationStatus": {
                return Optional.ofNullable(clazz.cast(this.confirmationStatusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<TransactionOutputItem, T> g) {
        return obj -> g.apply((TransactionOutputItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String transactionHash;
        private String network;
        private Instant transactionTimestamp;
        private String confirmationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionOutputItem model) {
            this.transactionHash(model.transactionHash);
            this.network(model.network);
            this.transactionTimestamp(model.transactionTimestamp);
            this.confirmationStatus(model.confirmationStatus);
        }

        public final String getTransactionHash() {
            return this.transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final Instant getTransactionTimestamp() {
            return this.transactionTimestamp;
        }

        public final void setTransactionTimestamp(Instant transactionTimestamp) {
            this.transactionTimestamp = transactionTimestamp;
        }

        @Override
        public final Builder transactionTimestamp(Instant transactionTimestamp) {
            this.transactionTimestamp = transactionTimestamp;
            return this;
        }

        public final String getConfirmationStatus() {
            return this.confirmationStatus;
        }

        public final void setConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
        }

        @Override
        public final Builder confirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @Override
        public final Builder confirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus(confirmationStatus == null ? null : confirmationStatus.toString());
            return this;
        }

        public TransactionOutputItem build() {
            return new TransactionOutputItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TransactionOutputItem> {
        public Builder transactionHash(String var1);

        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder transactionTimestamp(Instant var1);

        public Builder confirmationStatus(String var1);

        public Builder confirmationStatus(ConfirmationStatus var1);
    }
}

