/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTokenBalancesRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<ListTokenBalancesRequest.Builder, ListTokenBalancesRequest> {
    private static final SdkField<OwnerFilter> OWNER_FILTER_FIELD = SdkField.<OwnerFilter> builder(MarshallingType.SDK_POJO)
            .memberName("ownerFilter").getter(getter(ListTokenBalancesRequest::ownerFilter)).setter(setter(Builder::ownerFilter))
            .constructor(OwnerFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerFilter").build()).build();

    private static final SdkField<TokenFilter> TOKEN_FILTER_FIELD = SdkField.<TokenFilter> builder(MarshallingType.SDK_POJO)
            .memberName("tokenFilter").getter(getter(ListTokenBalancesRequest::tokenFilter)).setter(setter(Builder::tokenFilter))
            .constructor(TokenFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenFilter").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTokenBalancesRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTokenBalancesRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_FILTER_FIELD,
            TOKEN_FILTER_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final OwnerFilter ownerFilter;

    private final TokenFilter tokenFilter;

    private final String nextToken;

    private final Integer maxResults;

    private ListTokenBalancesRequest(BuilderImpl builder) {
        super(builder);
        this.ownerFilter = builder.ownerFilter;
        this.tokenFilter = builder.tokenFilter;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The contract or wallet address on the blockchain network by which to filter the request. You must specify the
     * <code>address</code> property of the <code>ownerFilter</code> when listing balances of tokens owned by the
     * address.
     * </p>
     * 
     * @return The contract or wallet address on the blockchain network by which to filter the request. You must specify
     *         the <code>address</code> property of the <code>ownerFilter</code> when listing balances of tokens owned
     *         by the address.
     */
    public final OwnerFilter ownerFilter() {
        return ownerFilter;
    }

    /**
     * <p>
     * The contract address or a token identifier on the blockchain network by which to filter the request. You must
     * specify the <code>contractAddress</code> property of this container when listing tokens minted by a contract.
     * </p>
     * <note>
     * <p>
     * You must always specify the network property of this container when using this operation.
     * </p>
     * </note>
     * 
     * @return The contract address or a token identifier on the blockchain network by which to filter the request. You
     *         must specify the <code>contractAddress</code> property of this container when listing tokens minted by a
     *         contract.</p> <note>
     *         <p>
     *         You must always specify the network property of this container when using this operation.
     *         </p>
     */
    public final TokenFilter tokenFilter() {
        return tokenFilter;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of token balances to return.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <note>
     * <p>
     * Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or
     * an empty array of results.
     * </p>
     * <p>
     * To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The
     * value of <code>nextToken</code> is <code>null</code> when there are no more results to return
     * </p>
     * </note>
     * 
     * @return The maximum number of token balances to return.</p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <note>
     *         <p>
     *         Even if additional results can be retrieved, the request can return less results than
     *         <code>maxResults</code> or an empty array of results.
     *         </p>
     *         <p>
     *         To retrieve the next set of results, make another request with the returned <code>nextToken</code> value.
     *         The value of <code>nextToken</code> is <code>null</code> when there are no more results to return
     *         </p>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(ownerFilter());
        hashCode = 31 * hashCode + Objects.hashCode(tokenFilter());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTokenBalancesRequest)) {
            return false;
        }
        ListTokenBalancesRequest other = (ListTokenBalancesRequest) obj;
        return Objects.equals(ownerFilter(), other.ownerFilter()) && Objects.equals(tokenFilter(), other.tokenFilter())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTokenBalancesRequest").add("OwnerFilter", ownerFilter()).add("TokenFilter", tokenFilter())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ownerFilter":
            return Optional.ofNullable(clazz.cast(ownerFilter()));
        case "tokenFilter":
            return Optional.ofNullable(clazz.cast(tokenFilter()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTokenBalancesRequest, T> g) {
        return obj -> g.apply((ListTokenBalancesRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTokenBalancesRequest> {
        /**
         * <p>
         * The contract or wallet address on the blockchain network by which to filter the request. You must specify the
         * <code>address</code> property of the <code>ownerFilter</code> when listing balances of tokens owned by the
         * address.
         * </p>
         * 
         * @param ownerFilter
         *        The contract or wallet address on the blockchain network by which to filter the request. You must
         *        specify the <code>address</code> property of the <code>ownerFilter</code> when listing balances of
         *        tokens owned by the address.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerFilter(OwnerFilter ownerFilter);

        /**
         * <p>
         * The contract or wallet address on the blockchain network by which to filter the request. You must specify the
         * <code>address</code> property of the <code>ownerFilter</code> when listing balances of tokens owned by the
         * address.
         * </p>
         * This is a convenience method that creates an instance of the {@link OwnerFilter.Builder} avoiding the need to
         * create one manually via {@link OwnerFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnerFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #ownerFilter(OwnerFilter)}.
         * 
         * @param ownerFilter
         *        a consumer that will call methods on {@link OwnerFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerFilter(OwnerFilter)
         */
        default Builder ownerFilter(Consumer<OwnerFilter.Builder> ownerFilter) {
            return ownerFilter(OwnerFilter.builder().applyMutation(ownerFilter).build());
        }

        /**
         * <p>
         * The contract address or a token identifier on the blockchain network by which to filter the request. You must
         * specify the <code>contractAddress</code> property of this container when listing tokens minted by a contract.
         * </p>
         * <note>
         * <p>
         * You must always specify the network property of this container when using this operation.
         * </p>
         * </note>
         * 
         * @param tokenFilter
         *        The contract address or a token identifier on the blockchain network by which to filter the request.
         *        You must specify the <code>contractAddress</code> property of this container when listing tokens
         *        minted by a contract.</p> <note>
         *        <p>
         *        You must always specify the network property of this container when using this operation.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenFilter(TokenFilter tokenFilter);

        /**
         * <p>
         * The contract address or a token identifier on the blockchain network by which to filter the request. You must
         * specify the <code>contractAddress</code> property of this container when listing tokens minted by a contract.
         * </p>
         * <note>
         * <p>
         * You must always specify the network property of this container when using this operation.
         * </p>
         * </note> This is a convenience method that creates an instance of the {@link TokenFilter.Builder} avoiding the
         * need to create one manually via {@link TokenFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #tokenFilter(TokenFilter)}.
         * 
         * @param tokenFilter
         *        a consumer that will call methods on {@link TokenFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenFilter(TokenFilter)
         */
        default Builder tokenFilter(Consumer<TokenFilter.Builder> tokenFilter) {
            return tokenFilter(TokenFilter.builder().applyMutation(tokenFilter).build());
        }

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of token balances to return.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <note>
         * <p>
         * Even if additional results can be retrieved, the request can return less results than <code>maxResults</code>
         * or an empty array of results.
         * </p>
         * <p>
         * To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The
         * value of <code>nextToken</code> is <code>null</code> when there are no more results to return
         * </p>
         * </note>
         * 
         * @param maxResults
         *        The maximum number of token balances to return.</p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <note>
         *        <p>
         *        Even if additional results can be retrieved, the request can return less results than
         *        <code>maxResults</code> or an empty array of results.
         *        </p>
         *        <p>
         *        To retrieve the next set of results, make another request with the returned <code>nextToken</code>
         *        value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to
         *        return
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private OwnerFilter ownerFilter;

        private TokenFilter tokenFilter;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTokenBalancesRequest model) {
            super(model);
            ownerFilter(model.ownerFilter);
            tokenFilter(model.tokenFilter);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final OwnerFilter.Builder getOwnerFilter() {
            return ownerFilter != null ? ownerFilter.toBuilder() : null;
        }

        public final void setOwnerFilter(OwnerFilter.BuilderImpl ownerFilter) {
            this.ownerFilter = ownerFilter != null ? ownerFilter.build() : null;
        }

        @Override
        public final Builder ownerFilter(OwnerFilter ownerFilter) {
            this.ownerFilter = ownerFilter;
            return this;
        }

        public final TokenFilter.Builder getTokenFilter() {
            return tokenFilter != null ? tokenFilter.toBuilder() : null;
        }

        public final void setTokenFilter(TokenFilter.BuilderImpl tokenFilter) {
            this.tokenFilter = tokenFilter != null ? tokenFilter.build() : null;
        }

        @Override
        public final Builder tokenFilter(TokenFilter tokenFilter) {
            this.tokenFilter = tokenFilter;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTokenBalancesRequest build() {
            return new ListTokenBalancesRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
