/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFilteredTransactionEventsRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<ListFilteredTransactionEventsRequest.Builder, ListFilteredTransactionEventsRequest> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(ListFilteredTransactionEventsRequest::network)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<AddressIdentifierFilter> ADDRESS_IDENTIFIER_FILTER_FIELD = SdkField
            .<AddressIdentifierFilter> builder(MarshallingType.SDK_POJO).memberName("addressIdentifierFilter")
            .getter(getter(ListFilteredTransactionEventsRequest::addressIdentifierFilter))
            .setter(setter(Builder::addressIdentifierFilter)).constructor(AddressIdentifierFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("addressIdentifierFilter").build())
            .build();

    private static final SdkField<TimeFilter> TIME_FILTER_FIELD = SdkField.<TimeFilter> builder(MarshallingType.SDK_POJO)
            .memberName("timeFilter").getter(getter(ListFilteredTransactionEventsRequest::timeFilter))
            .setter(setter(Builder::timeFilter)).constructor(TimeFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeFilter").build()).build();

    private static final SdkField<VoutFilter> VOUT_FILTER_FIELD = SdkField.<VoutFilter> builder(MarshallingType.SDK_POJO)
            .memberName("voutFilter").getter(getter(ListFilteredTransactionEventsRequest::voutFilter))
            .setter(setter(Builder::voutFilter)).constructor(VoutFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutFilter").build()).build();

    private static final SdkField<ConfirmationStatusFilter> CONFIRMATION_STATUS_FILTER_FIELD = SdkField
            .<ConfirmationStatusFilter> builder(MarshallingType.SDK_POJO).memberName("confirmationStatusFilter")
            .getter(getter(ListFilteredTransactionEventsRequest::confirmationStatusFilter))
            .setter(setter(Builder::confirmationStatusFilter)).constructor(ConfirmationStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatusFilter").build())
            .build();

    private static final SdkField<ListFilteredTransactionEventsSort> SORT_FIELD = SdkField
            .<ListFilteredTransactionEventsSort> builder(MarshallingType.SDK_POJO).memberName("sort")
            .getter(getter(ListFilteredTransactionEventsRequest::sort)).setter(setter(Builder::sort))
            .constructor(ListFilteredTransactionEventsSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFilteredTransactionEventsRequest::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListFilteredTransactionEventsRequest::maxResults))
            .setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD,
            ADDRESS_IDENTIFIER_FILTER_FIELD, TIME_FILTER_FIELD, VOUT_FILTER_FIELD, CONFIRMATION_STATUS_FILTER_FIELD, SORT_FIELD,
            NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));

    private final String network;

    private final AddressIdentifierFilter addressIdentifierFilter;

    private final TimeFilter timeFilter;

    private final VoutFilter voutFilter;

    private final ConfirmationStatusFilter confirmationStatusFilter;

    private final ListFilteredTransactionEventsSort sort;

    private final String nextToken;

    private final Integer maxResults;

    private ListFilteredTransactionEventsRequest(BuilderImpl builder) {
        super(builder);
        this.network = builder.network;
        this.addressIdentifierFilter = builder.addressIdentifierFilter;
        this.timeFilter = builder.timeFilter;
        this.voutFilter = builder.voutFilter;
        this.confirmationStatusFilter = builder.confirmationStatusFilter;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * Valid Values: <code>BITCOIN_MAINNET</code> | <code>BITCOIN_TESTNET</code>
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.</p>
     *         <p>
     *         Valid Values: <code>BITCOIN_MAINNET</code> | <code>BITCOIN_TESTNET</code>
     */
    public final String network() {
        return network;
    }

    /**
     * <p>
     * This is the unique public address on the blockchain for which the transaction events are being requested.
     * </p>
     * 
     * @return This is the unique public address on the blockchain for which the transaction events are being requested.
     */
    public final AddressIdentifierFilter addressIdentifierFilter() {
        return addressIdentifierFilter;
    }

    /**
     * <p>
     * This container specifies the time frame for the transaction events returned in the response.
     * </p>
     * 
     * @return This container specifies the time frame for the transaction events returned in the response.
     */
    public final TimeFilter timeFilter() {
        return timeFilter;
    }

    /**
     * <p>
     * This container specifies filtering attributes related to BITCOIN_VOUT event types
     * </p>
     * 
     * @return This container specifies filtering attributes related to BITCOIN_VOUT event types
     */
    public final VoutFilter voutFilter() {
        return voutFilter;
    }

    /**
     * Returns the value of the ConfirmationStatusFilter property for this object.
     * 
     * @return The value of the ConfirmationStatusFilter property for this object.
     */
    public final ConfirmationStatusFilter confirmationStatusFilter() {
        return confirmationStatusFilter;
    }

    /**
     * <p>
     * The order by which the results will be sorted.
     * </p>
     * 
     * @return The order by which the results will be sorted.
     */
    public final ListFilteredTransactionEventsSort sort() {
        return sort;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of transaction events to list.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <note>
     * <p>
     * Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or
     * an empty array of results.
     * </p>
     * <p>
     * To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The
     * value of <code>nextToken</code> is <code>null</code> when there are no more results to return
     * </p>
     * </note>
     * 
     * @return The maximum number of transaction events to list.</p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <note>
     *         <p>
     *         Even if additional results can be retrieved, the request can return less results than
     *         <code>maxResults</code> or an empty array of results.
     *         </p>
     *         <p>
     *         To retrieve the next set of results, make another request with the returned <code>nextToken</code> value.
     *         The value of <code>nextToken</code> is <code>null</code> when there are no more results to return
     *         </p>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(network());
        hashCode = 31 * hashCode + Objects.hashCode(addressIdentifierFilter());
        hashCode = 31 * hashCode + Objects.hashCode(timeFilter());
        hashCode = 31 * hashCode + Objects.hashCode(voutFilter());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationStatusFilter());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFilteredTransactionEventsRequest)) {
            return false;
        }
        ListFilteredTransactionEventsRequest other = (ListFilteredTransactionEventsRequest) obj;
        return Objects.equals(network(), other.network())
                && Objects.equals(addressIdentifierFilter(), other.addressIdentifierFilter())
                && Objects.equals(timeFilter(), other.timeFilter()) && Objects.equals(voutFilter(), other.voutFilter())
                && Objects.equals(confirmationStatusFilter(), other.confirmationStatusFilter())
                && Objects.equals(sort(), other.sort()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(maxResults(), other.maxResults());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFilteredTransactionEventsRequest").add("Network", network())
                .add("AddressIdentifierFilter", addressIdentifierFilter()).add("TimeFilter", timeFilter())
                .add("VoutFilter", voutFilter()).add("ConfirmationStatusFilter", confirmationStatusFilter()).add("Sort", sort())
                .add("NextToken", nextToken()).add("MaxResults", maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "network":
            return Optional.ofNullable(clazz.cast(network()));
        case "addressIdentifierFilter":
            return Optional.ofNullable(clazz.cast(addressIdentifierFilter()));
        case "timeFilter":
            return Optional.ofNullable(clazz.cast(timeFilter()));
        case "voutFilter":
            return Optional.ofNullable(clazz.cast(voutFilter()));
        case "confirmationStatusFilter":
            return Optional.ofNullable(clazz.cast(confirmationStatusFilter()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListFilteredTransactionEventsRequest, T> g) {
        return obj -> g.apply((ListFilteredTransactionEventsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListFilteredTransactionEventsRequest> {
        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * <p>
         * Valid Values: <code>BITCOIN_MAINNET</code> | <code>BITCOIN_TESTNET</code>
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.</p>
         *        <p>
         *        Valid Values: <code>BITCOIN_MAINNET</code> | <code>BITCOIN_TESTNET</code>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder network(String network);

        /**
         * <p>
         * This is the unique public address on the blockchain for which the transaction events are being requested.
         * </p>
         * 
         * @param addressIdentifierFilter
         *        This is the unique public address on the blockchain for which the transaction events are being
         *        requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder addressIdentifierFilter(AddressIdentifierFilter addressIdentifierFilter);

        /**
         * <p>
         * This is the unique public address on the blockchain for which the transaction events are being requested.
         * </p>
         * This is a convenience method that creates an instance of the {@link AddressIdentifierFilter.Builder} avoiding
         * the need to create one manually via {@link AddressIdentifierFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AddressIdentifierFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #addressIdentifierFilter(AddressIdentifierFilter)}.
         * 
         * @param addressIdentifierFilter
         *        a consumer that will call methods on {@link AddressIdentifierFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #addressIdentifierFilter(AddressIdentifierFilter)
         */
        default Builder addressIdentifierFilter(Consumer<AddressIdentifierFilter.Builder> addressIdentifierFilter) {
            return addressIdentifierFilter(AddressIdentifierFilter.builder().applyMutation(addressIdentifierFilter).build());
        }

        /**
         * <p>
         * This container specifies the time frame for the transaction events returned in the response.
         * </p>
         * 
         * @param timeFilter
         *        This container specifies the time frame for the transaction events returned in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timeFilter(TimeFilter timeFilter);

        /**
         * <p>
         * This container specifies the time frame for the transaction events returned in the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link TimeFilter.Builder} avoiding the need to
         * create one manually via {@link TimeFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TimeFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #timeFilter(TimeFilter)}.
         * 
         * @param timeFilter
         *        a consumer that will call methods on {@link TimeFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #timeFilter(TimeFilter)
         */
        default Builder timeFilter(Consumer<TimeFilter.Builder> timeFilter) {
            return timeFilter(TimeFilter.builder().applyMutation(timeFilter).build());
        }

        /**
         * <p>
         * This container specifies filtering attributes related to BITCOIN_VOUT event types
         * </p>
         * 
         * @param voutFilter
         *        This container specifies filtering attributes related to BITCOIN_VOUT event types
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voutFilter(VoutFilter voutFilter);

        /**
         * <p>
         * This container specifies filtering attributes related to BITCOIN_VOUT event types
         * </p>
         * This is a convenience method that creates an instance of the {@link VoutFilter.Builder} avoiding the need to
         * create one manually via {@link VoutFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VoutFilter.Builder#build()} is called immediately and its result
         * is passed to {@link #voutFilter(VoutFilter)}.
         * 
         * @param voutFilter
         *        a consumer that will call methods on {@link VoutFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #voutFilter(VoutFilter)
         */
        default Builder voutFilter(Consumer<VoutFilter.Builder> voutFilter) {
            return voutFilter(VoutFilter.builder().applyMutation(voutFilter).build());
        }

        /**
         * Sets the value of the ConfirmationStatusFilter property for this object.
         *
         * @param confirmationStatusFilter
         *        The new value for the ConfirmationStatusFilter property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationStatusFilter(ConfirmationStatusFilter confirmationStatusFilter);

        /**
         * Sets the value of the ConfirmationStatusFilter property for this object.
         *
         * This is a convenience method that creates an instance of the {@link ConfirmationStatusFilter.Builder}
         * avoiding the need to create one manually via {@link ConfirmationStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfirmationStatusFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #confirmationStatusFilter(ConfirmationStatusFilter)}.
         * 
         * @param confirmationStatusFilter
         *        a consumer that will call methods on {@link ConfirmationStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationStatusFilter(ConfirmationStatusFilter)
         */
        default Builder confirmationStatusFilter(Consumer<ConfirmationStatusFilter.Builder> confirmationStatusFilter) {
            return confirmationStatusFilter(ConfirmationStatusFilter.builder().applyMutation(confirmationStatusFilter).build());
        }

        /**
         * <p>
         * The order by which the results will be sorted.
         * </p>
         * 
         * @param sort
         *        The order by which the results will be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(ListFilteredTransactionEventsSort sort);

        /**
         * <p>
         * The order by which the results will be sorted.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ListFilteredTransactionEventsSort.Builder} avoiding the need to create one manually via
         * {@link ListFilteredTransactionEventsSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListFilteredTransactionEventsSort.Builder#build()} is called
         * immediately and its result is passed to {@link #sort(ListFilteredTransactionEventsSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link ListFilteredTransactionEventsSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(ListFilteredTransactionEventsSort)
         */
        default Builder sort(Consumer<ListFilteredTransactionEventsSort.Builder> sort) {
            return sort(ListFilteredTransactionEventsSort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of transaction events to list.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <note>
         * <p>
         * Even if additional results can be retrieved, the request can return less results than <code>maxResults</code>
         * or an empty array of results.
         * </p>
         * <p>
         * To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The
         * value of <code>nextToken</code> is <code>null</code> when there are no more results to return
         * </p>
         * </note>
         * 
         * @param maxResults
         *        The maximum number of transaction events to list.</p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <note>
         *        <p>
         *        Even if additional results can be retrieved, the request can return less results than
         *        <code>maxResults</code> or an empty array of results.
         *        </p>
         *        <p>
         *        To retrieve the next set of results, make another request with the returned <code>nextToken</code>
         *        value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to
         *        return
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private String network;

        private AddressIdentifierFilter addressIdentifierFilter;

        private TimeFilter timeFilter;

        private VoutFilter voutFilter;

        private ConfirmationStatusFilter confirmationStatusFilter;

        private ListFilteredTransactionEventsSort sort;

        private String nextToken;

        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFilteredTransactionEventsRequest model) {
            super(model);
            network(model.network);
            addressIdentifierFilter(model.addressIdentifierFilter);
            timeFilter(model.timeFilter);
            voutFilter(model.voutFilter);
            confirmationStatusFilter(model.confirmationStatusFilter);
            sort(model.sort);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        public final AddressIdentifierFilter.Builder getAddressIdentifierFilter() {
            return addressIdentifierFilter != null ? addressIdentifierFilter.toBuilder() : null;
        }

        public final void setAddressIdentifierFilter(AddressIdentifierFilter.BuilderImpl addressIdentifierFilter) {
            this.addressIdentifierFilter = addressIdentifierFilter != null ? addressIdentifierFilter.build() : null;
        }

        @Override
        public final Builder addressIdentifierFilter(AddressIdentifierFilter addressIdentifierFilter) {
            this.addressIdentifierFilter = addressIdentifierFilter;
            return this;
        }

        public final TimeFilter.Builder getTimeFilter() {
            return timeFilter != null ? timeFilter.toBuilder() : null;
        }

        public final void setTimeFilter(TimeFilter.BuilderImpl timeFilter) {
            this.timeFilter = timeFilter != null ? timeFilter.build() : null;
        }

        @Override
        public final Builder timeFilter(TimeFilter timeFilter) {
            this.timeFilter = timeFilter;
            return this;
        }

        public final VoutFilter.Builder getVoutFilter() {
            return voutFilter != null ? voutFilter.toBuilder() : null;
        }

        public final void setVoutFilter(VoutFilter.BuilderImpl voutFilter) {
            this.voutFilter = voutFilter != null ? voutFilter.build() : null;
        }

        @Override
        public final Builder voutFilter(VoutFilter voutFilter) {
            this.voutFilter = voutFilter;
            return this;
        }

        public final ConfirmationStatusFilter.Builder getConfirmationStatusFilter() {
            return confirmationStatusFilter != null ? confirmationStatusFilter.toBuilder() : null;
        }

        public final void setConfirmationStatusFilter(ConfirmationStatusFilter.BuilderImpl confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter != null ? confirmationStatusFilter.build() : null;
        }

        @Override
        public final Builder confirmationStatusFilter(ConfirmationStatusFilter confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter;
            return this;
        }

        public final ListFilteredTransactionEventsSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(ListFilteredTransactionEventsSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListFilteredTransactionEventsSort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListFilteredTransactionEventsRequest build() {
            return new ListFilteredTransactionEventsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
