/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ManagedBlockchainQueryRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryNetwork;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListTransactionEventsRequest
extends ManagedBlockchainQueryRequest
implements ToCopyableBuilder<Builder, ListTransactionEventsRequest> {
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionHash").getter(ListTransactionEventsRequest.getter(ListTransactionEventsRequest::transactionHash)).setter(ListTransactionEventsRequest.setter(Builder::transactionHash)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()}).build();
    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("transactionId").getter(ListTransactionEventsRequest.getter(ListTransactionEventsRequest::transactionId)).setter(ListTransactionEventsRequest.setter(Builder::transactionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()}).build();
    private static final SdkField<String> NETWORK_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("network").getter(ListTransactionEventsRequest.getter(ListTransactionEventsRequest::networkAsString)).setter(ListTransactionEventsRequest.setter(Builder::network)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListTransactionEventsRequest.getter(ListTransactionEventsRequest::nextToken)).setter(ListTransactionEventsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListTransactionEventsRequest.getter(ListTransactionEventsRequest::maxResults)).setter(ListTransactionEventsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_HASH_FIELD, TRANSACTION_ID_FIELD, NETWORK_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("transactionHash", TRANSACTION_HASH_FIELD);
            this.put("transactionId", TRANSACTION_ID_FIELD);
            this.put("network", NETWORK_FIELD);
            this.put("nextToken", NEXT_TOKEN_FIELD);
            this.put("maxResults", MAX_RESULTS_FIELD);
        }
    });
    private final String transactionHash;
    private final String transactionId;
    private final String network;
    private final String nextToken;
    private final Integer maxResults;

    private ListTransactionEventsRequest(BuilderImpl builder) {
        super(builder);
        this.transactionHash = builder.transactionHash;
        this.transactionId = builder.transactionId;
        this.network = builder.network;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
    }

    public final String transactionHash() {
        return this.transactionHash;
    }

    public final String transactionId() {
        return this.transactionId;
    }

    public final QueryNetwork network() {
        return QueryNetwork.fromValue(this.network);
    }

    public final String networkAsString() {
        return this.network;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(this.transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionEventsRequest)) {
            return false;
        }
        ListTransactionEventsRequest other = (ListTransactionEventsRequest)((Object)obj);
        return Objects.equals(this.transactionHash(), other.transactionHash()) && Objects.equals(this.transactionId(), other.transactionId()) && Objects.equals(this.networkAsString(), other.networkAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.maxResults(), other.maxResults());
    }

    public final String toString() {
        return ToString.builder((String)"ListTransactionEventsRequest").add("TransactionHash", (Object)this.transactionHash()).add("TransactionId", (Object)this.transactionId()).add("Network", (Object)this.networkAsString()).add("NextToken", (Object)this.nextToken()).add("MaxResults", (Object)this.maxResults()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transactionHash": {
                return Optional.ofNullable(clazz.cast(this.transactionHash()));
            }
            case "transactionId": {
                return Optional.ofNullable(clazz.cast(this.transactionId()));
            }
            case "network": {
                return Optional.ofNullable(clazz.cast(this.networkAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionEventsRequest, T> g) {
        return obj -> g.apply((ListTransactionEventsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ManagedBlockchainQueryRequest.BuilderImpl
    implements Builder {
        private String transactionHash;
        private String transactionId;
        private String network;
        private String nextToken;
        private Integer maxResults;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionEventsRequest model) {
            super(model);
            this.transactionHash(model.transactionHash);
            this.transactionId(model.transactionId);
            this.network(model.network);
            this.nextToken(model.nextToken);
            this.maxResults(model.maxResults);
        }

        public final String getTransactionHash() {
            return this.transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getTransactionId() {
            return this.transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getNetwork() {
            return this.network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTransactionEventsRequest build() {
            return new ListTransactionEventsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends ManagedBlockchainQueryRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListTransactionEventsRequest> {
        public Builder transactionHash(String var1);

        public Builder transactionId(String var1);

        public Builder network(String var1);

        public Builder network(QueryNetwork var1);

        public Builder nextToken(String var1);

        public Builder maxResults(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

