/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.ContractIdentifier;
import software.amazon.awssdk.services.managedblockchainquery.model.QueryTokenStandard;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AssetContract
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AssetContract> {
    private static final SdkField<ContractIdentifier> CONTRACT_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("contractIdentifier").getter(AssetContract.getter(AssetContract::contractIdentifier)).setter(AssetContract.setter(Builder::contractIdentifier)).constructor(ContractIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractIdentifier").build()}).build();
    private static final SdkField<String> TOKEN_STANDARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("tokenStandard").getter(AssetContract.getter(AssetContract::tokenStandardAsString)).setter(AssetContract.setter(Builder::tokenStandard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenStandard").build()}).build();
    private static final SdkField<String> DEPLOYER_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("deployerAddress").getter(AssetContract.getter(AssetContract::deployerAddress)).setter(AssetContract.setter(Builder::deployerAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployerAddress").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACT_IDENTIFIER_FIELD, TOKEN_STANDARD_FIELD, DEPLOYER_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("contractIdentifier", CONTRACT_IDENTIFIER_FIELD);
            this.put("tokenStandard", TOKEN_STANDARD_FIELD);
            this.put("deployerAddress", DEPLOYER_ADDRESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ContractIdentifier contractIdentifier;
    private final String tokenStandard;
    private final String deployerAddress;

    private AssetContract(BuilderImpl builder) {
        this.contractIdentifier = builder.contractIdentifier;
        this.tokenStandard = builder.tokenStandard;
        this.deployerAddress = builder.deployerAddress;
    }

    public final ContractIdentifier contractIdentifier() {
        return this.contractIdentifier;
    }

    public final QueryTokenStandard tokenStandard() {
        return QueryTokenStandard.fromValue(this.tokenStandard);
    }

    public final String tokenStandardAsString() {
        return this.tokenStandard;
    }

    public final String deployerAddress() {
        return this.deployerAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.contractIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.deployerAddress());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssetContract)) {
            return false;
        }
        AssetContract other = (AssetContract)obj;
        return Objects.equals(this.contractIdentifier(), other.contractIdentifier()) && Objects.equals(this.tokenStandardAsString(), other.tokenStandardAsString()) && Objects.equals(this.deployerAddress(), other.deployerAddress());
    }

    public final String toString() {
        return ToString.builder((String)"AssetContract").add("ContractIdentifier", (Object)this.contractIdentifier()).add("TokenStandard", (Object)this.tokenStandardAsString()).add("DeployerAddress", (Object)this.deployerAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "contractIdentifier": {
                return Optional.ofNullable(clazz.cast(this.contractIdentifier()));
            }
            case "tokenStandard": {
                return Optional.ofNullable(clazz.cast(this.tokenStandardAsString()));
            }
            case "deployerAddress": {
                return Optional.ofNullable(clazz.cast(this.deployerAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AssetContract, T> g) {
        return obj -> g.apply((AssetContract)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ContractIdentifier contractIdentifier;
        private String tokenStandard;
        private String deployerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(AssetContract model) {
            this.contractIdentifier(model.contractIdentifier);
            this.tokenStandard(model.tokenStandard);
            this.deployerAddress(model.deployerAddress);
        }

        public final ContractIdentifier.Builder getContractIdentifier() {
            return this.contractIdentifier != null ? this.contractIdentifier.toBuilder() : null;
        }

        public final void setContractIdentifier(ContractIdentifier.BuilderImpl contractIdentifier) {
            this.contractIdentifier = contractIdentifier != null ? contractIdentifier.build() : null;
        }

        @Override
        public final Builder contractIdentifier(ContractIdentifier contractIdentifier) {
            this.contractIdentifier = contractIdentifier;
            return this;
        }

        public final String getTokenStandard() {
            return this.tokenStandard;
        }

        public final void setTokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
        }

        @Override
        public final Builder tokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
            return this;
        }

        @Override
        public final Builder tokenStandard(QueryTokenStandard tokenStandard) {
            this.tokenStandard(tokenStandard == null ? null : tokenStandard.toString());
            return this;
        }

        public final String getDeployerAddress() {
            return this.deployerAddress;
        }

        public final void setDeployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
        }

        @Override
        public final Builder deployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
            return this;
        }

        public AssetContract build() {
            return new AssetContract(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AssetContract> {
        public Builder contractIdentifier(ContractIdentifier var1);

        default public Builder contractIdentifier(Consumer<ContractIdentifier.Builder> contractIdentifier) {
            return this.contractIdentifier((ContractIdentifier)((ContractIdentifier.Builder)ContractIdentifier.builder().applyMutation(contractIdentifier)).build());
        }

        public Builder tokenStandard(String var1);

        public Builder tokenStandard(QueryTokenStandard var1);

        public Builder deployerAddress(String var1);
    }
}

