/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.managedblockchainquery.model.AddressIdentifierFilterTransactionEventToAddressListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AddressIdentifierFilter
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AddressIdentifierFilter> {
    private static final SdkField<List<String>> TRANSACTION_EVENT_TO_ADDRESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("transactionEventToAddress").getter(AddressIdentifierFilter.getter(AddressIdentifierFilter::transactionEventToAddress)).setter(AddressIdentifierFilter.setter(Builder::transactionEventToAddress)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionEventToAddress").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_EVENT_TO_ADDRESS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("transactionEventToAddress", TRANSACTION_EVENT_TO_ADDRESS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<String> transactionEventToAddress;

    private AddressIdentifierFilter(BuilderImpl builder) {
        this.transactionEventToAddress = builder.transactionEventToAddress;
    }

    public final boolean hasTransactionEventToAddress() {
        return this.transactionEventToAddress != null && !(this.transactionEventToAddress instanceof SdkAutoConstructList);
    }

    public final List<String> transactionEventToAddress() {
        return this.transactionEventToAddress;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTransactionEventToAddress() ? this.transactionEventToAddress() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressIdentifierFilter)) {
            return false;
        }
        AddressIdentifierFilter other = (AddressIdentifierFilter)obj;
        return this.hasTransactionEventToAddress() == other.hasTransactionEventToAddress() && Objects.equals(this.transactionEventToAddress(), other.transactionEventToAddress());
    }

    public final String toString() {
        return ToString.builder((String)"AddressIdentifierFilter").add("TransactionEventToAddress", this.hasTransactionEventToAddress() ? this.transactionEventToAddress() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "transactionEventToAddress": {
                return Optional.ofNullable(clazz.cast(this.transactionEventToAddress()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AddressIdentifierFilter, T> g) {
        return obj -> g.apply((AddressIdentifierFilter)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> transactionEventToAddress = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddressIdentifierFilter model) {
            this.transactionEventToAddress(model.transactionEventToAddress);
        }

        public final Collection<String> getTransactionEventToAddress() {
            if (this.transactionEventToAddress instanceof SdkAutoConstructList) {
                return null;
            }
            return this.transactionEventToAddress;
        }

        public final void setTransactionEventToAddress(Collection<String> transactionEventToAddress) {
            this.transactionEventToAddress = AddressIdentifierFilterTransactionEventToAddressListCopier.copy(transactionEventToAddress);
        }

        @Override
        public final Builder transactionEventToAddress(Collection<String> transactionEventToAddress) {
            this.transactionEventToAddress = AddressIdentifierFilterTransactionEventToAddressListCopier.copy(transactionEventToAddress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactionEventToAddress(String ... transactionEventToAddress) {
            this.transactionEventToAddress(Arrays.asList(transactionEventToAddress));
            return this;
        }

        public AddressIdentifierFilter build() {
            return new AddressIdentifierFilter(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AddressIdentifierFilter> {
        public Builder transactionEventToAddress(Collection<String> var1);

        public Builder transactionEventToAddress(String ... var1);
    }
}

