/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This is the container for the unique public address on the blockchain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AddressIdentifierFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<AddressIdentifierFilter.Builder, AddressIdentifierFilter> {
    private static final SdkField<List<String>> TRANSACTION_EVENT_TO_ADDRESS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("transactionEventToAddress")
            .getter(getter(AddressIdentifierFilter::transactionEventToAddress))
            .setter(setter(Builder::transactionEventToAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionEventToAddress").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(TRANSACTION_EVENT_TO_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> transactionEventToAddress;

    private AddressIdentifierFilter(BuilderImpl builder) {
        this.transactionEventToAddress = builder.transactionEventToAddress;
    }

    /**
     * For responses, this returns true if the service returned a value for the TransactionEventToAddress property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasTransactionEventToAddress() {
        return transactionEventToAddress != null && !(transactionEventToAddress instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container for the recipient address of the transaction.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTransactionEventToAddress} method.
     * </p>
     * 
     * @return The container for the recipient address of the transaction.
     */
    public final List<String> transactionEventToAddress() {
        return transactionEventToAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasTransactionEventToAddress() ? transactionEventToAddress() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AddressIdentifierFilter)) {
            return false;
        }
        AddressIdentifierFilter other = (AddressIdentifierFilter) obj;
        return hasTransactionEventToAddress() == other.hasTransactionEventToAddress()
                && Objects.equals(transactionEventToAddress(), other.transactionEventToAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AddressIdentifierFilter")
                .add("TransactionEventToAddress", hasTransactionEventToAddress() ? transactionEventToAddress() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactionEventToAddress":
            return Optional.ofNullable(clazz.cast(transactionEventToAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transactionEventToAddress", TRANSACTION_EVENT_TO_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AddressIdentifierFilter, T> g) {
        return obj -> g.apply((AddressIdentifierFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AddressIdentifierFilter> {
        /**
         * <p>
         * The container for the recipient address of the transaction.
         * </p>
         * 
         * @param transactionEventToAddress
         *        The container for the recipient address of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionEventToAddress(Collection<String> transactionEventToAddress);

        /**
         * <p>
         * The container for the recipient address of the transaction.
         * </p>
         * 
         * @param transactionEventToAddress
         *        The container for the recipient address of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionEventToAddress(String... transactionEventToAddress);
    }

    static final class BuilderImpl implements Builder {
        private List<String> transactionEventToAddress = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(AddressIdentifierFilter model) {
            transactionEventToAddress(model.transactionEventToAddress);
        }

        public final Collection<String> getTransactionEventToAddress() {
            if (transactionEventToAddress instanceof SdkAutoConstructList) {
                return null;
            }
            return transactionEventToAddress;
        }

        public final void setTransactionEventToAddress(Collection<String> transactionEventToAddress) {
            this.transactionEventToAddress = AddressIdentifierFilterTransactionEventToAddressListCopier
                    .copy(transactionEventToAddress);
        }

        @Override
        public final Builder transactionEventToAddress(Collection<String> transactionEventToAddress) {
            this.transactionEventToAddress = AddressIdentifierFilterTransactionEventToAddressListCopier
                    .copy(transactionEventToAddress);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder transactionEventToAddress(String... transactionEventToAddress) {
            transactionEventToAddress(Arrays.asList(transactionEventToAddress));
            return this;
        }

        @Override
        public AddressIdentifierFilter build() {
            return new AddressIdentifierFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
