/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BlockchainInstant implements SdkPojo, Serializable,
        ToCopyableBuilder<BlockchainInstant.Builder, BlockchainInstant> {
    private static final SdkField<Instant> TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT).memberName("time")
            .getter(getter(BlockchainInstant::time)).setter(setter(Builder::time))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("time").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant time;

    private BlockchainInstant(BuilderImpl builder) {
        this.time = builder.time;
    }

    /**
     * <p>
     * The container of the <code>Timestamp</code> of the blockchain instant.
     * </p>
     * <note>
     * <p>
     * This <code>timestamp</code> will only be recorded up to the second.
     * </p>
     * </note>
     * 
     * @return The container of the <code>Timestamp</code> of the blockchain instant.</p> <note>
     *         <p>
     *         This <code>timestamp</code> will only be recorded up to the second.
     *         </p>
     */
    public final Instant time() {
        return time;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(time());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BlockchainInstant)) {
            return false;
        }
        BlockchainInstant other = (BlockchainInstant) obj;
        return Objects.equals(time(), other.time());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BlockchainInstant").add("Time", time()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "time":
            return Optional.ofNullable(clazz.cast(time()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("time", TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BlockchainInstant, T> g) {
        return obj -> g.apply((BlockchainInstant) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BlockchainInstant> {
        /**
         * <p>
         * The container of the <code>Timestamp</code> of the blockchain instant.
         * </p>
         * <note>
         * <p>
         * This <code>timestamp</code> will only be recorded up to the second.
         * </p>
         * </note>
         * 
         * @param time
         *        The container of the <code>Timestamp</code> of the blockchain instant.</p> <note>
         *        <p>
         *        This <code>timestamp</code> will only be recorded up to the second.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder time(Instant time);
    }

    static final class BuilderImpl implements Builder {
        private Instant time;

        private BuilderImpl() {
        }

        private BuilderImpl(BlockchainInstant model) {
            time(model.time);
        }

        public final Instant getTime() {
            return time;
        }

        public final void setTime(Instant time) {
            this.time = time;
        }

        @Override
        public final Builder time(Instant time) {
            this.time = time;
            return this;
        }

        @Override
        public BlockchainInstant build() {
            return new BlockchainInstant(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
