/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the <code>ConfirmationStatusFilter</code> that filters for the <a
 * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i> </a>
 * of the results.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConfirmationStatusFilter implements SdkPojo, Serializable,
        ToCopyableBuilder<ConfirmationStatusFilter.Builder, ConfirmationStatusFilter> {
    private static final SdkField<List<String>> INCLUDE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("include")
            .getter(getter(ConfirmationStatusFilter::includeAsStrings))
            .setter(setter(Builder::includeWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("include").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INCLUDE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> include;

    private ConfirmationStatusFilter(BuilderImpl builder) {
        this.include = builder.include;
    }

    /**
     * <p>
     * The container to determine whether to list results that have only reached <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i>
     * </a>. Transactions that have reached finality are always part of the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return The container to determine whether to list results that have only reached <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
     *         <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
     */
    public final List<ConfirmationStatus> include() {
        return ConfirmationStatusIncludeListCopier.copyStringToEnum(include);
    }

    /**
     * For responses, this returns true if the service returned a value for the Include property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasInclude() {
        return include != null && !(include instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The container to determine whether to list results that have only reached <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i>
     * </a>. Transactions that have reached finality are always part of the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasInclude} method.
     * </p>
     * 
     * @return The container to determine whether to list results that have only reached <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
     *         <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
     */
    public final List<String> includeAsStrings() {
        return include;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasInclude() ? includeAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfirmationStatusFilter)) {
            return false;
        }
        ConfirmationStatusFilter other = (ConfirmationStatusFilter) obj;
        return hasInclude() == other.hasInclude() && Objects.equals(includeAsStrings(), other.includeAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConfirmationStatusFilter").add("Include", hasInclude() ? includeAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "include":
            return Optional.ofNullable(clazz.cast(includeAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("include", INCLUDE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConfirmationStatusFilter, T> g) {
        return obj -> g.apply((ConfirmationStatusFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConfirmationStatusFilter> {
        /**
         * <p>
         * The container to determine whether to list results that have only reached <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         * <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * </p>
         * 
         * @param include
         *        The container to determine whether to list results that have only reached <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         *        <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(Collection<String> include);

        /**
         * <p>
         * The container to determine whether to list results that have only reached <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         * <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * </p>
         * 
         * @param include
         *        The container to determine whether to list results that have only reached <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         *        <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder includeWithStrings(String... include);

        /**
         * <p>
         * The container to determine whether to list results that have only reached <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         * <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * </p>
         * 
         * @param include
         *        The container to determine whether to list results that have only reached <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         *        <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(Collection<ConfirmationStatus> include);

        /**
         * <p>
         * The container to determine whether to list results that have only reached <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         * <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * </p>
         * 
         * @param include
         *        The container to determine whether to list results that have only reached <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         *        <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder include(ConfirmationStatus... include);
    }

    static final class BuilderImpl implements Builder {
        private List<String> include = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConfirmationStatusFilter model) {
            includeWithStrings(model.include);
        }

        public final Collection<String> getInclude() {
            if (include instanceof SdkAutoConstructList) {
                return null;
            }
            return include;
        }

        public final void setInclude(Collection<String> include) {
            this.include = ConfirmationStatusIncludeListCopier.copy(include);
        }

        @Override
        public final Builder includeWithStrings(Collection<String> include) {
            this.include = ConfirmationStatusIncludeListCopier.copy(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder includeWithStrings(String... include) {
            includeWithStrings(Arrays.asList(include));
            return this;
        }

        @Override
        public final Builder include(Collection<ConfirmationStatus> include) {
            this.include = ConfirmationStatusIncludeListCopier.copyEnumToString(include);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder include(ConfirmationStatus... include) {
            include(Arrays.asList(include));
            return this;
        }

        @Override
        public ConfirmationStatusFilter build() {
            return new ConfirmationStatusFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
