/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetAssetContractRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<GetAssetContractRequest.Builder, GetAssetContractRequest> {
    private static final SdkField<ContractIdentifier> CONTRACT_IDENTIFIER_FIELD = SdkField
            .<ContractIdentifier> builder(MarshallingType.SDK_POJO).memberName("contractIdentifier")
            .getter(getter(GetAssetContractRequest::contractIdentifier)).setter(setter(Builder::contractIdentifier))
            .constructor(ContractIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTRACT_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final ContractIdentifier contractIdentifier;

    private GetAssetContractRequest(BuilderImpl builder) {
        super(builder);
        this.contractIdentifier = builder.contractIdentifier;
    }

    /**
     * <p>
     * Contains the blockchain address and network information about the contract.
     * </p>
     * 
     * @return Contains the blockchain address and network information about the contract.
     */
    public final ContractIdentifier contractIdentifier() {
        return contractIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(contractIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAssetContractRequest)) {
            return false;
        }
        GetAssetContractRequest other = (GetAssetContractRequest) obj;
        return Objects.equals(contractIdentifier(), other.contractIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetAssetContractRequest").add("ContractIdentifier", contractIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "contractIdentifier":
            return Optional.ofNullable(clazz.cast(contractIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("contractIdentifier", CONTRACT_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAssetContractRequest, T> g) {
        return obj -> g.apply((GetAssetContractRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetAssetContractRequest> {
        /**
         * <p>
         * Contains the blockchain address and network information about the contract.
         * </p>
         * 
         * @param contractIdentifier
         *        Contains the blockchain address and network information about the contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contractIdentifier(ContractIdentifier contractIdentifier);

        /**
         * <p>
         * Contains the blockchain address and network information about the contract.
         * </p>
         * This is a convenience method that creates an instance of the {@link ContractIdentifier.Builder} avoiding the
         * need to create one manually via {@link ContractIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ContractIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #contractIdentifier(ContractIdentifier)}.
         * 
         * @param contractIdentifier
         *        a consumer that will call methods on {@link ContractIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #contractIdentifier(ContractIdentifier)
         */
        default Builder contractIdentifier(Consumer<ContractIdentifier.Builder> contractIdentifier) {
            return contractIdentifier(ContractIdentifier.builder().applyMutation(contractIdentifier).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private ContractIdentifier contractIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAssetContractRequest model) {
            super(model);
            contractIdentifier(model.contractIdentifier);
        }

        public final ContractIdentifier.Builder getContractIdentifier() {
            return contractIdentifier != null ? contractIdentifier.toBuilder() : null;
        }

        public final void setContractIdentifier(ContractIdentifier.BuilderImpl contractIdentifier) {
            this.contractIdentifier = contractIdentifier != null ? contractIdentifier.build() : null;
        }

        @Override
        public final Builder contractIdentifier(ContractIdentifier contractIdentifier) {
            this.contractIdentifier = contractIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetAssetContractRequest build() {
            return new GetAssetContractRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
