/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransactionResponse extends ManagedBlockchainQueryResponse implements
        ToCopyableBuilder<GetTransactionResponse.Builder, GetTransactionResponse> {
    private static final SdkField<Transaction> TRANSACTION_FIELD = SdkField.<Transaction> builder(MarshallingType.SDK_POJO)
            .memberName("transaction").getter(getter(GetTransactionResponse::transaction)).setter(setter(Builder::transaction))
            .constructor(Transaction::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transaction").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Transaction transaction;

    private GetTransactionResponse(BuilderImpl builder) {
        super(builder);
        this.transaction = builder.transaction;
    }

    /**
     * <p>
     * Contains the details of the transaction.
     * </p>
     * 
     * @return Contains the details of the transaction.
     */
    public final Transaction transaction() {
        return transaction;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transaction());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransactionResponse)) {
            return false;
        }
        GetTransactionResponse other = (GetTransactionResponse) obj;
        return Objects.equals(transaction(), other.transaction());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransactionResponse").add("Transaction", transaction()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transaction":
            return Optional.ofNullable(clazz.cast(transaction()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transaction", TRANSACTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransactionResponse, T> g) {
        return obj -> g.apply((GetTransactionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransactionResponse> {
        /**
         * <p>
         * Contains the details of the transaction.
         * </p>
         * 
         * @param transaction
         *        Contains the details of the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transaction(Transaction transaction);

        /**
         * <p>
         * Contains the details of the transaction.
         * </p>
         * This is a convenience method that creates an instance of the {@link Transaction.Builder} avoiding the need to
         * create one manually via {@link Transaction#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Transaction.Builder#build()} is called immediately and its result
         * is passed to {@link #transaction(Transaction)}.
         * 
         * @param transaction
         *        a consumer that will call methods on {@link Transaction.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #transaction(Transaction)
         */
        default Builder transaction(Consumer<Transaction.Builder> transaction) {
            return transaction(Transaction.builder().applyMutation(transaction).build());
        }
    }

    static final class BuilderImpl extends ManagedBlockchainQueryResponse.BuilderImpl implements Builder {
        private Transaction transaction;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransactionResponse model) {
            super(model);
            transaction(model.transaction);
        }

        public final Transaction.Builder getTransaction() {
            return transaction != null ? transaction.toBuilder() : null;
        }

        public final void setTransaction(Transaction.BuilderImpl transaction) {
            this.transaction = transaction != null ? transaction.build() : null;
        }

        @Override
        public final Builder transaction(Transaction transaction) {
            this.transaction = transaction;
            return this;
        }

        @Override
        public GetTransactionResponse build() {
            return new GetTransactionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
