/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This container is used to specify a time frame.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TimeFilter implements SdkPojo, Serializable, ToCopyableBuilder<TimeFilter.Builder, TimeFilter> {
    private static final SdkField<BlockchainInstant> FROM_FIELD = SdkField.<BlockchainInstant> builder(MarshallingType.SDK_POJO)
            .memberName("from").getter(getter(TimeFilter::from)).setter(setter(Builder::from))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<BlockchainInstant> TO_FIELD = SdkField.<BlockchainInstant> builder(MarshallingType.SDK_POJO)
            .memberName("to").getter(getter(TimeFilter::to)).setter(setter(Builder::to)).constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FROM_FIELD, TO_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final BlockchainInstant from;

    private final BlockchainInstant to;

    private TimeFilter(BuilderImpl builder) {
        this.from = builder.from;
        this.to = builder.to;
    }

    /**
     * Returns the value of the From property for this object.
     * 
     * @return The value of the From property for this object.
     */
    public final BlockchainInstant from() {
        return from;
    }

    /**
     * Returns the value of the To property for this object.
     * 
     * @return The value of the To property for this object.
     */
    public final BlockchainInstant to() {
        return to;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TimeFilter)) {
            return false;
        }
        TimeFilter other = (TimeFilter) obj;
        return Objects.equals(from(), other.from()) && Objects.equals(to(), other.to());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TimeFilter").add("From", from()).add("To", to()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("from", FROM_FIELD);
        map.put("to", TO_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TimeFilter, T> g) {
        return obj -> g.apply((TimeFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TimeFilter> {
        /**
         * Sets the value of the From property for this object.
         *
         * @param from
         *        The new value for the From property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(BlockchainInstant from);

        /**
         * Sets the value of the From property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #from(BlockchainInstant)}.
         * 
         * @param from
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #from(BlockchainInstant)
         */
        default Builder from(Consumer<BlockchainInstant.Builder> from) {
            return from(BlockchainInstant.builder().applyMutation(from).build());
        }

        /**
         * Sets the value of the To property for this object.
         *
         * @param to
         *        The new value for the To property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(BlockchainInstant to);

        /**
         * Sets the value of the To property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #to(BlockchainInstant)}.
         * 
         * @param to
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #to(BlockchainInstant)
         */
        default Builder to(Consumer<BlockchainInstant.Builder> to) {
            return to(BlockchainInstant.builder().applyMutation(to).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private BlockchainInstant from;

        private BlockchainInstant to;

        private BuilderImpl() {
        }

        private BuilderImpl(TimeFilter model) {
            from(model.from);
            to(model.to);
        }

        public final BlockchainInstant.Builder getFrom() {
            return from != null ? from.toBuilder() : null;
        }

        public final void setFrom(BlockchainInstant.BuilderImpl from) {
            this.from = from != null ? from.build() : null;
        }

        @Override
        public final Builder from(BlockchainInstant from) {
            this.from = from;
            return this;
        }

        public final BlockchainInstant.Builder getTo() {
            return to != null ? to.toBuilder() : null;
        }

        public final void setTo(BlockchainInstant.BuilderImpl to) {
            this.to = to != null ? to.build() : null;
        }

        @Override
        public final Builder to(BlockchainInstant to) {
            this.to = to;
            return this;
        }

        @Override
        public TimeFilter build() {
            return new TimeFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
