/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The container for the properties of a transaction event.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TransactionEvent implements SdkPojo, Serializable,
        ToCopyableBuilder<TransactionEvent.Builder, TransactionEvent> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(TransactionEvent::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionHash").getter(getter(TransactionEvent::transactionHash))
            .setter(setter(Builder::transactionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()).build();

    private static final SdkField<String> EVENT_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("eventType").getter(getter(TransactionEvent::eventTypeAsString)).setter(setter(Builder::eventType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventType").build()).build();

    private static final SdkField<String> FROM_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("from")
            .getter(getter(TransactionEvent::from)).setter(setter(Builder::from))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("from").build()).build();

    private static final SdkField<String> TO_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("to")
            .getter(getter(TransactionEvent::to)).setter(setter(Builder::to))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("to").build()).build();

    private static final SdkField<String> VALUE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("value")
            .getter(getter(TransactionEvent::value)).setter(setter(Builder::value))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()).build();

    private static final SdkField<String> CONTRACT_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("contractAddress").getter(getter(TransactionEvent::contractAddress))
            .setter(setter(Builder::contractAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("contractAddress").build()).build();

    private static final SdkField<String> TOKEN_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenId").getter(getter(TransactionEvent::tokenId)).setter(setter(Builder::tokenId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenId").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionId").getter(getter(TransactionEvent::transactionId)).setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final SdkField<Integer> VOUT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("voutIndex").getter(getter(TransactionEvent::voutIndex)).setter(setter(Builder::voutIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutIndex").build()).build();

    private static final SdkField<Boolean> VOUT_SPENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("voutSpent").getter(getter(TransactionEvent::voutSpent)).setter(setter(Builder::voutSpent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutSpent").build()).build();

    private static final SdkField<String> SPENT_VOUT_TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spentVoutTransactionId").getter(getter(TransactionEvent::spentVoutTransactionId))
            .setter(setter(Builder::spentVoutTransactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spentVoutTransactionId").build())
            .build();

    private static final SdkField<String> SPENT_VOUT_TRANSACTION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("spentVoutTransactionHash").getter(getter(TransactionEvent::spentVoutTransactionHash))
            .setter(setter(Builder::spentVoutTransactionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spentVoutTransactionHash").build())
            .build();

    private static final SdkField<Integer> SPENT_VOUT_INDEX_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("spentVoutIndex").getter(getter(TransactionEvent::spentVoutIndex))
            .setter(setter(Builder::spentVoutIndex))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("spentVoutIndex").build()).build();

    private static final SdkField<BlockchainInstant> BLOCKCHAIN_INSTANT_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("blockchainInstant")
            .getter(getter(TransactionEvent::blockchainInstant)).setter(setter(Builder::blockchainInstant))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockchainInstant").build()).build();

    private static final SdkField<String> CONFIRMATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("confirmationStatus").getter(getter(TransactionEvent::confirmationStatusAsString))
            .setter(setter(Builder::confirmationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD,
            TRANSACTION_HASH_FIELD, EVENT_TYPE_FIELD, FROM_FIELD, TO_FIELD, VALUE_FIELD, CONTRACT_ADDRESS_FIELD, TOKEN_ID_FIELD,
            TRANSACTION_ID_FIELD, VOUT_INDEX_FIELD, VOUT_SPENT_FIELD, SPENT_VOUT_TRANSACTION_ID_FIELD,
            SPENT_VOUT_TRANSACTION_HASH_FIELD, SPENT_VOUT_INDEX_FIELD, BLOCKCHAIN_INSTANT_FIELD, CONFIRMATION_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String network;

    private final String transactionHash;

    private final String eventType;

    private final String from;

    private final String to;

    private final String value;

    private final String contractAddress;

    private final String tokenId;

    private final String transactionId;

    private final Integer voutIndex;

    private final Boolean voutSpent;

    private final String spentVoutTransactionId;

    private final String spentVoutTransactionHash;

    private final Integer spentVoutIndex;

    private final BlockchainInstant blockchainInstant;

    private final String confirmationStatus;

    private TransactionEvent(BuilderImpl builder) {
        this.network = builder.network;
        this.transactionHash = builder.transactionHash;
        this.eventType = builder.eventType;
        this.from = builder.from;
        this.to = builder.to;
        this.value = builder.value;
        this.contractAddress = builder.contractAddress;
        this.tokenId = builder.tokenId;
        this.transactionId = builder.transactionId;
        this.voutIndex = builder.voutIndex;
        this.voutSpent = builder.voutSpent;
        this.spentVoutTransactionId = builder.spentVoutTransactionId;
        this.spentVoutTransactionHash = builder.spentVoutTransactionHash;
        this.spentVoutIndex = builder.spentVoutIndex;
        this.blockchainInstant = builder.blockchainInstant;
        this.confirmationStatus = builder.confirmationStatus;
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    /**
     * <p>
     * The hash of a transaction. It is generated when a transaction is created.
     * </p>
     * 
     * @return The hash of a transaction. It is generated when a transaction is created.
     */
    public final String transactionHash() {
        return transactionHash;
    }

    /**
     * <p>
     * The type of transaction event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link QueryTransactionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of transaction event.
     * @see QueryTransactionEventType
     */
    public final QueryTransactionEventType eventType() {
        return QueryTransactionEventType.fromValue(eventType);
    }

    /**
     * <p>
     * The type of transaction event.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #eventType} will
     * return {@link QueryTransactionEventType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #eventTypeAsString}.
     * </p>
     * 
     * @return The type of transaction event.
     * @see QueryTransactionEventType
     */
    public final String eventTypeAsString() {
        return eventType;
    }

    /**
     * <p>
     * The wallet address initiating the transaction. It can either be a public key or a contract.
     * </p>
     * 
     * @return The wallet address initiating the transaction. It can either be a public key or a contract.
     */
    public final String from() {
        return from;
    }

    /**
     * <p>
     * The wallet address receiving the transaction. It can either be a public key or a contract.
     * </p>
     * 
     * @return The wallet address receiving the transaction. It can either be a public key or a contract.
     */
    public final String to() {
        return to;
    }

    /**
     * <p>
     * The value that was transacted.
     * </p>
     * 
     * @return The value that was transacted.
     */
    public final String value() {
        return value;
    }

    /**
     * <p>
     * The blockchain address for the contract
     * </p>
     * 
     * @return The blockchain address for the contract
     */
    public final String contractAddress() {
        return contractAddress;
    }

    /**
     * <p>
     * The unique identifier for the token involved in the transaction.
     * </p>
     * 
     * @return The unique identifier for the token involved in the transaction.
     */
    public final String tokenId() {
        return tokenId;
    }

    /**
     * <p>
     * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     * </p>
     * 
     * @return The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The position of the transaction output in the transaction output list.
     * </p>
     * 
     * @return The position of the transaction output in the transaction output list.
     */
    public final Integer voutIndex() {
        return voutIndex;
    }

    /**
     * <p>
     * Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event types.
     * </p>
     * <note>
     * <p>
     * This is only returned for <code>BITCOIN_VOUT</code> event types.
     * </p>
     * </note>
     * 
     * @return Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event
     *         types.</p> <note>
     *         <p>
     *         This is only returned for <code>BITCOIN_VOUT</code> event types.
     *         </p>
     */
    public final Boolean voutSpent() {
        return voutSpent;
    }

    /**
     * <p>
     * The transactionId that <i>created</i> the spent transaction output.
     * </p>
     * <note>
     * <p>
     * This is only returned for <code>BITCOIN_VIN</code> event types.
     * </p>
     * </note>
     * 
     * @return The transactionId that <i>created</i> the spent transaction output.</p> <note>
     *         <p>
     *         This is only returned for <code>BITCOIN_VIN</code> event types.
     *         </p>
     */
    public final String spentVoutTransactionId() {
        return spentVoutTransactionId;
    }

    /**
     * <p>
     * The transactionHash that <i>created</i> the spent transaction output.
     * </p>
     * <note>
     * <p>
     * This is only returned for <code>BITCOIN_VIN</code> event types.
     * </p>
     * </note>
     * 
     * @return The transactionHash that <i>created</i> the spent transaction output.</p> <note>
     *         <p>
     *         This is only returned for <code>BITCOIN_VIN</code> event types.
     *         </p>
     */
    public final String spentVoutTransactionHash() {
        return spentVoutTransactionHash;
    }

    /**
     * <p>
     * The position of the spent transaction output in the output list of the <i>creating transaction</i>.
     * </p>
     * <note>
     * <p>
     * This is only returned for <code>BITCOIN_VIN</code> event types.
     * </p>
     * </note>
     * 
     * @return The position of the spent transaction output in the output list of the <i>creating transaction</i>.</p>
     *         <note>
     *         <p>
     *         This is only returned for <code>BITCOIN_VIN</code> event types.
     *         </p>
     */
    public final Integer spentVoutIndex() {
        return spentVoutIndex;
    }

    /**
     * Returns the value of the BlockchainInstant property for this object.
     * 
     * @return The value of the BlockchainInstant property for this object.
     */
    public final BlockchainInstant blockchainInstant() {
        return blockchainInstant;
    }

    /**
     * <p>
     * This container specifies whether the transaction has reached Finality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confirmationStatus} will return {@link ConfirmationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #confirmationStatusAsString}.
     * </p>
     * 
     * @return This container specifies whether the transaction has reached Finality.
     * @see ConfirmationStatus
     */
    public final ConfirmationStatus confirmationStatus() {
        return ConfirmationStatus.fromValue(confirmationStatus);
    }

    /**
     * <p>
     * This container specifies whether the transaction has reached Finality.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #confirmationStatus} will return {@link ConfirmationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #confirmationStatusAsString}.
     * </p>
     * 
     * @return This container specifies whether the transaction has reached Finality.
     * @see ConfirmationStatus
     */
    public final String confirmationStatusAsString() {
        return confirmationStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(eventTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(from());
        hashCode = 31 * hashCode + Objects.hashCode(to());
        hashCode = 31 * hashCode + Objects.hashCode(value());
        hashCode = 31 * hashCode + Objects.hashCode(contractAddress());
        hashCode = 31 * hashCode + Objects.hashCode(tokenId());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(voutIndex());
        hashCode = 31 * hashCode + Objects.hashCode(voutSpent());
        hashCode = 31 * hashCode + Objects.hashCode(spentVoutTransactionId());
        hashCode = 31 * hashCode + Objects.hashCode(spentVoutTransactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(spentVoutIndex());
        hashCode = 31 * hashCode + Objects.hashCode(blockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TransactionEvent)) {
            return false;
        }
        TransactionEvent other = (TransactionEvent) obj;
        return Objects.equals(networkAsString(), other.networkAsString())
                && Objects.equals(transactionHash(), other.transactionHash())
                && Objects.equals(eventTypeAsString(), other.eventTypeAsString()) && Objects.equals(from(), other.from())
                && Objects.equals(to(), other.to()) && Objects.equals(value(), other.value())
                && Objects.equals(contractAddress(), other.contractAddress()) && Objects.equals(tokenId(), other.tokenId())
                && Objects.equals(transactionId(), other.transactionId()) && Objects.equals(voutIndex(), other.voutIndex())
                && Objects.equals(voutSpent(), other.voutSpent())
                && Objects.equals(spentVoutTransactionId(), other.spentVoutTransactionId())
                && Objects.equals(spentVoutTransactionHash(), other.spentVoutTransactionHash())
                && Objects.equals(spentVoutIndex(), other.spentVoutIndex())
                && Objects.equals(blockchainInstant(), other.blockchainInstant())
                && Objects.equals(confirmationStatusAsString(), other.confirmationStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TransactionEvent").add("Network", networkAsString()).add("TransactionHash", transactionHash())
                .add("EventType", eventTypeAsString()).add("From", from()).add("To", to()).add("Value", value())
                .add("ContractAddress", contractAddress()).add("TokenId", tokenId()).add("TransactionId", transactionId())
                .add("VoutIndex", voutIndex()).add("VoutSpent", voutSpent())
                .add("SpentVoutTransactionId", spentVoutTransactionId())
                .add("SpentVoutTransactionHash", spentVoutTransactionHash()).add("SpentVoutIndex", spentVoutIndex())
                .add("BlockchainInstant", blockchainInstant()).add("ConfirmationStatus", confirmationStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        case "transactionHash":
            return Optional.ofNullable(clazz.cast(transactionHash()));
        case "eventType":
            return Optional.ofNullable(clazz.cast(eventTypeAsString()));
        case "from":
            return Optional.ofNullable(clazz.cast(from()));
        case "to":
            return Optional.ofNullable(clazz.cast(to()));
        case "value":
            return Optional.ofNullable(clazz.cast(value()));
        case "contractAddress":
            return Optional.ofNullable(clazz.cast(contractAddress()));
        case "tokenId":
            return Optional.ofNullable(clazz.cast(tokenId()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "voutIndex":
            return Optional.ofNullable(clazz.cast(voutIndex()));
        case "voutSpent":
            return Optional.ofNullable(clazz.cast(voutSpent()));
        case "spentVoutTransactionId":
            return Optional.ofNullable(clazz.cast(spentVoutTransactionId()));
        case "spentVoutTransactionHash":
            return Optional.ofNullable(clazz.cast(spentVoutTransactionHash()));
        case "spentVoutIndex":
            return Optional.ofNullable(clazz.cast(spentVoutIndex()));
        case "blockchainInstant":
            return Optional.ofNullable(clazz.cast(blockchainInstant()));
        case "confirmationStatus":
            return Optional.ofNullable(clazz.cast(confirmationStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("network", NETWORK_FIELD);
        map.put("transactionHash", TRANSACTION_HASH_FIELD);
        map.put("eventType", EVENT_TYPE_FIELD);
        map.put("from", FROM_FIELD);
        map.put("to", TO_FIELD);
        map.put("value", VALUE_FIELD);
        map.put("contractAddress", CONTRACT_ADDRESS_FIELD);
        map.put("tokenId", TOKEN_ID_FIELD);
        map.put("transactionId", TRANSACTION_ID_FIELD);
        map.put("voutIndex", VOUT_INDEX_FIELD);
        map.put("voutSpent", VOUT_SPENT_FIELD);
        map.put("spentVoutTransactionId", SPENT_VOUT_TRANSACTION_ID_FIELD);
        map.put("spentVoutTransactionHash", SPENT_VOUT_TRANSACTION_HASH_FIELD);
        map.put("spentVoutIndex", SPENT_VOUT_INDEX_FIELD);
        map.put("blockchainInstant", BLOCKCHAIN_INSTANT_FIELD);
        map.put("confirmationStatus", CONFIRMATION_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TransactionEvent, T> g) {
        return obj -> g.apply((TransactionEvent) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TransactionEvent> {
        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        /**
         * <p>
         * The hash of a transaction. It is generated when a transaction is created.
         * </p>
         * 
         * @param transactionHash
         *        The hash of a transaction. It is generated when a transaction is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionHash(String transactionHash);

        /**
         * <p>
         * The type of transaction event.
         * </p>
         * 
         * @param eventType
         *        The type of transaction event.
         * @see QueryTransactionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTransactionEventType
         */
        Builder eventType(String eventType);

        /**
         * <p>
         * The type of transaction event.
         * </p>
         * 
         * @param eventType
         *        The type of transaction event.
         * @see QueryTransactionEventType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTransactionEventType
         */
        Builder eventType(QueryTransactionEventType eventType);

        /**
         * <p>
         * The wallet address initiating the transaction. It can either be a public key or a contract.
         * </p>
         * 
         * @param from
         *        The wallet address initiating the transaction. It can either be a public key or a contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder from(String from);

        /**
         * <p>
         * The wallet address receiving the transaction. It can either be a public key or a contract.
         * </p>
         * 
         * @param to
         *        The wallet address receiving the transaction. It can either be a public key or a contract.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder to(String to);

        /**
         * <p>
         * The value that was transacted.
         * </p>
         * 
         * @param value
         *        The value that was transacted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder value(String value);

        /**
         * <p>
         * The blockchain address for the contract
         * </p>
         * 
         * @param contractAddress
         *        The blockchain address for the contract
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder contractAddress(String contractAddress);

        /**
         * <p>
         * The unique identifier for the token involved in the transaction.
         * </p>
         * 
         * @param tokenId
         *        The unique identifier for the token involved in the transaction.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenId(String tokenId);

        /**
         * <p>
         * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         * </p>
         * 
         * @param transactionId
         *        The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The position of the transaction output in the transaction output list.
         * </p>
         * 
         * @param voutIndex
         *        The position of the transaction output in the transaction output list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voutIndex(Integer voutIndex);

        /**
         * <p>
         * Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event types.
         * </p>
         * <note>
         * <p>
         * This is only returned for <code>BITCOIN_VOUT</code> event types.
         * </p>
         * </note>
         * 
         * @param voutSpent
         *        Specifies if the transaction output is spent or unspent. This is only returned for BITCOIN_VOUT event
         *        types.</p> <note>
         *        <p>
         *        This is only returned for <code>BITCOIN_VOUT</code> event types.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voutSpent(Boolean voutSpent);

        /**
         * <p>
         * The transactionId that <i>created</i> the spent transaction output.
         * </p>
         * <note>
         * <p>
         * This is only returned for <code>BITCOIN_VIN</code> event types.
         * </p>
         * </note>
         * 
         * @param spentVoutTransactionId
         *        The transactionId that <i>created</i> the spent transaction output.</p> <note>
         *        <p>
         *        This is only returned for <code>BITCOIN_VIN</code> event types.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spentVoutTransactionId(String spentVoutTransactionId);

        /**
         * <p>
         * The transactionHash that <i>created</i> the spent transaction output.
         * </p>
         * <note>
         * <p>
         * This is only returned for <code>BITCOIN_VIN</code> event types.
         * </p>
         * </note>
         * 
         * @param spentVoutTransactionHash
         *        The transactionHash that <i>created</i> the spent transaction output.</p> <note>
         *        <p>
         *        This is only returned for <code>BITCOIN_VIN</code> event types.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spentVoutTransactionHash(String spentVoutTransactionHash);

        /**
         * <p>
         * The position of the spent transaction output in the output list of the <i>creating transaction</i>.
         * </p>
         * <note>
         * <p>
         * This is only returned for <code>BITCOIN_VIN</code> event types.
         * </p>
         * </note>
         * 
         * @param spentVoutIndex
         *        The position of the spent transaction output in the output list of the <i>creating
         *        transaction</i>.</p> <note>
         *        <p>
         *        This is only returned for <code>BITCOIN_VIN</code> event types.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder spentVoutIndex(Integer spentVoutIndex);

        /**
         * Sets the value of the BlockchainInstant property for this object.
         *
         * @param blockchainInstant
         *        The new value for the BlockchainInstant property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder blockchainInstant(BlockchainInstant blockchainInstant);

        /**
         * Sets the value of the BlockchainInstant property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #blockchainInstant(BlockchainInstant)}.
         * 
         * @param blockchainInstant
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #blockchainInstant(BlockchainInstant)
         */
        default Builder blockchainInstant(Consumer<BlockchainInstant.Builder> blockchainInstant) {
            return blockchainInstant(BlockchainInstant.builder().applyMutation(blockchainInstant).build());
        }

        /**
         * <p>
         * This container specifies whether the transaction has reached Finality.
         * </p>
         * 
         * @param confirmationStatus
         *        This container specifies whether the transaction has reached Finality.
         * @see ConfirmationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfirmationStatus
         */
        Builder confirmationStatus(String confirmationStatus);

        /**
         * <p>
         * This container specifies whether the transaction has reached Finality.
         * </p>
         * 
         * @param confirmationStatus
         *        This container specifies whether the transaction has reached Finality.
         * @see ConfirmationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConfirmationStatus
         */
        Builder confirmationStatus(ConfirmationStatus confirmationStatus);
    }

    static final class BuilderImpl implements Builder {
        private String network;

        private String transactionHash;

        private String eventType;

        private String from;

        private String to;

        private String value;

        private String contractAddress;

        private String tokenId;

        private String transactionId;

        private Integer voutIndex;

        private Boolean voutSpent;

        private String spentVoutTransactionId;

        private String spentVoutTransactionHash;

        private Integer spentVoutIndex;

        private BlockchainInstant blockchainInstant;

        private String confirmationStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(TransactionEvent model) {
            network(model.network);
            transactionHash(model.transactionHash);
            eventType(model.eventType);
            from(model.from);
            to(model.to);
            value(model.value);
            contractAddress(model.contractAddress);
            tokenId(model.tokenId);
            transactionId(model.transactionId);
            voutIndex(model.voutIndex);
            voutSpent(model.voutSpent);
            spentVoutTransactionId(model.spentVoutTransactionId);
            spentVoutTransactionHash(model.spentVoutTransactionHash);
            spentVoutIndex(model.spentVoutIndex);
            blockchainInstant(model.blockchainInstant);
            confirmationStatus(model.confirmationStatus);
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getTransactionHash() {
            return transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getEventType() {
            return eventType;
        }

        public final void setEventType(String eventType) {
            this.eventType = eventType;
        }

        @Override
        public final Builder eventType(String eventType) {
            this.eventType = eventType;
            return this;
        }

        @Override
        public final Builder eventType(QueryTransactionEventType eventType) {
            this.eventType(eventType == null ? null : eventType.toString());
            return this;
        }

        public final String getFrom() {
            return from;
        }

        public final void setFrom(String from) {
            this.from = from;
        }

        @Override
        public final Builder from(String from) {
            this.from = from;
            return this;
        }

        public final String getTo() {
            return to;
        }

        public final void setTo(String to) {
            this.to = to;
        }

        @Override
        public final Builder to(String to) {
            this.to = to;
            return this;
        }

        public final String getValue() {
            return value;
        }

        public final void setValue(String value) {
            this.value = value;
        }

        @Override
        public final Builder value(String value) {
            this.value = value;
            return this;
        }

        public final String getContractAddress() {
            return contractAddress;
        }

        public final void setContractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
        }

        @Override
        public final Builder contractAddress(String contractAddress) {
            this.contractAddress = contractAddress;
            return this;
        }

        public final String getTokenId() {
            return tokenId;
        }

        public final void setTokenId(String tokenId) {
            this.tokenId = tokenId;
        }

        @Override
        public final Builder tokenId(String tokenId) {
            this.tokenId = tokenId;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final Integer getVoutIndex() {
            return voutIndex;
        }

        public final void setVoutIndex(Integer voutIndex) {
            this.voutIndex = voutIndex;
        }

        @Override
        public final Builder voutIndex(Integer voutIndex) {
            this.voutIndex = voutIndex;
            return this;
        }

        public final Boolean getVoutSpent() {
            return voutSpent;
        }

        public final void setVoutSpent(Boolean voutSpent) {
            this.voutSpent = voutSpent;
        }

        @Override
        public final Builder voutSpent(Boolean voutSpent) {
            this.voutSpent = voutSpent;
            return this;
        }

        public final String getSpentVoutTransactionId() {
            return spentVoutTransactionId;
        }

        public final void setSpentVoutTransactionId(String spentVoutTransactionId) {
            this.spentVoutTransactionId = spentVoutTransactionId;
        }

        @Override
        public final Builder spentVoutTransactionId(String spentVoutTransactionId) {
            this.spentVoutTransactionId = spentVoutTransactionId;
            return this;
        }

        public final String getSpentVoutTransactionHash() {
            return spentVoutTransactionHash;
        }

        public final void setSpentVoutTransactionHash(String spentVoutTransactionHash) {
            this.spentVoutTransactionHash = spentVoutTransactionHash;
        }

        @Override
        public final Builder spentVoutTransactionHash(String spentVoutTransactionHash) {
            this.spentVoutTransactionHash = spentVoutTransactionHash;
            return this;
        }

        public final Integer getSpentVoutIndex() {
            return spentVoutIndex;
        }

        public final void setSpentVoutIndex(Integer spentVoutIndex) {
            this.spentVoutIndex = spentVoutIndex;
        }

        @Override
        public final Builder spentVoutIndex(Integer spentVoutIndex) {
            this.spentVoutIndex = spentVoutIndex;
            return this;
        }

        public final BlockchainInstant.Builder getBlockchainInstant() {
            return blockchainInstant != null ? blockchainInstant.toBuilder() : null;
        }

        public final void setBlockchainInstant(BlockchainInstant.BuilderImpl blockchainInstant) {
            this.blockchainInstant = blockchainInstant != null ? blockchainInstant.build() : null;
        }

        @Override
        public final Builder blockchainInstant(BlockchainInstant blockchainInstant) {
            this.blockchainInstant = blockchainInstant;
            return this;
        }

        public final String getConfirmationStatus() {
            return confirmationStatus;
        }

        public final void setConfirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
        }

        @Override
        public final Builder confirmationStatus(String confirmationStatus) {
            this.confirmationStatus = confirmationStatus;
            return this;
        }

        @Override
        public final Builder confirmationStatus(ConfirmationStatus confirmationStatus) {
            this.confirmationStatus(confirmationStatus == null ? null : confirmationStatus.toString());
            return this;
        }

        @Override
        public TransactionEvent build() {
            return new TransactionEvent(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
