/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * This container specifies filtering attributes related to <code>BITCOIN_VOUT</code> event types
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VoutFilter implements SdkPojo, Serializable, ToCopyableBuilder<VoutFilter.Builder, VoutFilter> {
    private static final SdkField<Boolean> VOUT_SPENT_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("voutSpent").getter(getter(VoutFilter::voutSpent)).setter(setter(Builder::voutSpent))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("voutSpent").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VOUT_SPENT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Boolean voutSpent;

    private VoutFilter(BuilderImpl builder) {
        this.voutSpent = builder.voutSpent;
    }

    /**
     * <p>
     * Specifies if the transaction output is spent or unspent.
     * </p>
     * 
     * @return Specifies if the transaction output is spent or unspent.
     */
    public final Boolean voutSpent() {
        return voutSpent;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(voutSpent());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VoutFilter)) {
            return false;
        }
        VoutFilter other = (VoutFilter) obj;
        return Objects.equals(voutSpent(), other.voutSpent());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VoutFilter").add("VoutSpent", voutSpent()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "voutSpent":
            return Optional.ofNullable(clazz.cast(voutSpent()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("voutSpent", VOUT_SPENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VoutFilter, T> g) {
        return obj -> g.apply((VoutFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VoutFilter> {
        /**
         * <p>
         * Specifies if the transaction output is spent or unspent.
         * </p>
         * 
         * @param voutSpent
         *        Specifies if the transaction output is spent or unspent.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder voutSpent(Boolean voutSpent);
    }

    static final class BuilderImpl implements Builder {
        private Boolean voutSpent;

        private BuilderImpl() {
        }

        private BuilderImpl(VoutFilter model) {
            voutSpent(model.voutSpent);
        }

        public final Boolean getVoutSpent() {
            return voutSpent;
        }

        public final void setVoutSpent(Boolean voutSpent) {
            this.voutSpent = voutSpent;
        }

        @Override
        public final Builder voutSpent(Boolean voutSpent) {
            this.voutSpent = voutSpent;
            return this;
        }

        @Override
        public VoutFilter build() {
            return new VoutFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
