/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Error generated from a failed <code>BatchGetTokenBalance</code> request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchGetTokenBalanceErrorItem implements SdkPojo, Serializable,
        ToCopyableBuilder<BatchGetTokenBalanceErrorItem.Builder, BatchGetTokenBalanceErrorItem> {
    private static final SdkField<TokenIdentifier> TOKEN_IDENTIFIER_FIELD = SdkField
            .<TokenIdentifier> builder(MarshallingType.SDK_POJO).memberName("tokenIdentifier")
            .getter(getter(BatchGetTokenBalanceErrorItem::tokenIdentifier)).setter(setter(Builder::tokenIdentifier))
            .constructor(TokenIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenIdentifier").build()).build();

    private static final SdkField<OwnerIdentifier> OWNER_IDENTIFIER_FIELD = SdkField
            .<OwnerIdentifier> builder(MarshallingType.SDK_POJO).memberName("ownerIdentifier")
            .getter(getter(BatchGetTokenBalanceErrorItem::ownerIdentifier)).setter(setter(Builder::ownerIdentifier))
            .constructor(OwnerIdentifier::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerIdentifier").build()).build();

    private static final SdkField<BlockchainInstant> AT_BLOCKCHAIN_INSTANT_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("atBlockchainInstant")
            .getter(getter(BatchGetTokenBalanceErrorItem::atBlockchainInstant)).setter(setter(Builder::atBlockchainInstant))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atBlockchainInstant").build())
            .build();

    private static final SdkField<String> ERROR_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorCode").getter(getter(BatchGetTokenBalanceErrorItem::errorCode)).setter(setter(Builder::errorCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorCode").build()).build();

    private static final SdkField<String> ERROR_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorMessage").getter(getter(BatchGetTokenBalanceErrorItem::errorMessage))
            .setter(setter(Builder::errorMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorMessage").build()).build();

    private static final SdkField<String> ERROR_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("errorType").getter(getter(BatchGetTokenBalanceErrorItem::errorTypeAsString))
            .setter(setter(Builder::errorType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errorType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOKEN_IDENTIFIER_FIELD,
            OWNER_IDENTIFIER_FIELD, AT_BLOCKCHAIN_INSTANT_FIELD, ERROR_CODE_FIELD, ERROR_MESSAGE_FIELD, ERROR_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final TokenIdentifier tokenIdentifier;

    private final OwnerIdentifier ownerIdentifier;

    private final BlockchainInstant atBlockchainInstant;

    private final String errorCode;

    private final String errorMessage;

    private final String errorType;

    private BatchGetTokenBalanceErrorItem(BuilderImpl builder) {
        this.tokenIdentifier = builder.tokenIdentifier;
        this.ownerIdentifier = builder.ownerIdentifier;
        this.atBlockchainInstant = builder.atBlockchainInstant;
        this.errorCode = builder.errorCode;
        this.errorMessage = builder.errorMessage;
        this.errorType = builder.errorType;
    }

    /**
     * Returns the value of the TokenIdentifier property for this object.
     * 
     * @return The value of the TokenIdentifier property for this object.
     */
    public final TokenIdentifier tokenIdentifier() {
        return tokenIdentifier;
    }

    /**
     * Returns the value of the OwnerIdentifier property for this object.
     * 
     * @return The value of the OwnerIdentifier property for this object.
     */
    public final OwnerIdentifier ownerIdentifier() {
        return ownerIdentifier;
    }

    /**
     * Returns the value of the AtBlockchainInstant property for this object.
     * 
     * @return The value of the AtBlockchainInstant property for this object.
     */
    public final BlockchainInstant atBlockchainInstant() {
        return atBlockchainInstant;
    }

    /**
     * <p>
     * The error code associated with the error.
     * </p>
     * 
     * @return The error code associated with the error.
     */
    public final String errorCode() {
        return errorCode;
    }

    /**
     * <p>
     * The message associated with the error.
     * </p>
     * 
     * @return The message associated with the error.
     */
    public final String errorMessage() {
        return errorMessage;
    }

    /**
     * <p>
     * The type of error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link ErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorTypeAsString}.
     * </p>
     * 
     * @return The type of error.
     * @see ErrorType
     */
    public final ErrorType errorType() {
        return ErrorType.fromValue(errorType);
    }

    /**
     * <p>
     * The type of error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #errorType} will
     * return {@link ErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorTypeAsString}.
     * </p>
     * 
     * @return The type of error.
     * @see ErrorType
     */
    public final String errorTypeAsString() {
        return errorType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(tokenIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(ownerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(atBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(errorCode());
        hashCode = 31 * hashCode + Objects.hashCode(errorMessage());
        hashCode = 31 * hashCode + Objects.hashCode(errorTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTokenBalanceErrorItem)) {
            return false;
        }
        BatchGetTokenBalanceErrorItem other = (BatchGetTokenBalanceErrorItem) obj;
        return Objects.equals(tokenIdentifier(), other.tokenIdentifier())
                && Objects.equals(ownerIdentifier(), other.ownerIdentifier())
                && Objects.equals(atBlockchainInstant(), other.atBlockchainInstant())
                && Objects.equals(errorCode(), other.errorCode()) && Objects.equals(errorMessage(), other.errorMessage())
                && Objects.equals(errorTypeAsString(), other.errorTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("BatchGetTokenBalanceErrorItem").add("TokenIdentifier", tokenIdentifier())
                .add("OwnerIdentifier", ownerIdentifier()).add("AtBlockchainInstant", atBlockchainInstant())
                .add("ErrorCode", errorCode()).add("ErrorMessage", errorMessage()).add("ErrorType", errorTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "tokenIdentifier":
            return Optional.ofNullable(clazz.cast(tokenIdentifier()));
        case "ownerIdentifier":
            return Optional.ofNullable(clazz.cast(ownerIdentifier()));
        case "atBlockchainInstant":
            return Optional.ofNullable(clazz.cast(atBlockchainInstant()));
        case "errorCode":
            return Optional.ofNullable(clazz.cast(errorCode()));
        case "errorMessage":
            return Optional.ofNullable(clazz.cast(errorMessage()));
        case "errorType":
            return Optional.ofNullable(clazz.cast(errorTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("tokenIdentifier", TOKEN_IDENTIFIER_FIELD);
        map.put("ownerIdentifier", OWNER_IDENTIFIER_FIELD);
        map.put("atBlockchainInstant", AT_BLOCKCHAIN_INSTANT_FIELD);
        map.put("errorCode", ERROR_CODE_FIELD);
        map.put("errorMessage", ERROR_MESSAGE_FIELD);
        map.put("errorType", ERROR_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTokenBalanceErrorItem, T> g) {
        return obj -> g.apply((BatchGetTokenBalanceErrorItem) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, BatchGetTokenBalanceErrorItem> {
        /**
         * Sets the value of the TokenIdentifier property for this object.
         *
         * @param tokenIdentifier
         *        The new value for the TokenIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tokenIdentifier(TokenIdentifier tokenIdentifier);

        /**
         * Sets the value of the TokenIdentifier property for this object.
         *
         * This is a convenience method that creates an instance of the {@link TokenIdentifier.Builder} avoiding the
         * need to create one manually via {@link TokenIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link TokenIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #tokenIdentifier(TokenIdentifier)}.
         * 
         * @param tokenIdentifier
         *        a consumer that will call methods on {@link TokenIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #tokenIdentifier(TokenIdentifier)
         */
        default Builder tokenIdentifier(Consumer<TokenIdentifier.Builder> tokenIdentifier) {
            return tokenIdentifier(TokenIdentifier.builder().applyMutation(tokenIdentifier).build());
        }

        /**
         * Sets the value of the OwnerIdentifier property for this object.
         *
         * @param ownerIdentifier
         *        The new value for the OwnerIdentifier property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerIdentifier(OwnerIdentifier ownerIdentifier);

        /**
         * Sets the value of the OwnerIdentifier property for this object.
         *
         * This is a convenience method that creates an instance of the {@link OwnerIdentifier.Builder} avoiding the
         * need to create one manually via {@link OwnerIdentifier#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link OwnerIdentifier.Builder#build()} is called immediately and its
         * result is passed to {@link #ownerIdentifier(OwnerIdentifier)}.
         * 
         * @param ownerIdentifier
         *        a consumer that will call methods on {@link OwnerIdentifier.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ownerIdentifier(OwnerIdentifier)
         */
        default Builder ownerIdentifier(Consumer<OwnerIdentifier.Builder> ownerIdentifier) {
            return ownerIdentifier(OwnerIdentifier.builder().applyMutation(ownerIdentifier).build());
        }

        /**
         * Sets the value of the AtBlockchainInstant property for this object.
         *
         * @param atBlockchainInstant
         *        The new value for the AtBlockchainInstant property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant);

        /**
         * Sets the value of the AtBlockchainInstant property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #atBlockchainInstant(BlockchainInstant)}.
         * 
         * @param atBlockchainInstant
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #atBlockchainInstant(BlockchainInstant)
         */
        default Builder atBlockchainInstant(Consumer<BlockchainInstant.Builder> atBlockchainInstant) {
            return atBlockchainInstant(BlockchainInstant.builder().applyMutation(atBlockchainInstant).build());
        }

        /**
         * <p>
         * The error code associated with the error.
         * </p>
         * 
         * @param errorCode
         *        The error code associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorCode(String errorCode);

        /**
         * <p>
         * The message associated with the error.
         * </p>
         * 
         * @param errorMessage
         *        The message associated with the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errorMessage(String errorMessage);

        /**
         * <p>
         * The type of error.
         * </p>
         * 
         * @param errorType
         *        The type of error.
         * @see ErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorType
         */
        Builder errorType(String errorType);

        /**
         * <p>
         * The type of error.
         * </p>
         * 
         * @param errorType
         *        The type of error.
         * @see ErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ErrorType
         */
        Builder errorType(ErrorType errorType);
    }

    static final class BuilderImpl implements Builder {
        private TokenIdentifier tokenIdentifier;

        private OwnerIdentifier ownerIdentifier;

        private BlockchainInstant atBlockchainInstant;

        private String errorCode;

        private String errorMessage;

        private String errorType;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTokenBalanceErrorItem model) {
            tokenIdentifier(model.tokenIdentifier);
            ownerIdentifier(model.ownerIdentifier);
            atBlockchainInstant(model.atBlockchainInstant);
            errorCode(model.errorCode);
            errorMessage(model.errorMessage);
            errorType(model.errorType);
        }

        public final TokenIdentifier.Builder getTokenIdentifier() {
            return tokenIdentifier != null ? tokenIdentifier.toBuilder() : null;
        }

        public final void setTokenIdentifier(TokenIdentifier.BuilderImpl tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier != null ? tokenIdentifier.build() : null;
        }

        @Override
        public final Builder tokenIdentifier(TokenIdentifier tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public final OwnerIdentifier.Builder getOwnerIdentifier() {
            return ownerIdentifier != null ? ownerIdentifier.toBuilder() : null;
        }

        public final void setOwnerIdentifier(OwnerIdentifier.BuilderImpl ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier != null ? ownerIdentifier.build() : null;
        }

        @Override
        public final Builder ownerIdentifier(OwnerIdentifier ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier;
            return this;
        }

        public final BlockchainInstant.Builder getAtBlockchainInstant() {
            return atBlockchainInstant != null ? atBlockchainInstant.toBuilder() : null;
        }

        public final void setAtBlockchainInstant(BlockchainInstant.BuilderImpl atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant != null ? atBlockchainInstant.build() : null;
        }

        @Override
        public final Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant;
            return this;
        }

        public final String getErrorCode() {
            return errorCode;
        }

        public final void setErrorCode(String errorCode) {
            this.errorCode = errorCode;
        }

        @Override
        public final Builder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public final String getErrorMessage() {
            return errorMessage;
        }

        public final void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        @Override
        public final Builder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public final String getErrorType() {
            return errorType;
        }

        public final void setErrorType(String errorType) {
            this.errorType = errorType;
        }

        @Override
        public final Builder errorType(String errorType) {
            this.errorType = errorType;
            return this;
        }

        @Override
        public final Builder errorType(ErrorType errorType) {
            this.errorType(errorType == null ? null : errorType.toString());
            return this;
        }

        @Override
        public BatchGetTokenBalanceErrorItem build() {
            return new BatchGetTokenBalanceErrorItem(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
