/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The contract or wallet address by which to filter the request.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContractFilter implements SdkPojo, Serializable, ToCopyableBuilder<ContractFilter.Builder, ContractFilter> {
    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(ContractFilter::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<String> TOKEN_STANDARD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("tokenStandard").getter(getter(ContractFilter::tokenStandardAsString))
            .setter(setter(Builder::tokenStandard))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenStandard").build()).build();

    private static final SdkField<String> DEPLOYER_ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deployerAddress").getter(getter(ContractFilter::deployerAddress))
            .setter(setter(Builder::deployerAddress))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deployerAddress").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NETWORK_FIELD,
            TOKEN_STANDARD_FIELD, DEPLOYER_ADDRESS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String network;

    private final String tokenStandard;

    private final String deployerAddress;

    private ContractFilter(BuilderImpl builder) {
        this.network = builder.network;
        this.tokenStandard = builder.tokenStandard;
        this.deployerAddress = builder.deployerAddress;
    }

    /**
     * <p>
     * The blockchain network of the contract.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network of the contract.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network of the contract.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network of the contract.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    /**
     * <p>
     * The container for the token standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tokenStandard}
     * will return {@link QueryTokenStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tokenStandardAsString}.
     * </p>
     * 
     * @return The container for the token standard.
     * @see QueryTokenStandard
     */
    public final QueryTokenStandard tokenStandard() {
        return QueryTokenStandard.fromValue(tokenStandard);
    }

    /**
     * <p>
     * The container for the token standard.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #tokenStandard}
     * will return {@link QueryTokenStandard#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #tokenStandardAsString}.
     * </p>
     * 
     * @return The container for the token standard.
     * @see QueryTokenStandard
     */
    public final String tokenStandardAsString() {
        return tokenStandard;
    }

    /**
     * <p>
     * The network address of the deployer.
     * </p>
     * 
     * @return The network address of the deployer.
     */
    public final String deployerAddress() {
        return deployerAddress;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(tokenStandardAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deployerAddress());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContractFilter)) {
            return false;
        }
        ContractFilter other = (ContractFilter) obj;
        return Objects.equals(networkAsString(), other.networkAsString())
                && Objects.equals(tokenStandardAsString(), other.tokenStandardAsString())
                && Objects.equals(deployerAddress(), other.deployerAddress());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContractFilter").add("Network", networkAsString()).add("TokenStandard", tokenStandardAsString())
                .add("DeployerAddress", deployerAddress()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        case "tokenStandard":
            return Optional.ofNullable(clazz.cast(tokenStandardAsString()));
        case "deployerAddress":
            return Optional.ofNullable(clazz.cast(deployerAddress()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("network", NETWORK_FIELD);
        map.put("tokenStandard", TOKEN_STANDARD_FIELD);
        map.put("deployerAddress", DEPLOYER_ADDRESS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContractFilter, T> g) {
        return obj -> g.apply((ContractFilter) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContractFilter> {
        /**
         * <p>
         * The blockchain network of the contract.
         * </p>
         * 
         * @param network
         *        The blockchain network of the contract.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network of the contract.
         * </p>
         * 
         * @param network
         *        The blockchain network of the contract.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        /**
         * <p>
         * The container for the token standard.
         * </p>
         * 
         * @param tokenStandard
         *        The container for the token standard.
         * @see QueryTokenStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTokenStandard
         */
        Builder tokenStandard(String tokenStandard);

        /**
         * <p>
         * The container for the token standard.
         * </p>
         * 
         * @param tokenStandard
         *        The container for the token standard.
         * @see QueryTokenStandard
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryTokenStandard
         */
        Builder tokenStandard(QueryTokenStandard tokenStandard);

        /**
         * <p>
         * The network address of the deployer.
         * </p>
         * 
         * @param deployerAddress
         *        The network address of the deployer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deployerAddress(String deployerAddress);
    }

    static final class BuilderImpl implements Builder {
        private String network;

        private String tokenStandard;

        private String deployerAddress;

        private BuilderImpl() {
        }

        private BuilderImpl(ContractFilter model) {
            network(model.network);
            tokenStandard(model.tokenStandard);
            deployerAddress(model.deployerAddress);
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final String getTokenStandard() {
            return tokenStandard;
        }

        public final void setTokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
        }

        @Override
        public final Builder tokenStandard(String tokenStandard) {
            this.tokenStandard = tokenStandard;
            return this;
        }

        @Override
        public final Builder tokenStandard(QueryTokenStandard tokenStandard) {
            this.tokenStandard(tokenStandard == null ? null : tokenStandard.toString());
            return this;
        }

        public final String getDeployerAddress() {
            return deployerAddress;
        }

        public final void setDeployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
        }

        @Override
        public final Builder deployerAddress(String deployerAddress) {
            this.deployerAddress = deployerAddress;
            return this;
        }

        @Override
        public ContractFilter build() {
            return new ContractFilter(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
