/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetTransactionRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<GetTransactionRequest.Builder, GetTransactionRequest> {
    private static final SdkField<String> TRANSACTION_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionHash").getter(getter(GetTransactionRequest::transactionHash))
            .setter(setter(Builder::transactionHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionHash").build()).build();

    private static final SdkField<String> TRANSACTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("transactionId").getter(getter(GetTransactionRequest::transactionId))
            .setter(setter(Builder::transactionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("transactionId").build()).build();

    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(GetTransactionRequest::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSACTION_HASH_FIELD,
            TRANSACTION_ID_FIELD, NETWORK_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String transactionHash;

    private final String transactionId;

    private final String network;

    private GetTransactionRequest(BuilderImpl builder) {
        super(builder);
        this.transactionHash = builder.transactionHash;
        this.transactionId = builder.transactionId;
        this.network = builder.network;
    }

    /**
     * <p>
     * The hash of a transaction. It is generated when a transaction is created.
     * </p>
     * 
     * @return The hash of a transaction. It is generated when a transaction is created.
     */
    public final String transactionHash() {
        return transactionHash;
    }

    /**
     * <p>
     * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
     * </p>
     * <note>
     * <p>
     * <code>transactionId</code> is only supported on the Bitcoin networks.
     * </p>
     * </note>
     * 
     * @return The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p> <note>
     *         <p>
     *         <code>transactionId</code> is only supported on the Bitcoin networks.
     *         </p>
     */
    public final String transactionId() {
        return transactionId;
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network where the transaction occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transaction occurred.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(transactionHash());
        hashCode = 31 * hashCode + Objects.hashCode(transactionId());
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetTransactionRequest)) {
            return false;
        }
        GetTransactionRequest other = (GetTransactionRequest) obj;
        return Objects.equals(transactionHash(), other.transactionHash())
                && Objects.equals(transactionId(), other.transactionId())
                && Objects.equals(networkAsString(), other.networkAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetTransactionRequest").add("TransactionHash", transactionHash())
                .add("TransactionId", transactionId()).add("Network", networkAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "transactionHash":
            return Optional.ofNullable(clazz.cast(transactionHash()));
        case "transactionId":
            return Optional.ofNullable(clazz.cast(transactionId()));
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("transactionHash", TRANSACTION_HASH_FIELD);
        map.put("transactionId", TRANSACTION_ID_FIELD);
        map.put("network", NETWORK_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetTransactionRequest, T> g) {
        return obj -> g.apply((GetTransactionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, GetTransactionRequest> {
        /**
         * <p>
         * The hash of a transaction. It is generated when a transaction is created.
         * </p>
         * 
         * @param transactionHash
         *        The hash of a transaction. It is generated when a transaction is created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionHash(String transactionHash);

        /**
         * <p>
         * The identifier of a Bitcoin transaction. It is generated when a transaction is created.
         * </p>
         * <note>
         * <p>
         * <code>transactionId</code> is only supported on the Bitcoin networks.
         * </p>
         * </note>
         * 
         * @param transactionId
         *        The identifier of a Bitcoin transaction. It is generated when a transaction is created.</p> <note>
         *        <p>
         *        <code>transactionId</code> is only supported on the Bitcoin networks.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder transactionId(String transactionId);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network where the transaction occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transaction occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private String transactionHash;

        private String transactionId;

        private String network;

        private BuilderImpl() {
        }

        private BuilderImpl(GetTransactionRequest model) {
            super(model);
            transactionHash(model.transactionHash);
            transactionId(model.transactionId);
            network(model.network);
        }

        public final String getTransactionHash() {
            return transactionHash;
        }

        public final void setTransactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
        }

        @Override
        public final Builder transactionHash(String transactionHash) {
            this.transactionHash = transactionHash;
            return this;
        }

        public final String getTransactionId() {
            return transactionId;
        }

        public final void setTransactionId(String transactionId) {
            this.transactionId = transactionId;
        }

        @Override
        public final Builder transactionId(String transactionId) {
            this.transactionId = transactionId;
            return this;
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetTransactionRequest build() {
            return new GetTransactionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
