/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.managedblockchainquery.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTransactionsRequest extends ManagedBlockchainQueryRequest implements
        ToCopyableBuilder<ListTransactionsRequest.Builder, ListTransactionsRequest> {
    private static final SdkField<String> ADDRESS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("address")
            .getter(getter(ListTransactionsRequest::address)).setter(setter(Builder::address))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("address").build()).build();

    private static final SdkField<String> NETWORK_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("network")
            .getter(getter(ListTransactionsRequest::networkAsString)).setter(setter(Builder::network))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("network").build()).build();

    private static final SdkField<BlockchainInstant> FROM_BLOCKCHAIN_INSTANT_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("fromBlockchainInstant")
            .getter(getter(ListTransactionsRequest::fromBlockchainInstant)).setter(setter(Builder::fromBlockchainInstant))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fromBlockchainInstant").build())
            .build();

    private static final SdkField<BlockchainInstant> TO_BLOCKCHAIN_INSTANT_FIELD = SdkField
            .<BlockchainInstant> builder(MarshallingType.SDK_POJO).memberName("toBlockchainInstant")
            .getter(getter(ListTransactionsRequest::toBlockchainInstant)).setter(setter(Builder::toBlockchainInstant))
            .constructor(BlockchainInstant::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toBlockchainInstant").build())
            .build();

    private static final SdkField<ListTransactionsSort> SORT_FIELD = SdkField
            .<ListTransactionsSort> builder(MarshallingType.SDK_POJO).memberName("sort")
            .getter(getter(ListTransactionsRequest::sort)).setter(setter(Builder::sort))
            .constructor(ListTransactionsSort::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sort").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTransactionsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListTransactionsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()).build();

    private static final SdkField<ConfirmationStatusFilter> CONFIRMATION_STATUS_FILTER_FIELD = SdkField
            .<ConfirmationStatusFilter> builder(MarshallingType.SDK_POJO).memberName("confirmationStatusFilter")
            .getter(getter(ListTransactionsRequest::confirmationStatusFilter)).setter(setter(Builder::confirmationStatusFilter))
            .constructor(ConfirmationStatusFilter::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("confirmationStatusFilter").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ADDRESS_FIELD, NETWORK_FIELD,
            FROM_BLOCKCHAIN_INSTANT_FIELD, TO_BLOCKCHAIN_INSTANT_FIELD, SORT_FIELD, NEXT_TOKEN_FIELD, MAX_RESULTS_FIELD,
            CONFIRMATION_STATUS_FILTER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String address;

    private final String network;

    private final BlockchainInstant fromBlockchainInstant;

    private final BlockchainInstant toBlockchainInstant;

    private final ListTransactionsSort sort;

    private final String nextToken;

    private final Integer maxResults;

    private final ConfirmationStatusFilter confirmationStatusFilter;

    private ListTransactionsRequest(BuilderImpl builder) {
        super(builder);
        this.address = builder.address;
        this.network = builder.network;
        this.fromBlockchainInstant = builder.fromBlockchainInstant;
        this.toBlockchainInstant = builder.toBlockchainInstant;
        this.sort = builder.sort;
        this.nextToken = builder.nextToken;
        this.maxResults = builder.maxResults;
        this.confirmationStatusFilter = builder.confirmationStatusFilter;
    }

    /**
     * <p>
     * The address (either a contract or wallet), whose transactions are being requested.
     * </p>
     * 
     * @return The address (either a contract or wallet), whose transactions are being requested.
     */
    public final String address() {
        return address;
    }

    /**
     * <p>
     * The blockchain network where the transactions occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transactions occurred.
     * @see QueryNetwork
     */
    public final QueryNetwork network() {
        return QueryNetwork.fromValue(network);
    }

    /**
     * <p>
     * The blockchain network where the transactions occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #network} will
     * return {@link QueryNetwork#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #networkAsString}.
     * </p>
     * 
     * @return The blockchain network where the transactions occurred.
     * @see QueryNetwork
     */
    public final String networkAsString() {
        return network;
    }

    /**
     * Returns the value of the FromBlockchainInstant property for this object.
     * 
     * @return The value of the FromBlockchainInstant property for this object.
     */
    public final BlockchainInstant fromBlockchainInstant() {
        return fromBlockchainInstant;
    }

    /**
     * Returns the value of the ToBlockchainInstant property for this object.
     * 
     * @return The value of the ToBlockchainInstant property for this object.
     */
    public final BlockchainInstant toBlockchainInstant() {
        return toBlockchainInstant;
    }

    /**
     * <p>
     * The order by which the results will be sorted.
     * </p>
     * 
     * @return The order by which the results will be sorted.
     */
    public final ListTransactionsSort sort() {
        return sort;
    }

    /**
     * <p>
     * The pagination token that indicates the next set of results to retrieve.
     * </p>
     * 
     * @return The pagination token that indicates the next set of results to retrieve.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * The maximum number of transactions to list.
     * </p>
     * <p>
     * Default: <code>100</code>
     * </p>
     * <note>
     * <p>
     * Even if additional results can be retrieved, the request can return less results than <code>maxResults</code> or
     * an empty array of results.
     * </p>
     * <p>
     * To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The
     * value of <code>nextToken</code> is <code>null</code> when there are no more results to return
     * </p>
     * </note>
     * 
     * @return The maximum number of transactions to list.</p>
     *         <p>
     *         Default: <code>100</code>
     *         </p>
     *         <note>
     *         <p>
     *         Even if additional results can be retrieved, the request can return less results than
     *         <code>maxResults</code> or an empty array of results.
     *         </p>
     *         <p>
     *         To retrieve the next set of results, make another request with the returned <code>nextToken</code> value.
     *         The value of <code>nextToken</code> is <code>null</code> when there are no more results to return
     *         </p>
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * This filter is used to include transactions in the response that haven't reached <a
     * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality"> <i>finality</i>
     * </a>. Transactions that have reached finality are always part of the response.
     * </p>
     * 
     * @return This filter is used to include transactions in the response that haven't reached <a
     *         href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
     *         <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
     */
    public final ConfirmationStatusFilter confirmationStatusFilter() {
        return confirmationStatusFilter;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(address());
        hashCode = 31 * hashCode + Objects.hashCode(networkAsString());
        hashCode = 31 * hashCode + Objects.hashCode(fromBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(toBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(sort());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(confirmationStatusFilter());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTransactionsRequest)) {
            return false;
        }
        ListTransactionsRequest other = (ListTransactionsRequest) obj;
        return Objects.equals(address(), other.address()) && Objects.equals(networkAsString(), other.networkAsString())
                && Objects.equals(fromBlockchainInstant(), other.fromBlockchainInstant())
                && Objects.equals(toBlockchainInstant(), other.toBlockchainInstant()) && Objects.equals(sort(), other.sort())
                && Objects.equals(nextToken(), other.nextToken()) && Objects.equals(maxResults(), other.maxResults())
                && Objects.equals(confirmationStatusFilter(), other.confirmationStatusFilter());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTransactionsRequest").add("Address", address()).add("Network", networkAsString())
                .add("FromBlockchainInstant", fromBlockchainInstant()).add("ToBlockchainInstant", toBlockchainInstant())
                .add("Sort", sort()).add("NextToken", nextToken()).add("MaxResults", maxResults())
                .add("ConfirmationStatusFilter", confirmationStatusFilter()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "address":
            return Optional.ofNullable(clazz.cast(address()));
        case "network":
            return Optional.ofNullable(clazz.cast(networkAsString()));
        case "fromBlockchainInstant":
            return Optional.ofNullable(clazz.cast(fromBlockchainInstant()));
        case "toBlockchainInstant":
            return Optional.ofNullable(clazz.cast(toBlockchainInstant()));
        case "sort":
            return Optional.ofNullable(clazz.cast(sort()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "confirmationStatusFilter":
            return Optional.ofNullable(clazz.cast(confirmationStatusFilter()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("address", ADDRESS_FIELD);
        map.put("network", NETWORK_FIELD);
        map.put("fromBlockchainInstant", FROM_BLOCKCHAIN_INSTANT_FIELD);
        map.put("toBlockchainInstant", TO_BLOCKCHAIN_INSTANT_FIELD);
        map.put("sort", SORT_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("confirmationStatusFilter", CONFIRMATION_STATUS_FILTER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListTransactionsRequest, T> g) {
        return obj -> g.apply((ListTransactionsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ManagedBlockchainQueryRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, ListTransactionsRequest> {
        /**
         * <p>
         * The address (either a contract or wallet), whose transactions are being requested.
         * </p>
         * 
         * @param address
         *        The address (either a contract or wallet), whose transactions are being requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder address(String address);

        /**
         * <p>
         * The blockchain network where the transactions occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transactions occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(String network);

        /**
         * <p>
         * The blockchain network where the transactions occurred.
         * </p>
         * 
         * @param network
         *        The blockchain network where the transactions occurred.
         * @see QueryNetwork
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueryNetwork
         */
        Builder network(QueryNetwork network);

        /**
         * Sets the value of the FromBlockchainInstant property for this object.
         *
         * @param fromBlockchainInstant
         *        The new value for the FromBlockchainInstant property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fromBlockchainInstant(BlockchainInstant fromBlockchainInstant);

        /**
         * Sets the value of the FromBlockchainInstant property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #fromBlockchainInstant(BlockchainInstant)}.
         * 
         * @param fromBlockchainInstant
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fromBlockchainInstant(BlockchainInstant)
         */
        default Builder fromBlockchainInstant(Consumer<BlockchainInstant.Builder> fromBlockchainInstant) {
            return fromBlockchainInstant(BlockchainInstant.builder().applyMutation(fromBlockchainInstant).build());
        }

        /**
         * Sets the value of the ToBlockchainInstant property for this object.
         *
         * @param toBlockchainInstant
         *        The new value for the ToBlockchainInstant property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toBlockchainInstant(BlockchainInstant toBlockchainInstant);

        /**
         * Sets the value of the ToBlockchainInstant property for this object.
         *
         * This is a convenience method that creates an instance of the {@link BlockchainInstant.Builder} avoiding the
         * need to create one manually via {@link BlockchainInstant#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link BlockchainInstant.Builder#build()} is called immediately and its
         * result is passed to {@link #toBlockchainInstant(BlockchainInstant)}.
         * 
         * @param toBlockchainInstant
         *        a consumer that will call methods on {@link BlockchainInstant.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toBlockchainInstant(BlockchainInstant)
         */
        default Builder toBlockchainInstant(Consumer<BlockchainInstant.Builder> toBlockchainInstant) {
            return toBlockchainInstant(BlockchainInstant.builder().applyMutation(toBlockchainInstant).build());
        }

        /**
         * <p>
         * The order by which the results will be sorted.
         * </p>
         * 
         * @param sort
         *        The order by which the results will be sorted.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sort(ListTransactionsSort sort);

        /**
         * <p>
         * The order by which the results will be sorted.
         * </p>
         * This is a convenience method that creates an instance of the {@link ListTransactionsSort.Builder} avoiding
         * the need to create one manually via {@link ListTransactionsSort#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ListTransactionsSort.Builder#build()} is called immediately and
         * its result is passed to {@link #sort(ListTransactionsSort)}.
         * 
         * @param sort
         *        a consumer that will call methods on {@link ListTransactionsSort.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sort(ListTransactionsSort)
         */
        default Builder sort(Consumer<ListTransactionsSort.Builder> sort) {
            return sort(ListTransactionsSort.builder().applyMutation(sort).build());
        }

        /**
         * <p>
         * The pagination token that indicates the next set of results to retrieve.
         * </p>
         * 
         * @param nextToken
         *        The pagination token that indicates the next set of results to retrieve.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * The maximum number of transactions to list.
         * </p>
         * <p>
         * Default: <code>100</code>
         * </p>
         * <note>
         * <p>
         * Even if additional results can be retrieved, the request can return less results than <code>maxResults</code>
         * or an empty array of results.
         * </p>
         * <p>
         * To retrieve the next set of results, make another request with the returned <code>nextToken</code> value. The
         * value of <code>nextToken</code> is <code>null</code> when there are no more results to return
         * </p>
         * </note>
         * 
         * @param maxResults
         *        The maximum number of transactions to list.</p>
         *        <p>
         *        Default: <code>100</code>
         *        </p>
         *        <note>
         *        <p>
         *        Even if additional results can be retrieved, the request can return less results than
         *        <code>maxResults</code> or an empty array of results.
         *        </p>
         *        <p>
         *        To retrieve the next set of results, make another request with the returned <code>nextToken</code>
         *        value. The value of <code>nextToken</code> is <code>null</code> when there are no more results to
         *        return
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * This filter is used to include transactions in the response that haven't reached <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         * <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * </p>
         * 
         * @param confirmationStatusFilter
         *        This filter is used to include transactions in the response that haven't reached <a
         *        href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         *        <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder confirmationStatusFilter(ConfirmationStatusFilter confirmationStatusFilter);

        /**
         * <p>
         * This filter is used to include transactions in the response that haven't reached <a
         * href="https://docs.aws.amazon.com/managed-blockchain/latest/ambq-dg/key-concepts.html#finality">
         * <i>finality</i> </a>. Transactions that have reached finality are always part of the response.
         * </p>
         * This is a convenience method that creates an instance of the {@link ConfirmationStatusFilter.Builder}
         * avoiding the need to create one manually via {@link ConfirmationStatusFilter#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ConfirmationStatusFilter.Builder#build()} is called immediately
         * and its result is passed to {@link #confirmationStatusFilter(ConfirmationStatusFilter)}.
         * 
         * @param confirmationStatusFilter
         *        a consumer that will call methods on {@link ConfirmationStatusFilter.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #confirmationStatusFilter(ConfirmationStatusFilter)
         */
        default Builder confirmationStatusFilter(Consumer<ConfirmationStatusFilter.Builder> confirmationStatusFilter) {
            return confirmationStatusFilter(ConfirmationStatusFilter.builder().applyMutation(confirmationStatusFilter).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ManagedBlockchainQueryRequest.BuilderImpl implements Builder {
        private String address;

        private String network;

        private BlockchainInstant fromBlockchainInstant;

        private BlockchainInstant toBlockchainInstant;

        private ListTransactionsSort sort;

        private String nextToken;

        private Integer maxResults;

        private ConfirmationStatusFilter confirmationStatusFilter;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTransactionsRequest model) {
            super(model);
            address(model.address);
            network(model.network);
            fromBlockchainInstant(model.fromBlockchainInstant);
            toBlockchainInstant(model.toBlockchainInstant);
            sort(model.sort);
            nextToken(model.nextToken);
            maxResults(model.maxResults);
            confirmationStatusFilter(model.confirmationStatusFilter);
        }

        public final String getAddress() {
            return address;
        }

        public final void setAddress(String address) {
            this.address = address;
        }

        @Override
        public final Builder address(String address) {
            this.address = address;
            return this;
        }

        public final String getNetwork() {
            return network;
        }

        public final void setNetwork(String network) {
            this.network = network;
        }

        @Override
        public final Builder network(String network) {
            this.network = network;
            return this;
        }

        @Override
        public final Builder network(QueryNetwork network) {
            this.network(network == null ? null : network.toString());
            return this;
        }

        public final BlockchainInstant.Builder getFromBlockchainInstant() {
            return fromBlockchainInstant != null ? fromBlockchainInstant.toBuilder() : null;
        }

        public final void setFromBlockchainInstant(BlockchainInstant.BuilderImpl fromBlockchainInstant) {
            this.fromBlockchainInstant = fromBlockchainInstant != null ? fromBlockchainInstant.build() : null;
        }

        @Override
        public final Builder fromBlockchainInstant(BlockchainInstant fromBlockchainInstant) {
            this.fromBlockchainInstant = fromBlockchainInstant;
            return this;
        }

        public final BlockchainInstant.Builder getToBlockchainInstant() {
            return toBlockchainInstant != null ? toBlockchainInstant.toBuilder() : null;
        }

        public final void setToBlockchainInstant(BlockchainInstant.BuilderImpl toBlockchainInstant) {
            this.toBlockchainInstant = toBlockchainInstant != null ? toBlockchainInstant.build() : null;
        }

        @Override
        public final Builder toBlockchainInstant(BlockchainInstant toBlockchainInstant) {
            this.toBlockchainInstant = toBlockchainInstant;
            return this;
        }

        public final ListTransactionsSort.Builder getSort() {
            return sort != null ? sort.toBuilder() : null;
        }

        public final void setSort(ListTransactionsSort.BuilderImpl sort) {
            this.sort = sort != null ? sort.build() : null;
        }

        @Override
        public final Builder sort(ListTransactionsSort sort) {
            this.sort = sort;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final ConfirmationStatusFilter.Builder getConfirmationStatusFilter() {
            return confirmationStatusFilter != null ? confirmationStatusFilter.toBuilder() : null;
        }

        public final void setConfirmationStatusFilter(ConfirmationStatusFilter.BuilderImpl confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter != null ? confirmationStatusFilter.build() : null;
        }

        @Override
        public final Builder confirmationStatusFilter(ConfirmationStatusFilter confirmationStatusFilter) {
            this.confirmationStatusFilter = confirmationStatusFilter;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListTransactionsRequest build() {
            return new ListTransactionsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
