/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryAsyncClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTokenBalancesResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TokenBalance;

public class ListTokenBalancesPublisher
implements SdkPublisher<ListTokenBalancesResponse> {
    private final ManagedBlockchainQueryAsyncClient client;
    private final ListTokenBalancesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTokenBalancesPublisher(ManagedBlockchainQueryAsyncClient client, ListTokenBalancesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTokenBalancesPublisher(ManagedBlockchainQueryAsyncClient client, ListTokenBalancesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTokenBalancesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTokenBalancesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TokenBalance> tokenBalances() {
        Function<ListTokenBalancesResponse, Iterator> getIterator = response -> {
            if (response != null && response.tokenBalances() != null) {
                return response.tokenBalances().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTokenBalancesResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTokenBalancesResponseFetcher
    implements AsyncPageFetcher<ListTokenBalancesResponse> {
        private ListTokenBalancesResponseFetcher() {
        }

        public boolean hasNextPage(ListTokenBalancesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTokenBalancesResponse> nextPage(ListTokenBalancesResponse previousPage) {
            if (previousPage == null) {
                return ListTokenBalancesPublisher.this.client.listTokenBalances(ListTokenBalancesPublisher.this.firstRequest);
            }
            return ListTokenBalancesPublisher.this.client.listTokenBalances((ListTokenBalancesRequest)((Object)ListTokenBalancesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

