/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.managedblockchainquery.ManagedBlockchainQueryAsyncClient;
import software.amazon.awssdk.services.managedblockchainquery.internal.UserAgentUtils;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsRequest;
import software.amazon.awssdk.services.managedblockchainquery.model.ListTransactionsResponse;
import software.amazon.awssdk.services.managedblockchainquery.model.TransactionOutputItem;

public class ListTransactionsPublisher
implements SdkPublisher<ListTransactionsResponse> {
    private final ManagedBlockchainQueryAsyncClient client;
    private final ListTransactionsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTransactionsPublisher(ManagedBlockchainQueryAsyncClient client, ListTransactionsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTransactionsPublisher(ManagedBlockchainQueryAsyncClient client, ListTransactionsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTransactionsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTransactionsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TransactionOutputItem> transactions() {
        Function<ListTransactionsResponse, Iterator> getIterator = response -> {
            if (response != null && response.transactions() != null) {
                return response.transactions().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTransactionsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTransactionsResponseFetcher
    implements AsyncPageFetcher<ListTransactionsResponse> {
        private ListTransactionsResponseFetcher() {
        }

        public boolean hasNextPage(ListTransactionsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTransactionsResponse> nextPage(ListTransactionsResponse previousPage) {
            if (previousPage == null) {
                return ListTransactionsPublisher.this.client.listTransactions(ListTransactionsPublisher.this.firstRequest);
            }
            return ListTransactionsPublisher.this.client.listTransactions((ListTransactionsRequest)((Object)ListTransactionsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

