/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.managedblockchainquery.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.managedblockchainquery.model.BlockchainInstant;
import software.amazon.awssdk.services.managedblockchainquery.model.OwnerIdentifier;
import software.amazon.awssdk.services.managedblockchainquery.model.TokenIdentifier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class BatchGetTokenBalanceOutputItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, BatchGetTokenBalanceOutputItem> {
    private static final SdkField<OwnerIdentifier> OWNER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ownerIdentifier").getter(BatchGetTokenBalanceOutputItem.getter(BatchGetTokenBalanceOutputItem::ownerIdentifier)).setter(BatchGetTokenBalanceOutputItem.setter(Builder::ownerIdentifier)).constructor(OwnerIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerIdentifier").build()}).build();
    private static final SdkField<TokenIdentifier> TOKEN_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("tokenIdentifier").getter(BatchGetTokenBalanceOutputItem.getter(BatchGetTokenBalanceOutputItem::tokenIdentifier)).setter(BatchGetTokenBalanceOutputItem.setter(Builder::tokenIdentifier)).constructor(TokenIdentifier::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tokenIdentifier").build()}).build();
    private static final SdkField<String> BALANCE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("balance").getter(BatchGetTokenBalanceOutputItem.getter(BatchGetTokenBalanceOutputItem::balance)).setter(BatchGetTokenBalanceOutputItem.setter(Builder::balance)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("balance").build()}).build();
    private static final SdkField<BlockchainInstant> AT_BLOCKCHAIN_INSTANT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("atBlockchainInstant").getter(BatchGetTokenBalanceOutputItem.getter(BatchGetTokenBalanceOutputItem::atBlockchainInstant)).setter(BatchGetTokenBalanceOutputItem.setter(Builder::atBlockchainInstant)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("atBlockchainInstant").build()}).build();
    private static final SdkField<BlockchainInstant> LAST_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lastUpdatedTime").getter(BatchGetTokenBalanceOutputItem.getter(BatchGetTokenBalanceOutputItem::lastUpdatedTime)).setter(BatchGetTokenBalanceOutputItem.setter(Builder::lastUpdatedTime)).constructor(BlockchainInstant::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedTime").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OWNER_IDENTIFIER_FIELD, TOKEN_IDENTIFIER_FIELD, BALANCE_FIELD, AT_BLOCKCHAIN_INSTANT_FIELD, LAST_UPDATED_TIME_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = BatchGetTokenBalanceOutputItem.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final OwnerIdentifier ownerIdentifier;
    private final TokenIdentifier tokenIdentifier;
    private final String balance;
    private final BlockchainInstant atBlockchainInstant;
    private final BlockchainInstant lastUpdatedTime;

    private BatchGetTokenBalanceOutputItem(BuilderImpl builder) {
        this.ownerIdentifier = builder.ownerIdentifier;
        this.tokenIdentifier = builder.tokenIdentifier;
        this.balance = builder.balance;
        this.atBlockchainInstant = builder.atBlockchainInstant;
        this.lastUpdatedTime = builder.lastUpdatedTime;
    }

    public final OwnerIdentifier ownerIdentifier() {
        return this.ownerIdentifier;
    }

    public final TokenIdentifier tokenIdentifier() {
        return this.tokenIdentifier;
    }

    public final String balance() {
        return this.balance;
    }

    public final BlockchainInstant atBlockchainInstant() {
        return this.atBlockchainInstant;
    }

    public final BlockchainInstant lastUpdatedTime() {
        return this.lastUpdatedTime;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.tokenIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.balance());
        hashCode = 31 * hashCode + Objects.hashCode(this.atBlockchainInstant());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedTime());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchGetTokenBalanceOutputItem)) {
            return false;
        }
        BatchGetTokenBalanceOutputItem other = (BatchGetTokenBalanceOutputItem)obj;
        return Objects.equals(this.ownerIdentifier(), other.ownerIdentifier()) && Objects.equals(this.tokenIdentifier(), other.tokenIdentifier()) && Objects.equals(this.balance(), other.balance()) && Objects.equals(this.atBlockchainInstant(), other.atBlockchainInstant()) && Objects.equals(this.lastUpdatedTime(), other.lastUpdatedTime());
    }

    public final String toString() {
        return ToString.builder((String)"BatchGetTokenBalanceOutputItem").add("OwnerIdentifier", (Object)this.ownerIdentifier()).add("TokenIdentifier", (Object)this.tokenIdentifier()).add("Balance", (Object)this.balance()).add("AtBlockchainInstant", (Object)this.atBlockchainInstant()).add("LastUpdatedTime", (Object)this.lastUpdatedTime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "ownerIdentifier": {
                return Optional.ofNullable(clazz.cast(this.ownerIdentifier()));
            }
            case "tokenIdentifier": {
                return Optional.ofNullable(clazz.cast(this.tokenIdentifier()));
            }
            case "balance": {
                return Optional.ofNullable(clazz.cast(this.balance()));
            }
            case "atBlockchainInstant": {
                return Optional.ofNullable(clazz.cast(this.atBlockchainInstant()));
            }
            case "lastUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedTime()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("ownerIdentifier", OWNER_IDENTIFIER_FIELD);
        map.put("tokenIdentifier", TOKEN_IDENTIFIER_FIELD);
        map.put("balance", BALANCE_FIELD);
        map.put("atBlockchainInstant", AT_BLOCKCHAIN_INSTANT_FIELD);
        map.put("lastUpdatedTime", LAST_UPDATED_TIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<BatchGetTokenBalanceOutputItem, T> g) {
        return obj -> g.apply((BatchGetTokenBalanceOutputItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private OwnerIdentifier ownerIdentifier;
        private TokenIdentifier tokenIdentifier;
        private String balance;
        private BlockchainInstant atBlockchainInstant;
        private BlockchainInstant lastUpdatedTime;

        private BuilderImpl() {
        }

        private BuilderImpl(BatchGetTokenBalanceOutputItem model) {
            this.ownerIdentifier(model.ownerIdentifier);
            this.tokenIdentifier(model.tokenIdentifier);
            this.balance(model.balance);
            this.atBlockchainInstant(model.atBlockchainInstant);
            this.lastUpdatedTime(model.lastUpdatedTime);
        }

        public final OwnerIdentifier.Builder getOwnerIdentifier() {
            return this.ownerIdentifier != null ? this.ownerIdentifier.toBuilder() : null;
        }

        public final void setOwnerIdentifier(OwnerIdentifier.BuilderImpl ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier != null ? ownerIdentifier.build() : null;
        }

        @Override
        public final Builder ownerIdentifier(OwnerIdentifier ownerIdentifier) {
            this.ownerIdentifier = ownerIdentifier;
            return this;
        }

        public final TokenIdentifier.Builder getTokenIdentifier() {
            return this.tokenIdentifier != null ? this.tokenIdentifier.toBuilder() : null;
        }

        public final void setTokenIdentifier(TokenIdentifier.BuilderImpl tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier != null ? tokenIdentifier.build() : null;
        }

        @Override
        public final Builder tokenIdentifier(TokenIdentifier tokenIdentifier) {
            this.tokenIdentifier = tokenIdentifier;
            return this;
        }

        public final String getBalance() {
            return this.balance;
        }

        public final void setBalance(String balance) {
            this.balance = balance;
        }

        @Override
        public final Builder balance(String balance) {
            this.balance = balance;
            return this;
        }

        public final BlockchainInstant.Builder getAtBlockchainInstant() {
            return this.atBlockchainInstant != null ? this.atBlockchainInstant.toBuilder() : null;
        }

        public final void setAtBlockchainInstant(BlockchainInstant.BuilderImpl atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant != null ? atBlockchainInstant.build() : null;
        }

        @Override
        public final Builder atBlockchainInstant(BlockchainInstant atBlockchainInstant) {
            this.atBlockchainInstant = atBlockchainInstant;
            return this;
        }

        public final BlockchainInstant.Builder getLastUpdatedTime() {
            return this.lastUpdatedTime != null ? this.lastUpdatedTime.toBuilder() : null;
        }

        public final void setLastUpdatedTime(BlockchainInstant.BuilderImpl lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime != null ? lastUpdatedTime.build() : null;
        }

        @Override
        public final Builder lastUpdatedTime(BlockchainInstant lastUpdatedTime) {
            this.lastUpdatedTime = lastUpdatedTime;
            return this;
        }

        public BatchGetTokenBalanceOutputItem build() {
            return new BatchGetTokenBalanceOutputItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, BatchGetTokenBalanceOutputItem> {
        public Builder ownerIdentifier(OwnerIdentifier var1);

        default public Builder ownerIdentifier(Consumer<OwnerIdentifier.Builder> ownerIdentifier) {
            return this.ownerIdentifier((OwnerIdentifier)((OwnerIdentifier.Builder)OwnerIdentifier.builder().applyMutation(ownerIdentifier)).build());
        }

        public Builder tokenIdentifier(TokenIdentifier var1);

        default public Builder tokenIdentifier(Consumer<TokenIdentifier.Builder> tokenIdentifier) {
            return this.tokenIdentifier((TokenIdentifier)((TokenIdentifier.Builder)TokenIdentifier.builder().applyMutation(tokenIdentifier)).build());
        }

        public Builder balance(String var1);

        public Builder atBlockchainInstant(BlockchainInstant var1);

        default public Builder atBlockchainInstant(Consumer<BlockchainInstant.Builder> atBlockchainInstant) {
            return this.atBlockchainInstant((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(atBlockchainInstant)).build());
        }

        public Builder lastUpdatedTime(BlockchainInstant var1);

        default public Builder lastUpdatedTime(Consumer<BlockchainInstant.Builder> lastUpdatedTime) {
            return this.lastUpdatedTime((BlockchainInstant)((BlockchainInstant.Builder)BlockchainInstant.builder().applyMutation(lastUpdatedTime)).build());
        }
    }
}

