/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.marketplaceagreement.MarketplaceAgreementAsyncClient;
import software.amazon.awssdk.services.marketplaceagreement.internal.UserAgentUtils;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsRequest;
import software.amazon.awssdk.services.marketplaceagreement.model.SearchAgreementsResponse;

public class SearchAgreementsPublisher
implements SdkPublisher<SearchAgreementsResponse> {
    private final MarketplaceAgreementAsyncClient client;
    private final SearchAgreementsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public SearchAgreementsPublisher(MarketplaceAgreementAsyncClient client, SearchAgreementsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private SearchAgreementsPublisher(MarketplaceAgreementAsyncClient client, SearchAgreementsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new SearchAgreementsResponseFetcher();
    }

    public void subscribe(Subscriber<? super SearchAgreementsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class SearchAgreementsResponseFetcher
    implements AsyncPageFetcher<SearchAgreementsResponse> {
        private SearchAgreementsResponseFetcher() {
        }

        public boolean hasNextPage(SearchAgreementsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<SearchAgreementsResponse> nextPage(SearchAgreementsResponse previousPage) {
            if (previousPage == null) {
                return SearchAgreementsPublisher.this.client.searchAgreements(SearchAgreementsPublisher.this.firstRequest);
            }
            return SearchAgreementsPublisher.this.client.searchAgreements((SearchAgreementsRequest)((Object)SearchAgreementsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

