/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines limits on how the term can be configured by acceptors.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Constraints implements SdkPojo, Serializable, ToCopyableBuilder<Constraints.Builder, Constraints> {
    private static final SdkField<String> MULTIPLE_DIMENSION_SELECTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("multipleDimensionSelection")
            .getter(getter(Constraints::multipleDimensionSelection))
            .setter(setter(Builder::multipleDimensionSelection))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("multipleDimensionSelection").build())
            .build();

    private static final SdkField<String> QUANTITY_CONFIGURATION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("quantityConfiguration").getter(getter(Constraints::quantityConfiguration))
            .setter(setter(Builder::quantityConfiguration))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("quantityConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            MULTIPLE_DIMENSION_SELECTION_FIELD, QUANTITY_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String multipleDimensionSelection;

    private final String quantityConfiguration;

    private Constraints(BuilderImpl builder) {
        this.multipleDimensionSelection = builder.multipleDimensionSelection;
        this.quantityConfiguration = builder.quantityConfiguration;
    }

    /**
     * <p>
     * Determines if buyers are allowed to select multiple dimensions in the rate card. The possible values are
     * <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
     * </p>
     * 
     * @return Determines if buyers are allowed to select multiple dimensions in the rate card. The possible values are
     *         <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
     */
    public final String multipleDimensionSelection() {
        return multipleDimensionSelection;
    }

    /**
     * <p>
     * Determines if acceptors are allowed to configure quantity for each dimension in rate card. The possible values
     * are <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
     * </p>
     * 
     * @return Determines if acceptors are allowed to configure quantity for each dimension in rate card. The possible
     *         values are <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
     */
    public final String quantityConfiguration() {
        return quantityConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(multipleDimensionSelection());
        hashCode = 31 * hashCode + Objects.hashCode(quantityConfiguration());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Constraints)) {
            return false;
        }
        Constraints other = (Constraints) obj;
        return Objects.equals(multipleDimensionSelection(), other.multipleDimensionSelection())
                && Objects.equals(quantityConfiguration(), other.quantityConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Constraints").add("MultipleDimensionSelection", multipleDimensionSelection())
                .add("QuantityConfiguration", quantityConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "multipleDimensionSelection":
            return Optional.ofNullable(clazz.cast(multipleDimensionSelection()));
        case "quantityConfiguration":
            return Optional.ofNullable(clazz.cast(quantityConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Constraints, T> g) {
        return obj -> g.apply((Constraints) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Constraints> {
        /**
         * <p>
         * Determines if buyers are allowed to select multiple dimensions in the rate card. The possible values are
         * <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
         * </p>
         * 
         * @param multipleDimensionSelection
         *        Determines if buyers are allowed to select multiple dimensions in the rate card. The possible values
         *        are <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder multipleDimensionSelection(String multipleDimensionSelection);

        /**
         * <p>
         * Determines if acceptors are allowed to configure quantity for each dimension in rate card. The possible
         * values are <code>Allowed</code> and <code>Disallowed</code>. The default value is <code>Allowed</code>.
         * </p>
         * 
         * @param quantityConfiguration
         *        Determines if acceptors are allowed to configure quantity for each dimension in rate card. The
         *        possible values are <code>Allowed</code> and <code>Disallowed</code>. The default value is
         *        <code>Allowed</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder quantityConfiguration(String quantityConfiguration);
    }

    static final class BuilderImpl implements Builder {
        private String multipleDimensionSelection;

        private String quantityConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Constraints model) {
            multipleDimensionSelection(model.multipleDimensionSelection);
            quantityConfiguration(model.quantityConfiguration);
        }

        public final String getMultipleDimensionSelection() {
            return multipleDimensionSelection;
        }

        public final void setMultipleDimensionSelection(String multipleDimensionSelection) {
            this.multipleDimensionSelection = multipleDimensionSelection;
        }

        @Override
        public final Builder multipleDimensionSelection(String multipleDimensionSelection) {
            this.multipleDimensionSelection = multipleDimensionSelection;
            return this;
        }

        public final String getQuantityConfiguration() {
            return quantityConfiguration;
        }

        public final void setQuantityConfiguration(String quantityConfiguration) {
            this.quantityConfiguration = quantityConfiguration;
        }

        @Override
        public final Builder quantityConfiguration(String quantityConfiguration) {
            this.quantityConfiguration = quantityConfiguration;
            return this;
        }

        @Override
        public Constraints build() {
            return new Constraints(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
