/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a pricing model where customers are charged a fixed recurring price at the end of each billing period.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class RecurringPaymentTerm implements SdkPojo, Serializable,
        ToCopyableBuilder<RecurringPaymentTerm.Builder, RecurringPaymentTerm> {
    private static final SdkField<String> BILLING_PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("billingPeriod").getter(getter(RecurringPaymentTerm::billingPeriod))
            .setter(setter(Builder::billingPeriod))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("billingPeriod").build()).build();

    private static final SdkField<String> CURRENCY_CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("currencyCode").getter(getter(RecurringPaymentTerm::currencyCode)).setter(setter(Builder::currencyCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("currencyCode").build()).build();

    private static final SdkField<String> PRICE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("price")
            .getter(getter(RecurringPaymentTerm::price)).setter(setter(Builder::price))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("price").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(RecurringPaymentTerm::type)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BILLING_PERIOD_FIELD,
            CURRENCY_CODE_FIELD, PRICE_FIELD, TYPE_FIELD));

    private static final long serialVersionUID = 1L;

    private final String billingPeriod;

    private final String currencyCode;

    private final String price;

    private final String type;

    private RecurringPaymentTerm(BuilderImpl builder) {
        this.billingPeriod = builder.billingPeriod;
        this.currencyCode = builder.currencyCode;
        this.price = builder.price;
        this.type = builder.type;
    }

    /**
     * <p>
     * Defines the recurrence at which buyers are charged.
     * </p>
     * 
     * @return Defines the recurrence at which buyers are charged.
     */
    public final String billingPeriod() {
        return billingPeriod;
    }

    /**
     * <p>
     * Defines the currency for the prices mentioned in this term.
     * </p>
     * 
     * @return Defines the currency for the prices mentioned in this term.
     */
    public final String currencyCode() {
        return currencyCode;
    }

    /**
     * <p>
     * Amount charged to the buyer every billing period.
     * </p>
     * 
     * @return Amount charged to the buyer every billing period.
     */
    public final String price() {
        return price;
    }

    /**
     * <p>
     * Type of the term being updated.
     * </p>
     * 
     * @return Type of the term being updated.
     */
    public final String type() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(billingPeriod());
        hashCode = 31 * hashCode + Objects.hashCode(currencyCode());
        hashCode = 31 * hashCode + Objects.hashCode(price());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecurringPaymentTerm)) {
            return false;
        }
        RecurringPaymentTerm other = (RecurringPaymentTerm) obj;
        return Objects.equals(billingPeriod(), other.billingPeriod()) && Objects.equals(currencyCode(), other.currencyCode())
                && Objects.equals(price(), other.price()) && Objects.equals(type(), other.type());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("RecurringPaymentTerm").add("BillingPeriod", billingPeriod()).add("CurrencyCode", currencyCode())
                .add("Price", price()).add("Type", type()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "billingPeriod":
            return Optional.ofNullable(clazz.cast(billingPeriod()));
        case "currencyCode":
            return Optional.ofNullable(clazz.cast(currencyCode()));
        case "price":
            return Optional.ofNullable(clazz.cast(price()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RecurringPaymentTerm, T> g) {
        return obj -> g.apply((RecurringPaymentTerm) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, RecurringPaymentTerm> {
        /**
         * <p>
         * Defines the recurrence at which buyers are charged.
         * </p>
         * 
         * @param billingPeriod
         *        Defines the recurrence at which buyers are charged.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder billingPeriod(String billingPeriod);

        /**
         * <p>
         * Defines the currency for the prices mentioned in this term.
         * </p>
         * 
         * @param currencyCode
         *        Defines the currency for the prices mentioned in this term.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder currencyCode(String currencyCode);

        /**
         * <p>
         * Amount charged to the buyer every billing period.
         * </p>
         * 
         * @param price
         *        Amount charged to the buyer every billing period.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder price(String price);

        /**
         * <p>
         * Type of the term being updated.
         * </p>
         * 
         * @param type
         *        Type of the term being updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(String type);
    }

    static final class BuilderImpl implements Builder {
        private String billingPeriod;

        private String currencyCode;

        private String price;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(RecurringPaymentTerm model) {
            billingPeriod(model.billingPeriod);
            currencyCode(model.currencyCode);
            price(model.price);
            type(model.type);
        }

        public final String getBillingPeriod() {
            return billingPeriod;
        }

        public final void setBillingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
        }

        @Override
        public final Builder billingPeriod(String billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        public final String getCurrencyCode() {
            return currencyCode;
        }

        public final void setCurrencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
        }

        @Override
        public final Builder currencyCode(String currencyCode) {
            this.currencyCode = currencyCode;
            return this;
        }

        public final String getPrice() {
            return price;
        }

        public final void setPrice(String price) {
            this.price = price;
        }

        @Override
        public final Builder price(String price) {
            this.price = price;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public RecurringPaymentTerm build() {
            return new RecurringPaymentTerm(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
