/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.marketplaceagreement.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.marketplaceagreement.model.Constraints;
import software.amazon.awssdk.services.marketplaceagreement.model.RateCardItem;
import software.amazon.awssdk.services.marketplaceagreement.model.RateCardListCopier;
import software.amazon.awssdk.services.marketplaceagreement.model.Selector;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ConfigurableUpfrontRateCardItem
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ConfigurableUpfrontRateCardItem> {
    private static final SdkField<Constraints> CONSTRAINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("constraints").getter(ConfigurableUpfrontRateCardItem.getter(ConfigurableUpfrontRateCardItem::constraints)).setter(ConfigurableUpfrontRateCardItem.setter(Builder::constraints)).constructor(Constraints::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("constraints").build()}).build();
    private static final SdkField<List<RateCardItem>> RATE_CARD_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("rateCard").getter(ConfigurableUpfrontRateCardItem.getter(ConfigurableUpfrontRateCardItem::rateCard)).setter(ConfigurableUpfrontRateCardItem.setter(Builder::rateCard)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rateCard").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RateCardItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Selector> SELECTOR_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("selector").getter(ConfigurableUpfrontRateCardItem.getter(ConfigurableUpfrontRateCardItem::selector)).setter(ConfigurableUpfrontRateCardItem.setter(Builder::selector)).constructor(Selector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("selector").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONSTRAINTS_FIELD, RATE_CARD_FIELD, SELECTOR_FIELD));
    private static final long serialVersionUID = 1L;
    private final Constraints constraints;
    private final List<RateCardItem> rateCard;
    private final Selector selector;

    private ConfigurableUpfrontRateCardItem(BuilderImpl builder) {
        this.constraints = builder.constraints;
        this.rateCard = builder.rateCard;
        this.selector = builder.selector;
    }

    public final Constraints constraints() {
        return this.constraints;
    }

    public final boolean hasRateCard() {
        return this.rateCard != null && !(this.rateCard instanceof SdkAutoConstructList);
    }

    public final List<RateCardItem> rateCard() {
        return this.rateCard;
    }

    public final Selector selector() {
        return this.selector;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.constraints());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRateCard() ? this.rateCard() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.selector());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableUpfrontRateCardItem)) {
            return false;
        }
        ConfigurableUpfrontRateCardItem other = (ConfigurableUpfrontRateCardItem)obj;
        return Objects.equals(this.constraints(), other.constraints()) && this.hasRateCard() == other.hasRateCard() && Objects.equals(this.rateCard(), other.rateCard()) && Objects.equals(this.selector(), other.selector());
    }

    public final String toString() {
        return ToString.builder((String)"ConfigurableUpfrontRateCardItem").add("Constraints", (Object)this.constraints()).add("RateCard", this.hasRateCard() ? this.rateCard() : null).add("Selector", (Object)this.selector()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "constraints": {
                return Optional.ofNullable(clazz.cast(this.constraints()));
            }
            case "rateCard": {
                return Optional.ofNullable(clazz.cast(this.rateCard()));
            }
            case "selector": {
                return Optional.ofNullable(clazz.cast(this.selector()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ConfigurableUpfrontRateCardItem, T> g) {
        return obj -> g.apply((ConfigurableUpfrontRateCardItem)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Constraints constraints;
        private List<RateCardItem> rateCard = DefaultSdkAutoConstructList.getInstance();
        private Selector selector;

        private BuilderImpl() {
        }

        private BuilderImpl(ConfigurableUpfrontRateCardItem model) {
            this.constraints(model.constraints);
            this.rateCard(model.rateCard);
            this.selector(model.selector);
        }

        public final Constraints.Builder getConstraints() {
            return this.constraints != null ? this.constraints.toBuilder() : null;
        }

        public final void setConstraints(Constraints.BuilderImpl constraints) {
            this.constraints = constraints != null ? constraints.build() : null;
        }

        @Override
        public final Builder constraints(Constraints constraints) {
            this.constraints = constraints;
            return this;
        }

        public final List<RateCardItem.Builder> getRateCard() {
            List<RateCardItem.Builder> result = RateCardListCopier.copyToBuilder(this.rateCard);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRateCard(Collection<RateCardItem.BuilderImpl> rateCard) {
            this.rateCard = RateCardListCopier.copyFromBuilder(rateCard);
        }

        @Override
        public final Builder rateCard(Collection<RateCardItem> rateCard) {
            this.rateCard = RateCardListCopier.copy(rateCard);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(RateCardItem ... rateCard) {
            this.rateCard(Arrays.asList(rateCard));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder rateCard(Consumer<RateCardItem.Builder> ... rateCard) {
            this.rateCard(Stream.of(rateCard).map(c -> (RateCardItem)((RateCardItem.Builder)RateCardItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Selector.Builder getSelector() {
            return this.selector != null ? this.selector.toBuilder() : null;
        }

        public final void setSelector(Selector.BuilderImpl selector) {
            this.selector = selector != null ? selector.build() : null;
        }

        @Override
        public final Builder selector(Selector selector) {
            this.selector = selector;
            return this;
        }

        public ConfigurableUpfrontRateCardItem build() {
            return new ConfigurableUpfrontRateCardItem(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ConfigurableUpfrontRateCardItem> {
        public Builder constraints(Constraints var1);

        default public Builder constraints(Consumer<Constraints.Builder> constraints) {
            return this.constraints((Constraints)((Constraints.Builder)Constraints.builder().applyMutation(constraints)).build());
        }

        public Builder rateCard(Collection<RateCardItem> var1);

        public Builder rateCard(RateCardItem ... var1);

        public Builder rateCard(Consumer<RateCardItem.Builder> ... var1);

        public Builder selector(Selector var1);

        default public Builder selector(Consumer<Selector.Builder> selector) {
            return this.selector((Selector)((Selector.Builder)Selector.builder().applyMutation(selector)).build());
        }
    }
}

